/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Edge;

@SdkInternalApi
public class EdgeMarshaller {
    private static final MarshallingInfo<Integer> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<StructuredPojo> SUMMARYSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryStatistics").build();
    private static final MarshallingInfo<List> RESPONSETIMEHISTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTimeHistogram").build();
    private static final MarshallingInfo<List> ALIASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aliases").build();
    private static final EdgeMarshaller instance = new EdgeMarshaller();

    public static EdgeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Edge edge, ProtocolMarshaller protocolMarshaller) {
        if (edge == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)edge.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)edge.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)edge.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)edge.summaryStatistics(), SUMMARYSTATISTICS_BINDING);
            protocolMarshaller.marshall(edge.responseTimeHistogram(), RESPONSETIMEHISTOGRAM_BINDING);
            protocolMarshaller.marshall(edge.aliases(), ALIASES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

