/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;
import software.amazon.awssdk.services.xray.model.FaultStatistics;
import software.amazon.awssdk.services.xray.transform.ServiceStatisticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, ServiceStatistics> {
    private final Long okCount;
    private final ErrorStatistics errorStatistics;
    private final FaultStatistics faultStatistics;
    private final Long totalCount;
    private final Double totalResponseTime;

    private ServiceStatistics(BuilderImpl builder) {
        this.okCount = builder.okCount;
        this.errorStatistics = builder.errorStatistics;
        this.faultStatistics = builder.faultStatistics;
        this.totalCount = builder.totalCount;
        this.totalResponseTime = builder.totalResponseTime;
    }

    public Long okCount() {
        return this.okCount;
    }

    public ErrorStatistics errorStatistics() {
        return this.errorStatistics;
    }

    public FaultStatistics faultStatistics() {
        return this.faultStatistics;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Double totalResponseTime() {
        return this.totalResponseTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.okCount() == null ? 0 : this.okCount().hashCode());
        hashCode = 31 * hashCode + (this.errorStatistics() == null ? 0 : this.errorStatistics().hashCode());
        hashCode = 31 * hashCode + (this.faultStatistics() == null ? 0 : this.faultStatistics().hashCode());
        hashCode = 31 * hashCode + (this.totalCount() == null ? 0 : this.totalCount().hashCode());
        hashCode = 31 * hashCode + (this.totalResponseTime() == null ? 0 : this.totalResponseTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceStatistics)) {
            return false;
        }
        ServiceStatistics other = (ServiceStatistics)obj;
        if (other.okCount() == null ^ this.okCount() == null) {
            return false;
        }
        if (other.okCount() != null && !other.okCount().equals(this.okCount())) {
            return false;
        }
        if (other.errorStatistics() == null ^ this.errorStatistics() == null) {
            return false;
        }
        if (other.errorStatistics() != null && !other.errorStatistics().equals(this.errorStatistics())) {
            return false;
        }
        if (other.faultStatistics() == null ^ this.faultStatistics() == null) {
            return false;
        }
        if (other.faultStatistics() != null && !other.faultStatistics().equals(this.faultStatistics())) {
            return false;
        }
        if (other.totalCount() == null ^ this.totalCount() == null) {
            return false;
        }
        if (other.totalCount() != null && !other.totalCount().equals(this.totalCount())) {
            return false;
        }
        if (other.totalResponseTime() == null ^ this.totalResponseTime() == null) {
            return false;
        }
        return other.totalResponseTime() == null || other.totalResponseTime().equals(this.totalResponseTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.okCount() != null) {
            sb.append("OkCount: ").append(this.okCount()).append(",");
        }
        if (this.errorStatistics() != null) {
            sb.append("ErrorStatistics: ").append(this.errorStatistics()).append(",");
        }
        if (this.faultStatistics() != null) {
            sb.append("FaultStatistics: ").append(this.faultStatistics()).append(",");
        }
        if (this.totalCount() != null) {
            sb.append("TotalCount: ").append(this.totalCount()).append(",");
        }
        if (this.totalResponseTime() != null) {
            sb.append("TotalResponseTime: ").append(this.totalResponseTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long okCount;
        private ErrorStatistics errorStatistics;
        private FaultStatistics faultStatistics;
        private Long totalCount;
        private Double totalResponseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceStatistics model) {
            this.setOkCount(model.okCount);
            this.setErrorStatistics(model.errorStatistics);
            this.setFaultStatistics(model.faultStatistics);
            this.setTotalCount(model.totalCount);
            this.setTotalResponseTime(model.totalResponseTime);
        }

        public final Long getOkCount() {
            return this.okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        public final ErrorStatistics getErrorStatistics() {
            return this.errorStatistics;
        }

        @Override
        public final Builder errorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
            return this;
        }

        public final void setErrorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
        }

        public final FaultStatistics getFaultStatistics() {
            return this.faultStatistics;
        }

        @Override
        public final Builder faultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
            return this;
        }

        public final void setFaultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public final Double getTotalResponseTime() {
            return this.totalResponseTime;
        }

        @Override
        public final Builder totalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
            return this;
        }

        public final void setTotalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
        }

        public ServiceStatistics build() {
            return new ServiceStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceStatistics> {
        public Builder okCount(Long var1);

        public Builder errorStatistics(ErrorStatistics var1);

        public Builder faultStatistics(FaultStatistics var1);

        public Builder totalCount(Long var1);

        public Builder totalResponseTime(Double var1);
    }
}

