/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.BackendConnectionErrorsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BackendConnectionErrors
implements StructuredPojo,
ToCopyableBuilder<Builder, BackendConnectionErrors> {
    private final Integer timeoutCount;
    private final Integer connectionRefusedCount;
    private final Integer httpCode4XXCount;
    private final Integer httpCode5XXCount;
    private final Integer unknownHostCount;
    private final Integer otherCount;

    private BackendConnectionErrors(BuilderImpl builder) {
        this.timeoutCount = builder.timeoutCount;
        this.connectionRefusedCount = builder.connectionRefusedCount;
        this.httpCode4XXCount = builder.httpCode4XXCount;
        this.httpCode5XXCount = builder.httpCode5XXCount;
        this.unknownHostCount = builder.unknownHostCount;
        this.otherCount = builder.otherCount;
    }

    public Integer timeoutCount() {
        return this.timeoutCount;
    }

    public Integer connectionRefusedCount() {
        return this.connectionRefusedCount;
    }

    public Integer httpCode4XXCount() {
        return this.httpCode4XXCount;
    }

    public Integer httpCode5XXCount() {
        return this.httpCode5XXCount;
    }

    public Integer unknownHostCount() {
        return this.unknownHostCount;
    }

    public Integer otherCount() {
        return this.otherCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timeoutCount() == null ? 0 : this.timeoutCount().hashCode());
        hashCode = 31 * hashCode + (this.connectionRefusedCount() == null ? 0 : this.connectionRefusedCount().hashCode());
        hashCode = 31 * hashCode + (this.httpCode4XXCount() == null ? 0 : this.httpCode4XXCount().hashCode());
        hashCode = 31 * hashCode + (this.httpCode5XXCount() == null ? 0 : this.httpCode5XXCount().hashCode());
        hashCode = 31 * hashCode + (this.unknownHostCount() == null ? 0 : this.unknownHostCount().hashCode());
        hashCode = 31 * hashCode + (this.otherCount() == null ? 0 : this.otherCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendConnectionErrors)) {
            return false;
        }
        BackendConnectionErrors other = (BackendConnectionErrors)obj;
        if (other.timeoutCount() == null ^ this.timeoutCount() == null) {
            return false;
        }
        if (other.timeoutCount() != null && !other.timeoutCount().equals(this.timeoutCount())) {
            return false;
        }
        if (other.connectionRefusedCount() == null ^ this.connectionRefusedCount() == null) {
            return false;
        }
        if (other.connectionRefusedCount() != null && !other.connectionRefusedCount().equals(this.connectionRefusedCount())) {
            return false;
        }
        if (other.httpCode4XXCount() == null ^ this.httpCode4XXCount() == null) {
            return false;
        }
        if (other.httpCode4XXCount() != null && !other.httpCode4XXCount().equals(this.httpCode4XXCount())) {
            return false;
        }
        if (other.httpCode5XXCount() == null ^ this.httpCode5XXCount() == null) {
            return false;
        }
        if (other.httpCode5XXCount() != null && !other.httpCode5XXCount().equals(this.httpCode5XXCount())) {
            return false;
        }
        if (other.unknownHostCount() == null ^ this.unknownHostCount() == null) {
            return false;
        }
        if (other.unknownHostCount() != null && !other.unknownHostCount().equals(this.unknownHostCount())) {
            return false;
        }
        if (other.otherCount() == null ^ this.otherCount() == null) {
            return false;
        }
        return other.otherCount() == null || other.otherCount().equals(this.otherCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.timeoutCount() != null) {
            sb.append("TimeoutCount: ").append(this.timeoutCount()).append(",");
        }
        if (this.connectionRefusedCount() != null) {
            sb.append("ConnectionRefusedCount: ").append(this.connectionRefusedCount()).append(",");
        }
        if (this.httpCode4XXCount() != null) {
            sb.append("HTTPCode4XXCount: ").append(this.httpCode4XXCount()).append(",");
        }
        if (this.httpCode5XXCount() != null) {
            sb.append("HTTPCode5XXCount: ").append(this.httpCode5XXCount()).append(",");
        }
        if (this.unknownHostCount() != null) {
            sb.append("UnknownHostCount: ").append(this.unknownHostCount()).append(",");
        }
        if (this.otherCount() != null) {
            sb.append("OtherCount: ").append(this.otherCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackendConnectionErrorsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer timeoutCount;
        private Integer connectionRefusedCount;
        private Integer httpCode4XXCount;
        private Integer httpCode5XXCount;
        private Integer unknownHostCount;
        private Integer otherCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendConnectionErrors model) {
            this.setTimeoutCount(model.timeoutCount);
            this.setConnectionRefusedCount(model.connectionRefusedCount);
            this.setHTTPCode4XXCount(model.httpCode4XXCount);
            this.setHTTPCode5XXCount(model.httpCode5XXCount);
            this.setUnknownHostCount(model.unknownHostCount);
            this.setOtherCount(model.otherCount);
        }

        public final Integer getTimeoutCount() {
            return this.timeoutCount;
        }

        @Override
        public final Builder timeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
            return this;
        }

        public final void setTimeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
        }

        public final Integer getConnectionRefusedCount() {
            return this.connectionRefusedCount;
        }

        @Override
        public final Builder connectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
            return this;
        }

        public final void setConnectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
        }

        public final Integer getHTTPCode4XXCount() {
            return this.httpCode4XXCount;
        }

        @Override
        public final Builder httpCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
            return this;
        }

        public final void setHTTPCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
        }

        public final Integer getHTTPCode5XXCount() {
            return this.httpCode5XXCount;
        }

        @Override
        public final Builder httpCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
            return this;
        }

        public final void setHTTPCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
        }

        public final Integer getUnknownHostCount() {
            return this.unknownHostCount;
        }

        @Override
        public final Builder unknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
            return this;
        }

        public final void setUnknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
        }

        public final Integer getOtherCount() {
            return this.otherCount;
        }

        @Override
        public final Builder otherCount(Integer otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final void setOtherCount(Integer otherCount) {
            this.otherCount = otherCount;
        }

        public BackendConnectionErrors build() {
            return new BackendConnectionErrors(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BackendConnectionErrors> {
        public Builder timeoutCount(Integer var1);

        public Builder connectionRefusedCount(Integer var1);

        public Builder httpCode4XXCount(Integer var1);

        public Builder httpCode5XXCount(Integer var1);

        public Builder unknownHostCount(Integer var1);

        public Builder otherCount(Integer var1);
    }
}

