/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ColorTheme {
    LIGHT("Light"),
    DARK("Dark"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColorTheme> VALUE_MAP;
    private final String value;

    private ColorTheme(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ColorTheme fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ColorTheme> knownValues() {
        EnumSet<ColorTheme> knownValues = EnumSet.allOf(ColorTheme.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ColorTheme.class, ColorTheme::toString);
    }
}

