/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Event {
    WEBSITE_INTERACT("WebsiteInteract"),
    FILE_DOWNLOAD_FROM_SECURE_BROWSER_TO_REMOTE_DISK("FileDownloadFromSecureBrowserToRemoteDisk"),
    FILE_TRANSFER_FROM_REMOTE_TO_LOCAL_DISK("FileTransferFromRemoteToLocalDisk"),
    FILE_TRANSFER_FROM_LOCAL_TO_REMOTE_DISK("FileTransferFromLocalToRemoteDisk"),
    FILE_UPLOAD_FROM_REMOTE_DISK_TO_SECURE_BROWSER("FileUploadFromRemoteDiskToSecureBrowser"),
    CONTENT_PASTE_TO_WEBSITE("ContentPasteToWebsite"),
    CONTENT_TRANSFER_FROM_LOCAL_TO_REMOTE_CLIPBOARD("ContentTransferFromLocalToRemoteClipboard"),
    CONTENT_COPY_FROM_WEBSITE("ContentCopyFromWebsite"),
    URL_LOAD("UrlLoad"),
    TAB_OPEN("TabOpen"),
    TAB_CLOSE("TabClose"),
    PRINT_JOB_SUBMIT("PrintJobSubmit"),
    SESSION_CONNECT("SessionConnect"),
    SESSION_START("SessionStart"),
    SESSION_DISCONNECT("SessionDisconnect"),
    SESSION_END("SessionEnd"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Event> VALUE_MAP;
    private final String value;

    private Event(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Event fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Event> knownValues() {
        EnumSet<Event> knownValues = EnumSet.allOf(Event.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Event.class, Event::toString);
    }
}

