/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.UserSettingsListCopier;
import software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserSettingsResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListUserSettingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUserSettingsResponse.getter(ListUserSettingsResponse::nextToken)).setter(ListUserSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<UserSettingsSummary>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userSettings").getter(ListUserSettingsResponse.getter(ListUserSettingsResponse::userSettings)).setter(ListUserSettingsResponse.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, USER_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUserSettingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<UserSettingsSummary> userSettings;

    private ListUserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userSettings = builder.userSettings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUserSettings() {
        return this.userSettings != null && !(this.userSettings instanceof SdkAutoConstructList);
    }

    public final List<UserSettingsSummary> userSettings() {
        return this.userSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSettings() ? this.userSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserSettingsResponse)) {
            return false;
        }
        ListUserSettingsResponse other = (ListUserSettingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUserSettings() == other.hasUserSettings() && Objects.equals(this.userSettings(), other.userSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserSettingsResponse").add("NextToken", (Object)this.nextToken()).add("UserSettings", this.hasUserSettings() ? this.userSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "userSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("userSettings", USER_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserSettingsResponse, T> g) {
        return obj -> g.apply((ListUserSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UserSettingsSummary> userSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserSettingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.userSettings(model.userSettings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserSettingsSummary.Builder> getUserSettings() {
            List<UserSettingsSummary.Builder> result = UserSettingsListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSettingsSummary.BuilderImpl> userSettings) {
            this.userSettings = UserSettingsListCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSettingsSummary> userSettings) {
            this.userSettings = UserSettingsListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSettingsSummary ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSettingsSummary.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSettingsSummary)((UserSettingsSummary.Builder)UserSettingsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUserSettingsResponse build() {
            return new ListUserSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserSettingsResponse> {
        public Builder nextToken(String var1);

        public Builder userSettings(Collection<UserSettingsSummary> var1);

        public Builder userSettings(UserSettingsSummary ... var1);

        public Builder userSettings(Consumer<UserSettingsSummary.Builder> ... var1);
    }
}

