/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserAccessLoggingSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, UpdateUserAccessLoggingSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateUserAccessLoggingSettingsRequest.getter(UpdateUserAccessLoggingSettingsRequest::clientToken)).setter(UpdateUserAccessLoggingSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kinesisStreamArn").getter(UpdateUserAccessLoggingSettingsRequest.getter(UpdateUserAccessLoggingSettingsRequest::kinesisStreamArn)).setter(UpdateUserAccessLoggingSettingsRequest.setter(Builder::kinesisStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesisStreamArn").build()}).build();
    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAccessLoggingSettingsArn").getter(UpdateUserAccessLoggingSettingsRequest.getter(UpdateUserAccessLoggingSettingsRequest::userAccessLoggingSettingsArn)).setter(UpdateUserAccessLoggingSettingsRequest.setter(Builder::userAccessLoggingSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("userAccessLoggingSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, KINESIS_STREAM_ARN_FIELD, USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserAccessLoggingSettingsRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String kinesisStreamArn;
    private final String userAccessLoggingSettingsArn;

    private UpdateUserAccessLoggingSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.kinesisStreamArn = builder.kinesisStreamArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String kinesisStreamArn() {
        return this.kinesisStreamArn;
    }

    public final String userAccessLoggingSettingsArn() {
        return this.userAccessLoggingSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAccessLoggingSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAccessLoggingSettingsRequest)) {
            return false;
        }
        UpdateUserAccessLoggingSettingsRequest other = (UpdateUserAccessLoggingSettingsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.kinesisStreamArn(), other.kinesisStreamArn()) && Objects.equals(this.userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserAccessLoggingSettingsRequest").add("ClientToken", (Object)this.clientToken()).add("KinesisStreamArn", (Object)this.kinesisStreamArn()).add("UserAccessLoggingSettingsArn", (Object)this.userAccessLoggingSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "kinesisStreamArn": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamArn()));
            }
            case "userAccessLoggingSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userAccessLoggingSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("kinesisStreamArn", KINESIS_STREAM_ARN_FIELD);
        map.put("userAccessLoggingSettingsArn", USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserAccessLoggingSettingsRequest, T> g) {
        return obj -> g.apply((UpdateUserAccessLoggingSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String kinesisStreamArn;
        private String userAccessLoggingSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAccessLoggingSettingsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.kinesisStreamArn(model.kinesisStreamArn);
            this.userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getKinesisStreamArn() {
            return this.kinesisStreamArn;
        }

        public final void setKinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
        }

        @Override
        public final Builder kinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return this.userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserAccessLoggingSettingsRequest build() {
            return new UpdateUserAccessLoggingSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserAccessLoggingSettingsRequest> {
        public Builder clientToken(String var1);

        public Builder kinesisStreamArn(String var1);

        public Builder userAccessLoggingSettingsArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

