/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;

public class ListTrustStoreCertificatesIterable
implements SdkIterable<ListTrustStoreCertificatesResponse> {
    private final WorkSpacesWebClient client;
    private final ListTrustStoreCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustStoreCertificatesIterable(WorkSpacesWebClient client, ListTrustStoreCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrustStoreCertificatesResponseFetcher();
    }

    public Iterator<ListTrustStoreCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTrustStoreCertificatesResponseFetcher
    implements SyncPageFetcher<ListTrustStoreCertificatesResponse> {
        private ListTrustStoreCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustStoreCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrustStoreCertificatesResponse nextPage(ListTrustStoreCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListTrustStoreCertificatesIterable.this.client.listTrustStoreCertificates(ListTrustStoreCertificatesIterable.this.firstRequest);
            }
            return ListTrustStoreCertificatesIterable.this.client.listTrustStoreCertificates((ListTrustStoreCertificatesRequest)((Object)ListTrustStoreCertificatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

