/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceRequest extends WorkSpacesThinClientRequest implements
        ToCopyableBuilder<UpdateDeviceRequest.Builder, UpdateDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateDeviceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDeviceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredSoftwareSetId").getter(getter(UpdateDeviceRequest::desiredSoftwareSetId))
            .setter(setter(Builder::desiredSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build())
            .build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateSchedule").getter(getter(UpdateDeviceRequest::softwareSetUpdateScheduleAsString))
            .setter(setter(Builder::softwareSetUpdateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESIRED_SOFTWARE_SET_ID_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String desiredSoftwareSetId;

    private final String softwareSetUpdateSchedule;

    private UpdateDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
    }

    /**
     * <p>
     * The ID of the device to update.
     * </p>
     * 
     * @return The ID of the device to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the device to update.
     * </p>
     * 
     * @return The name of the device to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the software set to apply.
     * </p>
     * 
     * @return The ID of the software set to apply.
     */
    public final String desiredSoftwareSetId() {
        return desiredSoftwareSetId;
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(softwareSetUpdateSchedule);
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final String softwareSetUpdateScheduleAsString() {
        return softwareSetUpdateSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateScheduleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceRequest)) {
            return false;
        }
        UpdateDeviceRequest other = (UpdateDeviceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(desiredSoftwareSetId(), other.desiredSoftwareSetId())
                && Objects.equals(softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeviceRequest").add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DesiredSoftwareSetId", desiredSoftwareSetId())
                .add("SoftwareSetUpdateSchedule", softwareSetUpdateScheduleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "desiredSoftwareSetId":
            return Optional.ofNullable(clazz.cast(desiredSoftwareSetId()));
        case "softwareSetUpdateSchedule":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateScheduleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("desiredSoftwareSetId", DESIRED_SOFTWARE_SET_ID_FIELD);
        map.put("softwareSetUpdateSchedule", SOFTWARE_SET_UPDATE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceRequest, T> g) {
        return obj -> g.apply((UpdateDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesThinClientRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeviceRequest> {
        /**
         * <p>
         * The ID of the device to update.
         * </p>
         * 
         * @param id
         *        The ID of the device to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the device to update.
         * </p>
         * 
         * @param name
         *        The name of the device to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the software set to apply.
         * </p>
         * 
         * @param desiredSoftwareSetId
         *        The ID of the software set to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSoftwareSetId(String desiredSoftwareSetId);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesThinClientRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String desiredSoftwareSetId;

        private String softwareSetUpdateSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            desiredSoftwareSetId(model.desiredSoftwareSetId);
            softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceRequest build() {
            return new UpdateDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
