/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmbeddedTag
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmbeddedTag> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(EmbeddedTag.getter(EmbeddedTag::resourceArn)).setter(EmbeddedTag.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> INTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("internalId").getter(EmbeddedTag.getter(EmbeddedTag::internalId)).setter(EmbeddedTag.setter(Builder::internalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, INTERNAL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String internalId;

    private EmbeddedTag(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.internalId = builder.internalId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String internalId() {
        return this.internalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.internalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedTag)) {
            return false;
        }
        EmbeddedTag other = (EmbeddedTag)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.internalId(), other.internalId());
    }

    public final String toString() {
        return ToString.builder((String)"EmbeddedTag").add("ResourceArn", (Object)this.resourceArn()).add("InternalId", (Object)this.internalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "internalId": {
                return Optional.ofNullable(clazz.cast(this.internalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedTag, T> g) {
        return obj -> g.apply((EmbeddedTag)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String internalId;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedTag model) {
            this.resourceArn(model.resourceArn);
            this.internalId(model.internalId);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getInternalId() {
            return this.internalId;
        }

        public final void setInternalId(String internalId) {
            this.internalId = internalId;
        }

        @Override
        public final Builder internalId(String internalId) {
            this.internalId = internalId;
            return this;
        }

        public EmbeddedTag build() {
            return new EmbeddedTag(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmbeddedTag> {
        public Builder resourceArn(String var1);

        public Builder internalId(String var1);
    }
}

