/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesthinclient.model.MaintenanceWindow;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateMode;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateSchedule;
import software.amazon.awssdk.services.workspacesthinclient.model.WorkSpacesThinClientRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentRequest
extends WorkSpacesThinClientRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::id)).setter(UpdateEnvironmentRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::name)).setter(UpdateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::desktopArn)).setter(UpdateEnvironmentRequest.setter(Builder::desktopArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()}).build();
    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopEndpoint").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::desktopEndpoint)).setter(UpdateEnvironmentRequest.setter(Builder::desktopEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateSchedule").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::softwareSetUpdateScheduleAsString)).setter(UpdateEnvironmentRequest.setter(Builder::softwareSetUpdateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::maintenanceWindow)).setter(UpdateEnvironmentRequest.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateMode").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::softwareSetUpdateModeAsString)).setter(UpdateEnvironmentRequest.setter(Builder::softwareSetUpdateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build()}).build();
    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredSoftwareSetId").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::desiredSoftwareSetId)).setter(UpdateEnvironmentRequest.setter(Builder::desiredSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD, SOFTWARE_SET_UPDATE_MODE_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD));
    private final String id;
    private final String name;
    private final String desktopArn;
    private final String desktopEndpoint;
    private final String softwareSetUpdateSchedule;
    private final MaintenanceWindow maintenanceWindow;
    private final String softwareSetUpdateMode;
    private final String desiredSoftwareSetId;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String desktopArn() {
        return this.desktopArn;
    }

    public final String desktopEndpoint() {
        return this.desktopEndpoint;
    }

    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(this.softwareSetUpdateSchedule);
    }

    public final String softwareSetUpdateScheduleAsString() {
        return this.softwareSetUpdateSchedule;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(this.softwareSetUpdateMode);
    }

    public final String softwareSetUpdateModeAsString() {
        return this.softwareSetUpdateMode;
    }

    public final String desiredSoftwareSetId() {
        return this.desiredSoftwareSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSoftwareSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.desktopArn(), other.desktopArn()) && Objects.equals(this.desktopEndpoint(), other.desktopEndpoint()) && Objects.equals(this.softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString()) && Objects.equals(this.desiredSoftwareSetId(), other.desiredSoftwareSetId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentRequest").add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DesktopArn", (Object)this.desktopArn()).add("DesktopEndpoint", (Object)(this.desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")).add("SoftwareSetUpdateSchedule", (Object)this.softwareSetUpdateScheduleAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("SoftwareSetUpdateMode", (Object)this.softwareSetUpdateModeAsString()).add("DesiredSoftwareSetId", (Object)this.desiredSoftwareSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "desktopArn": {
                return Optional.ofNullable(clazz.cast(this.desktopArn()));
            }
            case "desktopEndpoint": {
                return Optional.ofNullable(clazz.cast(this.desktopEndpoint()));
            }
            case "softwareSetUpdateSchedule": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateScheduleAsString()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "softwareSetUpdateMode": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateModeAsString()));
            }
            case "desiredSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.desiredSoftwareSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesThinClientRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String desktopArn;
        private String desktopEndpoint;
        private String softwareSetUpdateSchedule;
        private MaintenanceWindow maintenanceWindow;
        private String softwareSetUpdateMode;
        private String desiredSoftwareSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.desktopArn(model.desktopArn);
            this.desktopEndpoint(model.desktopEndpoint);
            this.softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            this.maintenanceWindow(model.maintenanceWindow);
            this.softwareSetUpdateMode(model.softwareSetUpdateMode);
            this.desiredSoftwareSetId(model.desiredSoftwareSetId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return this.desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return this.desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return this.softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesThinClientRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder desktopArn(String var1);

        public Builder desktopEndpoint(String var1);

        public Builder softwareSetUpdateSchedule(String var1);

        public Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder softwareSetUpdateMode(String var1);

        public Builder softwareSetUpdateMode(SoftwareSetUpdateMode var1);

        public Builder desiredSoftwareSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

