/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TenancyEnum {
    DEFAULT("default"),
    DEDICATED("dedicated"),
    HOST("host"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TenancyEnum> VALUE_MAP;
    private final String value;

    private TenancyEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TenancyEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TenancyEnum> knownValues() {
        EnumSet<TenancyEnum> knownValues = EnumSet.allOf(TenancyEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TenancyEnum.class, TenancyEnum::toString);
    }
}

