/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines comprehensive configuration for a managed WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedInstanceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedInstanceRequest.Builder, ManagedInstanceRequest> {
    private static final SdkField<List<BlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMappingRequest>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(ManagedInstanceRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMappingRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMappingRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(ManagedInstanceRequest::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .build()).build();

    private static final SdkField<CpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField
            .<CpuOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("CpuOptions")
            .getter(getter(ManagedInstanceRequest::cpuOptions)).setter(setter(Builder::cpuOptions))
            .constructor(CpuOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").build()).build();

    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField
            .<CreditSpecificationRequest> builder(MarshallingType.SDK_POJO).memberName("CreditSpecification")
            .getter(getter(ManagedInstanceRequest::creditSpecification)).setter(setter(Builder::creditSpecification))
            .constructor(CreditSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").build())
            .build();

    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiStop").getter(getter(ManagedInstanceRequest::disableApiStop))
            .setter(setter(Builder::disableApiStop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(ManagedInstanceRequest::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePrimaryIpv6").getter(getter(ManagedInstanceRequest::enablePrimaryIpv6))
            .setter(setter(Builder::enablePrimaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6").build()).build();

    private static final SdkField<EnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField
            .<EnclaveOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("EnclaveOptions")
            .getter(getter(ManagedInstanceRequest::enclaveOptions)).setter(setter(Builder::enclaveOptions))
            .constructor(EnclaveOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").build()).build();

    private static final SdkField<HibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField
            .<HibernationOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("HibernationOptions")
            .getter(getter(ManagedInstanceRequest::hibernationOptions)).setter(setter(Builder::hibernationOptions))
            .constructor(HibernationOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").build())
            .build();

    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfileSpecification> builder(MarshallingType.SDK_POJO).memberName("IamInstanceProfile")
            .getter(getter(ManagedInstanceRequest::iamInstanceProfile)).setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfileSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(ManagedInstanceRequest::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<InstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<InstanceMarketOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("InstanceMarketOptions")
            .getter(getter(ManagedInstanceRequest::instanceMarketOptions)).setter(setter(Builder::instanceMarketOptions))
            .constructor(InstanceMarketOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ManagedInstanceRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(ManagedInstanceRequest::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount").getter(getter(ManagedInstanceRequest::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KernelId").getter(getter(ManagedInstanceRequest::kernelId)).setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(ManagedInstanceRequest::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<List<LicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ManagedInstanceRequest::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceMaintenanceOptionsRequest> MAINTENANCE_OPTIONS_FIELD = SdkField
            .<InstanceMaintenanceOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("MaintenanceOptions")
            .getter(getter(ManagedInstanceRequest::maintenanceOptions)).setter(setter(Builder::maintenanceOptions))
            .constructor(InstanceMaintenanceOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").build())
            .build();

    private static final SdkField<InstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("MetadataOptions")
            .getter(getter(ManagedInstanceRequest::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField
            .<RunInstancesMonitoringEnabled> builder(MarshallingType.SDK_POJO).memberName("Monitoring")
            .getter(getter(ManagedInstanceRequest::monitoring)).setter(setter(Builder::monitoring))
            .constructor(RunInstancesMonitoringEnabled::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").build()).build();

    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterfaceSpecification>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(ManagedInstanceRequest::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterfaceSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterfaceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceNetworkPerformanceOptionsRequest> NETWORK_PERFORMANCE_OPTIONS_FIELD = SdkField
            .<InstanceNetworkPerformanceOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkPerformanceOptions")
            .getter(getter(ManagedInstanceRequest::networkPerformanceOptions)).setter(setter(Builder::networkPerformanceOptions))
            .constructor(InstanceNetworkPerformanceOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformanceOptions").build())
            .build();

    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.<Placement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement").getter(getter(ManagedInstanceRequest::placement)).setter(setter(Builder::placement))
            .constructor(Placement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final SdkField<PrivateDnsNameOptionsRequest> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField
            .<PrivateDnsNameOptionsRequest> builder(MarshallingType.SDK_POJO).memberName("PrivateDnsNameOptions")
            .getter(getter(ManagedInstanceRequest::privateDnsNameOptions)).setter(setter(Builder::privateDnsNameOptions))
            .constructor(PrivateDnsNameOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").build())
            .build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(ManagedInstanceRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId").getter(getter(ManagedInstanceRequest::ramdiskId)).setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ManagedInstanceRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(ManagedInstanceRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(ManagedInstanceRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(ManagedInstanceRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserData").getter(getter(ManagedInstanceRequest::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, DISABLE_API_STOP_FIELD,
            EBS_OPTIMIZED_FIELD, ENABLE_PRIMARY_IPV6_FIELD, ENCLAVE_OPTIONS_FIELD, HIBERNATION_OPTIONS_FIELD,
            IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, INSTANCE_TYPE_FIELD, IPV6_ADDRESSES_FIELD,
            IPV6_ADDRESS_COUNT_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, LICENSE_SPECIFICATIONS_FIELD, MAINTENANCE_OPTIONS_FIELD,
            METADATA_OPTIONS_FIELD, MONITORING_FIELD, NETWORK_INTERFACES_FIELD, NETWORK_PERFORMANCE_OPTIONS_FIELD,
            PLACEMENT_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, PRIVATE_IP_ADDRESS_FIELD, RAMDISK_ID_FIELD,
            SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, TAG_SPECIFICATIONS_FIELD, USER_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BlockDeviceMappingRequest> blockDeviceMappings;

    private final CapacityReservationSpecification capacityReservationSpecification;

    private final CpuOptionsRequest cpuOptions;

    private final CreditSpecificationRequest creditSpecification;

    private final Boolean disableApiStop;

    private final Boolean ebsOptimized;

    private final Boolean enablePrimaryIpv6;

    private final EnclaveOptionsRequest enclaveOptions;

    private final HibernationOptionsRequest hibernationOptions;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String imageId;

    private final InstanceMarketOptionsRequest instanceMarketOptions;

    private final String instanceType;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final Integer ipv6AddressCount;

    private final String kernelId;

    private final String keyName;

    private final List<LicenseConfigurationRequest> licenseSpecifications;

    private final InstanceMaintenanceOptionsRequest maintenanceOptions;

    private final InstanceMetadataOptionsRequest metadataOptions;

    private final RunInstancesMonitoringEnabled monitoring;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions;

    private final Placement placement;

    private final PrivateDnsNameOptionsRequest privateDnsNameOptions;

    private final String privateIpAddress;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final String subnetId;

    private final List<TagSpecification> tagSpecifications;

    private final String userData;

    private ManagedInstanceRequest(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.creditSpecification = builder.creditSpecification;
        this.disableApiStop = builder.disableApiStop;
        this.ebsOptimized = builder.ebsOptimized;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
        this.enclaveOptions = builder.enclaveOptions;
        this.hibernationOptions = builder.hibernationOptions;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.instanceType = builder.instanceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.metadataOptions = builder.metadataOptions;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.networkPerformanceOptions = builder.networkPerformanceOptions;
        this.placement = builder.placement;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.privateIpAddress = builder.privateIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.tagSpecifications = builder.tagSpecifications;
        this.userData = builder.userData;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures block device mappings for storage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Configures block device mappings for storage.
     */
    public final List<BlockDeviceMappingRequest> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Specifies capacity reservation preferences.
     * </p>
     * 
     * @return Specifies capacity reservation preferences.
     */
    public final CapacityReservationSpecification capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Configures CPU-specific settings.
     * </p>
     * 
     * @return Configures CPU-specific settings.
     */
    public final CpuOptionsRequest cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * Defines CPU credit configuration for burstable instances.
     * </p>
     * 
     * @return Defines CPU credit configuration for burstable instances.
     */
    public final CreditSpecificationRequest creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * Prevents API-initiated instance stop.
     * </p>
     * 
     * @return Prevents API-initiated instance stop.
     */
    public final Boolean disableApiStop() {
        return disableApiStop;
    }

    /**
     * <p>
     * Enables optimized EBS performance.
     * </p>
     * 
     * @return Enables optimized EBS performance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Enables primary IPv6 address configuration.
     * </p>
     * 
     * @return Enables primary IPv6 address configuration.
     */
    public final Boolean enablePrimaryIpv6() {
        return enablePrimaryIpv6;
    }

    /**
     * <p>
     * Configures AWS Nitro Enclave settings.
     * </p>
     * 
     * @return Configures AWS Nitro Enclave settings.
     */
    public final EnclaveOptionsRequest enclaveOptions() {
        return enclaveOptions;
    }

    /**
     * <p>
     * Configures instance hibernation capabilities.
     * </p>
     * 
     * @return Configures instance hibernation capabilities.
     */
    public final HibernationOptionsRequest hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * <p>
     * Specifies IAM instance profile configuration.
     * </p>
     * 
     * @return Specifies IAM instance profile configuration.
     */
    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Identifies the Amazon Machine Image (AMI) for the instance.
     * </p>
     * 
     * @return Identifies the Amazon Machine Image (AMI) for the instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Configures marketplace-specific deployment options.
     * </p>
     * 
     * @return Configures marketplace-specific deployment options.
     */
    public final InstanceMarketOptionsRequest instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * Specifies the WorkSpace Instance type.
     * </p>
     * 
     * @return Specifies the WorkSpace Instance type.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures specific IPv6 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return Configures specific IPv6 addresses.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * Specifies number of IPv6 addresses to assign.
     * </p>
     * 
     * @return Specifies number of IPv6 addresses to assign.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * <p>
     * Identifies the kernel for the instance.
     * </p>
     * 
     * @return Identifies the kernel for the instance.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * Specifies the key pair for instance access.
     * </p>
     * 
     * @return Specifies the key pair for instance access.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures license-related settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return Configures license-related settings.
     */
    public final List<LicenseConfigurationRequest> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Defines automatic maintenance settings.
     * </p>
     * 
     * @return Defines automatic maintenance settings.
     */
    public final InstanceMaintenanceOptionsRequest maintenanceOptions() {
        return maintenanceOptions;
    }

    /**
     * <p>
     * Configures instance metadata service settings.
     * </p>
     * 
     * @return Configures instance metadata service settings.
     */
    public final InstanceMetadataOptionsRequest metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * Enables or disables detailed instance monitoring.
     * </p>
     * 
     * @return Enables or disables detailed instance monitoring.
     */
    public final RunInstancesMonitoringEnabled monitoring() {
        return monitoring;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures network interface settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return Configures network interface settings.
     */
    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * Defines network performance configuration.
     * </p>
     * 
     * @return Defines network performance configuration.
     */
    public final InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions() {
        return networkPerformanceOptions;
    }

    /**
     * <p>
     * Specifies instance placement preferences.
     * </p>
     * 
     * @return Specifies instance placement preferences.
     */
    public final Placement placement() {
        return placement;
    }

    /**
     * <p>
     * Configures private DNS name settings.
     * </p>
     * 
     * @return Configures private DNS name settings.
     */
    public final PrivateDnsNameOptionsRequest privateDnsNameOptions() {
        return privateDnsNameOptions;
    }

    /**
     * <p>
     * Specifies the primary private IP address.
     * </p>
     * 
     * @return Specifies the primary private IP address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * Identifies the ramdisk for the instance.
     * </p>
     * 
     * @return Identifies the ramdisk for the instance.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies security group identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return Specifies security group identifiers.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures security group settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return Configures security group settings.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Identifies the subnet for the instance.
     * </p>
     * 
     * @return Identifies the subnet for the instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures resource tagging specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return Configures resource tagging specifications.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Provides custom initialization data for the instance.
     * </p>
     * 
     * @return Provides custom initialization data for the instance.
     */
    public final String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(enablePrimaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedInstanceRequest)) {
            return false;
        }
        ManagedInstanceRequest other = (ManagedInstanceRequest) obj;
        return hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(disableApiStop(), other.disableApiStop())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(enablePrimaryIpv6(), other.enablePrimaryIpv6())
                && Objects.equals(enclaveOptions(), other.enclaveOptions())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(instanceType(), other.instanceType()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(maintenanceOptions(), other.maintenanceOptions())
                && Objects.equals(metadataOptions(), other.metadataOptions()) && Objects.equals(monitoring(), other.monitoring())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(networkPerformanceOptions(), other.networkPerformanceOptions())
                && Objects.equals(placement(), other.placement())
                && Objects.equals(privateDnsNameOptions(), other.privateDnsNameOptions())
                && Objects.equals(privateIpAddress(), other.privateIpAddress()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(subnetId(), other.subnetId()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(userData(), other.userData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedInstanceRequest")
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("CapacityReservationSpecification", capacityReservationSpecification()).add("CpuOptions", cpuOptions())
                .add("CreditSpecification", creditSpecification()).add("DisableApiStop", disableApiStop())
                .add("EbsOptimized", ebsOptimized()).add("EnablePrimaryIpv6", enablePrimaryIpv6())
                .add("EnclaveOptions", enclaveOptions()).add("HibernationOptions", hibernationOptions())
                .add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceMarketOptions", instanceMarketOptions()).add("InstanceType", instanceType())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("Ipv6AddressCount", ipv6AddressCount())
                .add("KernelId", kernelId()).add("KeyName", keyName())
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("MaintenanceOptions", maintenanceOptions()).add("MetadataOptions", metadataOptions())
                .add("Monitoring", monitoring()).add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("NetworkPerformanceOptions", networkPerformanceOptions()).add("Placement", placement())
                .add("PrivateDnsNameOptions", privateDnsNameOptions())
                .add("PrivateIpAddress", privateIpAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RamdiskId", ramdiskId()).add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubnetId", subnetId())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("UserData", userData() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "DisableApiStop":
            return Optional.ofNullable(clazz.cast(disableApiStop()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EnablePrimaryIpv6":
            return Optional.ofNullable(clazz.cast(enablePrimaryIpv6()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "MaintenanceOptions":
            return Optional.ofNullable(clazz.cast(maintenanceOptions()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "NetworkPerformanceOptions":
            return Optional.ofNullable(clazz.cast(networkPerformanceOptions()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "PrivateDnsNameOptions":
            return Optional.ofNullable(clazz.cast(privateDnsNameOptions()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlockDeviceMappings", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        map.put("CpuOptions", CPU_OPTIONS_FIELD);
        map.put("CreditSpecification", CREDIT_SPECIFICATION_FIELD);
        map.put("DisableApiStop", DISABLE_API_STOP_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("EnablePrimaryIpv6", ENABLE_PRIMARY_IPV6_FIELD);
        map.put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
        map.put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InstanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        map.put("KernelId", KERNEL_ID_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("LicenseSpecifications", LICENSE_SPECIFICATIONS_FIELD);
        map.put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
        map.put("MetadataOptions", METADATA_OPTIONS_FIELD);
        map.put("Monitoring", MONITORING_FIELD);
        map.put("NetworkInterfaces", NETWORK_INTERFACES_FIELD);
        map.put("NetworkPerformanceOptions", NETWORK_PERFORMANCE_OPTIONS_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("RamdiskId", RAMDISK_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("UserData", USER_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedInstanceRequest, T> g) {
        return obj -> g.apply((ManagedInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedInstanceRequest> {
        /**
         * <p>
         * Configures block device mappings for storage.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Configures block device mappings for storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMappingRequest> blockDeviceMappings);

        /**
         * <p>
         * Configures block device mappings for storage.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Configures block device mappings for storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMappingRequest... blockDeviceMappings);

        /**
         * <p>
         * Configures block device mappings for storage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<BlockDeviceMappingRequest>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.BlockDeviceMappingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMappingRequest>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMappingRequest.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Specifies capacity reservation preferences.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Specifies capacity reservation preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification);

        /**
         * <p>
         * Specifies capacity reservation preferences.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationSpecification.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecification)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecification)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecification.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Configures CPU-specific settings.
         * </p>
         * 
         * @param cpuOptions
         *        Configures CPU-specific settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(CpuOptionsRequest cpuOptions);

        /**
         * <p>
         * Configures CPU-specific settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link CpuOptionsRequest.Builder} avoiding the
         * need to create one manually via {@link CpuOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CpuOptionsRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #cpuOptions(CpuOptionsRequest)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link CpuOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(CpuOptionsRequest)
         */
        default Builder cpuOptions(Consumer<CpuOptionsRequest.Builder> cpuOptions) {
            return cpuOptions(CpuOptionsRequest.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * Defines CPU credit configuration for burstable instances.
         * </p>
         * 
         * @param creditSpecification
         *        Defines CPU credit configuration for burstable instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(CreditSpecificationRequest creditSpecification);

        /**
         * <p>
         * Defines CPU credit configuration for burstable instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreditSpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link CreditSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreditSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #creditSpecification(CreditSpecificationRequest)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on {@link CreditSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(CreditSpecificationRequest)
         */
        default Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return creditSpecification(CreditSpecificationRequest.builder().applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * Prevents API-initiated instance stop.
         * </p>
         * 
         * @param disableApiStop
         *        Prevents API-initiated instance stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiStop(Boolean disableApiStop);

        /**
         * <p>
         * Enables optimized EBS performance.
         * </p>
         * 
         * @param ebsOptimized
         *        Enables optimized EBS performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Enables primary IPv6 address configuration.
         * </p>
         * 
         * @param enablePrimaryIpv6
         *        Enables primary IPv6 address configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6);

        /**
         * <p>
         * Configures AWS Nitro Enclave settings.
         * </p>
         * 
         * @param enclaveOptions
         *        Configures AWS Nitro Enclave settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions);

        /**
         * <p>
         * Configures AWS Nitro Enclave settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnclaveOptionsRequest.Builder} avoiding
         * the need to create one manually via {@link EnclaveOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnclaveOptionsRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #enclaveOptions(EnclaveOptionsRequest)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link EnclaveOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(EnclaveOptionsRequest)
         */
        default Builder enclaveOptions(Consumer<EnclaveOptionsRequest.Builder> enclaveOptions) {
            return enclaveOptions(EnclaveOptionsRequest.builder().applyMutation(enclaveOptions).build());
        }

        /**
         * <p>
         * Configures instance hibernation capabilities.
         * </p>
         * 
         * @param hibernationOptions
         *        Configures instance hibernation capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(HibernationOptionsRequest hibernationOptions);

        /**
         * <p>
         * Configures instance hibernation capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link HibernationOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link HibernationOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HibernationOptionsRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #hibernationOptions(HibernationOptionsRequest)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link HibernationOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(HibernationOptionsRequest)
         */
        default Builder hibernationOptions(Consumer<HibernationOptionsRequest.Builder> hibernationOptions) {
            return hibernationOptions(HibernationOptionsRequest.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * Specifies IAM instance profile configuration.
         * </p>
         * 
         * @param iamInstanceProfile
         *        Specifies IAM instance profile configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * Specifies IAM instance profile configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Identifies the Amazon Machine Image (AMI) for the instance.
         * </p>
         * 
         * @param imageId
         *        Identifies the Amazon Machine Image (AMI) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Configures marketplace-specific deployment options.
         * </p>
         * 
         * @param instanceMarketOptions
         *        Configures marketplace-specific deployment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions);

        /**
         * <p>
         * Configures marketplace-specific deployment options.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMarketOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceMarketOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMarketOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceMarketOptions(InstanceMarketOptionsRequest)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link InstanceMarketOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(InstanceMarketOptionsRequest)
         */
        default Builder instanceMarketOptions(Consumer<InstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return instanceMarketOptions(InstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions).build());
        }

        /**
         * <p>
         * Specifies the WorkSpace Instance type.
         * </p>
         * 
         * @param instanceType
         *        Specifies the WorkSpace Instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Configures specific IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        Configures specific IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * Configures specific IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        Configures specific IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * Configures specific IPv6 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder#build()} is
         * called immediately and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceIpv6Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(java.util.Collection<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * Specifies number of IPv6 addresses to assign.
         * </p>
         * 
         * @param ipv6AddressCount
         *        Specifies number of IPv6 addresses to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * Identifies the kernel for the instance.
         * </p>
         * 
         * @param kernelId
         *        Identifies the kernel for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * Specifies the key pair for instance access.
         * </p>
         * 
         * @param keyName
         *        Specifies the key pair for instance access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Configures license-related settings.
         * </p>
         * 
         * @param licenseSpecifications
         *        Configures license-related settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications);

        /**
         * <p>
         * Configures license-related settings.
         * </p>
         * 
         * @param licenseSpecifications
         *        Configures license-related settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LicenseConfigurationRequest... licenseSpecifications);

        /**
         * <p>
         * Configures license-related settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.LicenseConfigurationRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.LicenseConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.LicenseConfigurationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #licenseSpecifications(List<LicenseConfigurationRequest>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.LicenseConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(java.util.Collection<LicenseConfigurationRequest>)
         */
        Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder>... licenseSpecifications);

        /**
         * <p>
         * Defines automatic maintenance settings.
         * </p>
         * 
         * @param maintenanceOptions
         *        Defines automatic maintenance settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceOptions(InstanceMaintenanceOptionsRequest maintenanceOptions);

        /**
         * <p>
         * Defines automatic maintenance settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceMaintenanceOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link InstanceMaintenanceOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMaintenanceOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #maintenanceOptions(InstanceMaintenanceOptionsRequest)}.
         * 
         * @param maintenanceOptions
         *        a consumer that will call methods on {@link InstanceMaintenanceOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceOptions(InstanceMaintenanceOptionsRequest)
         */
        default Builder maintenanceOptions(Consumer<InstanceMaintenanceOptionsRequest.Builder> maintenanceOptions) {
            return maintenanceOptions(InstanceMaintenanceOptionsRequest.builder().applyMutation(maintenanceOptions).build());
        }

        /**
         * <p>
         * Configures instance metadata service settings.
         * </p>
         * 
         * @param metadataOptions
         *        Configures instance metadata service settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions);

        /**
         * <p>
         * Configures instance metadata service settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceMetadataOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(InstanceMetadataOptionsRequest)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptionsRequest)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions).build());
        }

        /**
         * <p>
         * Enables or disables detailed instance monitoring.
         * </p>
         * 
         * @param monitoring
         *        Enables or disables detailed instance monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(RunInstancesMonitoringEnabled monitoring);

        /**
         * <p>
         * Enables or disables detailed instance monitoring.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunInstancesMonitoringEnabled.Builder}
         * avoiding the need to create one manually via {@link RunInstancesMonitoringEnabled#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RunInstancesMonitoringEnabled.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(RunInstancesMonitoringEnabled)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link RunInstancesMonitoringEnabled.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(RunInstancesMonitoringEnabled)
         */
        default Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return monitoring(RunInstancesMonitoringEnabled.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * Configures network interface settings.
         * </p>
         * 
         * @param networkInterfaces
         *        Configures network interface settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * Configures network interface settings.
         * </p>
         * 
         * @param networkInterfaces
         *        Configures network interface settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * Configures network interface settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkInterfaceSpecification.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkInterfaceSpecification#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkInterfaceSpecification.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.InstanceNetworkInterfaceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<InstanceNetworkInterfaceSpecification>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces);

        /**
         * <p>
         * Defines network performance configuration.
         * </p>
         * 
         * @param networkPerformanceOptions
         *        Defines network performance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions);

        /**
         * <p>
         * Defines network performance configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceNetworkPerformanceOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link InstanceNetworkPerformanceOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceNetworkPerformanceOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest)}.
         * 
         * @param networkPerformanceOptions
         *        a consumer that will call methods on {@link InstanceNetworkPerformanceOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest)
         */
        default Builder networkPerformanceOptions(
                Consumer<InstanceNetworkPerformanceOptionsRequest.Builder> networkPerformanceOptions) {
            return networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest.builder()
                    .applyMutation(networkPerformanceOptions).build());
        }

        /**
         * <p>
         * Specifies instance placement preferences.
         * </p>
         * 
         * @param placement
         *        Specifies instance placement preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * Specifies instance placement preferences.
         * </p>
         * This is a convenience method that creates an instance of the {@link Placement.Builder} avoiding the need to
         * create one manually via {@link Placement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * Configures private DNS name settings.
         * </p>
         * 
         * @param privateDnsNameOptions
         *        Configures private DNS name settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest privateDnsNameOptions);

        /**
         * <p>
         * Configures private DNS name settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateDnsNameOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link PrivateDnsNameOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateDnsNameOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #privateDnsNameOptions(PrivateDnsNameOptionsRequest)}.
         * 
         * @param privateDnsNameOptions
         *        a consumer that will call methods on {@link PrivateDnsNameOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNameOptions(PrivateDnsNameOptionsRequest)
         */
        default Builder privateDnsNameOptions(Consumer<PrivateDnsNameOptionsRequest.Builder> privateDnsNameOptions) {
            return privateDnsNameOptions(PrivateDnsNameOptionsRequest.builder().applyMutation(privateDnsNameOptions).build());
        }

        /**
         * <p>
         * Specifies the primary private IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        Specifies the primary private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Identifies the ramdisk for the instance.
         * </p>
         * 
         * @param ramdiskId
         *        Identifies the ramdisk for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * Specifies security group identifiers.
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies security group identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Specifies security group identifiers.
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies security group identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Configures security group settings.
         * </p>
         * 
         * @param securityGroups
         *        Configures security group settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Configures security group settings.
         * </p>
         * 
         * @param securityGroups
         *        Configures security group settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Identifies the subnet for the instance.
         * </p>
         * 
         * @param subnetId
         *        Identifies the subnet for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Configures resource tagging specifications.
         * </p>
         * 
         * @param tagSpecifications
         *        Configures resource tagging specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * Configures resource tagging specifications.
         * </p>
         * 
         * @param tagSpecifications
         *        Configures resource tagging specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * Configures resource tagging specifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.TagSpecification.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.TagSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Provides custom initialization data for the instance.
         * </p>
         * 
         * @param userData
         *        Provides custom initialization data for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<BlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private CapacityReservationSpecification capacityReservationSpecification;

        private CpuOptionsRequest cpuOptions;

        private CreditSpecificationRequest creditSpecification;

        private Boolean disableApiStop;

        private Boolean ebsOptimized;

        private Boolean enablePrimaryIpv6;

        private EnclaveOptionsRequest enclaveOptions;

        private HibernationOptionsRequest hibernationOptions;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String imageId;

        private InstanceMarketOptionsRequest instanceMarketOptions;

        private String instanceType;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6AddressCount;

        private String kernelId;

        private String keyName;

        private List<LicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private InstanceMaintenanceOptionsRequest maintenanceOptions;

        private InstanceMetadataOptionsRequest metadataOptions;

        private RunInstancesMonitoringEnabled monitoring;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions;

        private Placement placement;

        private PrivateDnsNameOptionsRequest privateDnsNameOptions;

        private String privateIpAddress;

        private String ramdiskId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedInstanceRequest model) {
            blockDeviceMappings(model.blockDeviceMappings);
            capacityReservationSpecification(model.capacityReservationSpecification);
            cpuOptions(model.cpuOptions);
            creditSpecification(model.creditSpecification);
            disableApiStop(model.disableApiStop);
            ebsOptimized(model.ebsOptimized);
            enablePrimaryIpv6(model.enablePrimaryIpv6);
            enclaveOptions(model.enclaveOptions);
            hibernationOptions(model.hibernationOptions);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceMarketOptions(model.instanceMarketOptions);
            instanceType(model.instanceType);
            ipv6Addresses(model.ipv6Addresses);
            ipv6AddressCount(model.ipv6AddressCount);
            kernelId(model.kernelId);
            keyName(model.keyName);
            licenseSpecifications(model.licenseSpecifications);
            maintenanceOptions(model.maintenanceOptions);
            metadataOptions(model.metadataOptions);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            networkPerformanceOptions(model.networkPerformanceOptions);
            placement(model.placement);
            privateDnsNameOptions(model.privateDnsNameOptions);
            privateIpAddress(model.privateIpAddress);
            ramdiskId(model.ramdiskId);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            tagSpecifications(model.tagSpecifications);
            userData(model.userData);
        }

        public final List<BlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMappingRequest.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMappingRequest... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMappingRequest.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> BlockDeviceMappingRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final CpuOptionsRequest.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        public final EnclaveOptionsRequest.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final HibernationOptionsRequest.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final InstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(InstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = Ipv6AddressesCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final List<LicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LicenseConfigurationRequest.Builder> result = LicenseSpecificationsCopier
                    .copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseConfigurationRequest... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LicenseConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMaintenanceOptionsRequest.Builder getMaintenanceOptions() {
            return maintenanceOptions != null ? maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(InstanceMaintenanceOptionsRequest.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(InstanceMaintenanceOptionsRequest maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final InstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = NetworkInterfacesCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> InstanceNetworkInterfaceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceNetworkPerformanceOptionsRequest.Builder getNetworkPerformanceOptions() {
            return networkPerformanceOptions != null ? networkPerformanceOptions.toBuilder() : null;
        }

        public final void setNetworkPerformanceOptions(
                InstanceNetworkPerformanceOptionsRequest.BuilderImpl networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions != null ? networkPerformanceOptions.build() : null;
        }

        @Override
        public final Builder networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequest networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final PrivateDnsNameOptionsRequest.Builder getPrivateDnsNameOptions() {
            return privateDnsNameOptions != null ? privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(PrivateDnsNameOptionsRequest.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(PrivateDnsNameOptionsRequest privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupNamesCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupNamesCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationsCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationsCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationsCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        @Override
        public ManagedInstanceRequest build() {
            return new ManagedInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
