/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines configuration for an Elastic Block Store volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsBlockDevice implements SdkPojo, Serializable, ToCopyableBuilder<EbsBlockDevice.Builder, EbsBlockDevice> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(EbsBlockDevice::volumeTypeAsString)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(EbsBlockDevice::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(EbsBlockDevice::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(EbsBlockDevice::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput").getter(getter(EbsBlockDevice::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize").getter(getter(EbsBlockDevice::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD,
            ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, VOLUME_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeType;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final Integer iops;

    private final Integer throughput;

    private final Integer volumeSize;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.volumeSize = builder.volumeSize;
    }

    /**
     * <p>
     * Type of EBS volume (e.g., gp2, io1).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Type of EBS volume (e.g., gp2, io1).
     * @see VolumeTypeEnum
     */
    public final VolumeTypeEnum volumeType() {
        return VolumeTypeEnum.fromValue(volumeType);
    }

    /**
     * <p>
     * Type of EBS volume (e.g., gp2, io1).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Type of EBS volume (e.g., gp2, io1).
     * @see VolumeTypeEnum
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * Indicates if the volume is encrypted.
     * </p>
     * 
     * @return Indicates if the volume is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * KMS key used for volume encryption.
     * </p>
     * 
     * @return KMS key used for volume encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Input/output operations per second for the volume.
     * </p>
     * 
     * @return Input/output operations per second for the volume.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Volume data transfer rate.
     * </p>
     * 
     * @return Volume data transfer rate.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * Size of the EBS volume in gigabytes.
     * </p>
     * 
     * @return Size of the EBS volume in gigabytes.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice) obj;
        return Objects.equals(volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(iops(), other.iops())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(volumeSize(), other.volumeSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsBlockDevice").add("VolumeType", volumeTypeAsString()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId() == null ? null : "*** Sensitive Data Redacted ***").add("Iops", iops())
                .add("Throughput", throughput()).add("VolumeSize", volumeSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDevice, T> g) {
        return obj -> g.apply((EbsBlockDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsBlockDevice> {
        /**
         * <p>
         * Type of EBS volume (e.g., gp2, io1).
         * </p>
         * 
         * @param volumeType
         *        Type of EBS volume (e.g., gp2, io1).
         * @see VolumeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeTypeEnum
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Type of EBS volume (e.g., gp2, io1).
         * </p>
         * 
         * @param volumeType
         *        Type of EBS volume (e.g., gp2, io1).
         * @see VolumeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeTypeEnum
         */
        Builder volumeType(VolumeTypeEnum volumeType);

        /**
         * <p>
         * Indicates if the volume is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates if the volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * KMS key used for volume encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        KMS key used for volume encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Input/output operations per second for the volume.
         * </p>
         * 
         * @param iops
         *        Input/output operations per second for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Volume data transfer rate.
         * </p>
         * 
         * @param throughput
         *        Volume data transfer rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * Size of the EBS volume in gigabytes.
         * </p>
         * 
         * @param volumeSize
         *        Size of the EBS volume in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);
    }

    static final class BuilderImpl implements Builder {
        private String volumeType;

        private Boolean encrypted;

        private String kmsKeyId;

        private Integer iops;

        private Integer throughput;

        private Integer volumeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            volumeType(model.volumeType);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            iops(model.iops);
            throughput(model.throughput);
            volumeSize(model.volumeSize);
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeTypeEnum volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        @Override
        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
