/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesinstances.WorkspacesInstancesAsyncClient;
import software.amazon.awssdk.services.workspacesinstances.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstance;

public class ListWorkspaceInstancesPublisher
implements SdkPublisher<ListWorkspaceInstancesResponse> {
    private final WorkspacesInstancesAsyncClient client;
    private final ListWorkspaceInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspaceInstancesPublisher(WorkspacesInstancesAsyncClient client, ListWorkspaceInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspaceInstancesPublisher(WorkspacesInstancesAsyncClient client, ListWorkspaceInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspaceInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspaceInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceInstance> workspaceInstances() {
        Function<ListWorkspaceInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaceInstances() != null) {
                return response.workspaceInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkspaceInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkspaceInstancesResponseFetcher
    implements AsyncPageFetcher<ListWorkspaceInstancesResponse> {
        private ListWorkspaceInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspaceInstancesResponse> nextPage(ListWorkspaceInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceInstancesPublisher.this.client.listWorkspaceInstances(ListWorkspaceInstancesPublisher.this.firstRequest);
            }
            return ListWorkspaceInstancesPublisher.this.client.listWorkspaceInstances((ListWorkspaceInstancesRequest)((Object)ListWorkspaceInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

