/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum WorkspacesPoolErrorCode {
    IAM_SERVICE_ROLE_IS_MISSING("IAM_SERVICE_ROLE_IS_MISSING"),

    IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"),

    IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"),

    IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"),

    NETWORK_INTERFACE_LIMIT_EXCEEDED("NETWORK_INTERFACE_LIMIT_EXCEEDED"),

    INTERNAL_SERVICE_ERROR("INTERNAL_SERVICE_ERROR"),

    MACHINE_ROLE_IS_MISSING("MACHINE_ROLE_IS_MISSING"),

    STS_DISABLED_IN_REGION("STS_DISABLED_IN_REGION"),

    SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES("SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"),

    IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION("IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"),

    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),

    IMAGE_NOT_FOUND("IMAGE_NOT_FOUND"),

    INVALID_SUBNET_CONFIGURATION("INVALID_SUBNET_CONFIGURATION"),

    SECURITY_GROUPS_NOT_FOUND("SECURITY_GROUPS_NOT_FOUND"),

    IGW_NOT_ATTACHED("IGW_NOT_ATTACHED"),

    IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION("IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"),

    WORKSPACES_POOL_STOPPED("WORKSPACES_POOL_STOPPED"),

    WORKSPACES_POOL_INSTANCE_PROVISIONING_FAILURE("WORKSPACES_POOL_INSTANCE_PROVISIONING_FAILURE"),

    DOMAIN_JOIN_ERROR_FILE_NOT_FOUND("DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"),

    DOMAIN_JOIN_ERROR_ACCESS_DENIED("DOMAIN_JOIN_ERROR_ACCESS_DENIED"),

    DOMAIN_JOIN_ERROR_LOGON_FAILURE("DOMAIN_JOIN_ERROR_LOGON_FAILURE"),

    DOMAIN_JOIN_ERROR_INVALID_PARAMETER("DOMAIN_JOIN_ERROR_INVALID_PARAMETER"),

    DOMAIN_JOIN_ERROR_MORE_DATA("DOMAIN_JOIN_ERROR_MORE_DATA"),

    DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN("DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"),

    DOMAIN_JOIN_ERROR_NOT_SUPPORTED("DOMAIN_JOIN_ERROR_NOT_SUPPORTED"),

    DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME("DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"),

    DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED("DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"),

    DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED("DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"),

    DOMAIN_JOIN_NERR_PASSWORD_EXPIRED("DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"),

    DOMAIN_JOIN_INTERNAL_SERVICE_ERROR("DOMAIN_JOIN_INTERNAL_SERVICE_ERROR"),

    DOMAIN_JOIN_ERROR_SECRET_ACTION_PERMISSION_IS_MISSING("DOMAIN_JOIN_ERROR_SECRET_ACTION_PERMISSION_IS_MISSING"),

    DOMAIN_JOIN_ERROR_SECRET_DECRYPTION_FAILURE("DOMAIN_JOIN_ERROR_SECRET_DECRYPTION_FAILURE"),

    DOMAIN_JOIN_ERROR_SECRET_STATE_INVALID("DOMAIN_JOIN_ERROR_SECRET_STATE_INVALID"),

    DOMAIN_JOIN_ERROR_SECRET_NOT_FOUND("DOMAIN_JOIN_ERROR_SECRET_NOT_FOUND"),

    DOMAIN_JOIN_ERROR_SECRET_VALUE_KEY_NOT_FOUND("DOMAIN_JOIN_ERROR_SECRET_VALUE_KEY_NOT_FOUND"),

    DOMAIN_JOIN_ERROR_SECRET_INVALID("DOMAIN_JOIN_ERROR_SECRET_INVALID"),

    BUNDLE_NOT_FOUND("BUNDLE_NOT_FOUND"),

    DIRECTORY_NOT_FOUND("DIRECTORY_NOT_FOUND"),

    INSUFFICIENT_PERMISSIONS_ERROR("INSUFFICIENT_PERMISSIONS_ERROR"),

    DEFAULT_OU_IS_MISSING("DEFAULT_OU_IS_MISSING"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspacesPoolErrorCode> VALUE_MAP = EnumUtils.uniqueIndex(WorkspacesPoolErrorCode.class,
            WorkspacesPoolErrorCode::toString);

    private final String value;

    private WorkspacesPoolErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return WorkspacesPoolErrorCode corresponding to the value
     */
    public static WorkspacesPoolErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link WorkspacesPoolErrorCode}s
     */
    public static Set<WorkspacesPoolErrorCode> knownValues() {
        Set<WorkspacesPoolErrorCode> knownValues = EnumSet.allOf(WorkspacesPoolErrorCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
