/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterWorkspaceDirectoryRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<RegisterWorkspaceDirectoryRequest.Builder, RegisterWorkspaceDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RegisterWorkspaceDirectoryRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(RegisterWorkspaceDirectoryRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_SELF_SERVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSelfService").getter(getter(RegisterWorkspaceDirectoryRequest::enableSelfService))
            .setter(setter(Builder::enableSelfService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSelfService").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(RegisterWorkspaceDirectoryRequest::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RegisterWorkspaceDirectoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceDirectoryName").getter(getter(RegisterWorkspaceDirectoryRequest::workspaceDirectoryName))
            .setter(setter(Builder::workspaceDirectoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryName").build())
            .build();

    private static final SdkField<String> WORKSPACE_DIRECTORY_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceDirectoryDescription")
            .getter(getter(RegisterWorkspaceDirectoryRequest::workspaceDirectoryDescription))
            .setter(setter(Builder::workspaceDirectoryDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryDescription")
                    .build()).build();

    private static final SdkField<String> USER_IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserIdentityType").getter(getter(RegisterWorkspaceDirectoryRequest::userIdentityTypeAsString))
            .setter(setter(Builder::userIdentityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentityType").build()).build();

    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdcInstanceArn").getter(getter(RegisterWorkspaceDirectoryRequest::idcInstanceArn))
            .setter(setter(Builder::idcInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcInstanceArn").build()).build();

    private static final SdkField<MicrosoftEntraConfig> MICROSOFT_ENTRA_CONFIG_FIELD = SdkField
            .<MicrosoftEntraConfig> builder(MarshallingType.SDK_POJO).memberName("MicrosoftEntraConfig")
            .getter(getter(RegisterWorkspaceDirectoryRequest::microsoftEntraConfig))
            .setter(setter(Builder::microsoftEntraConfig)).constructor(MicrosoftEntraConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftEntraConfig").build())
            .build();

    private static final SdkField<String> WORKSPACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceType").getter(getter(RegisterWorkspaceDirectoryRequest::workspaceTypeAsString))
            .setter(setter(Builder::workspaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceType").build()).build();

    private static final SdkField<ActiveDirectoryConfig> ACTIVE_DIRECTORY_CONFIG_FIELD = SdkField
            .<ActiveDirectoryConfig> builder(MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfig")
            .getter(getter(RegisterWorkspaceDirectoryRequest::activeDirectoryConfig))
            .setter(setter(Builder::activeDirectoryConfig)).constructor(ActiveDirectoryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SUBNET_IDS_FIELD, ENABLE_SELF_SERVICE_FIELD, TENANCY_FIELD, TAGS_FIELD, WORKSPACE_DIRECTORY_NAME_FIELD,
            WORKSPACE_DIRECTORY_DESCRIPTION_FIELD, USER_IDENTITY_TYPE_FIELD, IDC_INSTANCE_ARN_FIELD,
            MICROSOFT_ENTRA_CONFIG_FIELD, WORKSPACE_TYPE_FIELD, ACTIVE_DIRECTORY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final List<String> subnetIds;

    private final Boolean enableSelfService;

    private final String tenancy;

    private final List<Tag> tags;

    private final String workspaceDirectoryName;

    private final String workspaceDirectoryDescription;

    private final String userIdentityType;

    private final String idcInstanceArn;

    private final MicrosoftEntraConfig microsoftEntraConfig;

    private final String workspaceType;

    private final ActiveDirectoryConfig activeDirectoryConfig;

    private RegisterWorkspaceDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.subnetIds = builder.subnetIds;
        this.enableSelfService = builder.enableSelfService;
        this.tenancy = builder.tenancy;
        this.tags = builder.tags;
        this.workspaceDirectoryName = builder.workspaceDirectoryName;
        this.workspaceDirectoryDescription = builder.workspaceDirectoryDescription;
        this.userIdentityType = builder.userIdentityType;
        this.idcInstanceArn = builder.idcInstanceArn;
        this.microsoftEntraConfig = builder.microsoftEntraConfig;
        this.workspaceType = builder.workspaceType;
        this.activeDirectoryConfig = builder.activeDirectoryConfig;
    }

    /**
     * <p>
     * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the
     * directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have
     * already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will
     * receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and
     * try again.
     * </p>
     * 
     * @return The identifier of the directory. You cannot register a directory if it does not have a status of Active.
     *         If the directory does not have a status of Active, you will receive an InvalidResourceStateException
     *         error. If you have already registered the maximum number of directories that you can register with Amazon
     *         WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are
     *         not using for WorkSpaces, and try again.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported
     * Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you
     * will receive an OperationNotSupportedException error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
     *         supported Availability Zones. The subnets must also be in separate Availability Zones. If these
     *         conditions are not met, you will receive an OperationNotSupportedException error.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Indicates whether self-service capabilities are enabled or disabled.
     * </p>
     * 
     * @return Indicates whether self-service capabilities are enabled or disabled.
     */
    public final Boolean enableSelfService() {
        return enableSelfService;
    }

    /**
     * <p>
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images,
     * this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL.
     * If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For
     * more information about BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
     *         images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
     *         enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
     *         InvalidParameterValuesException error. For more information about BYOL images, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images,
     * this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL.
     * If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For
     * more information about BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
     *         images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be
     *         enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
     *         InvalidParameterValuesException error. For more information about BYOL images, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the directory.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the directory to register.
     * </p>
     * 
     * @return The name of the directory to register.
     */
    public final String workspaceDirectoryName() {
        return workspaceDirectoryName;
    }

    /**
     * <p>
     * Description of the directory to register.
     * </p>
     * 
     * @return Description of the directory to register.
     */
    public final String workspaceDirectoryDescription() {
        return workspaceDirectoryDescription;
    }

    /**
     * <p>
     * The type of identity management the user is using.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userIdentityType}
     * will return {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userIdentityTypeAsString}.
     * </p>
     * 
     * @return The type of identity management the user is using.
     * @see UserIdentityType
     */
    public final UserIdentityType userIdentityType() {
        return UserIdentityType.fromValue(userIdentityType);
    }

    /**
     * <p>
     * The type of identity management the user is using.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userIdentityType}
     * will return {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userIdentityTypeAsString}.
     * </p>
     * 
     * @return The type of identity management the user is using.
     * @see UserIdentityType
     */
    public final String userIdentityTypeAsString() {
        return userIdentityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity center instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the identity center instance.
     */
    public final String idcInstanceArn() {
        return idcInstanceArn;
    }

    /**
     * <p>
     * The details about Microsoft Entra config.
     * </p>
     * 
     * @return The details about Microsoft Entra config.
     */
    public final MicrosoftEntraConfig microsoftEntraConfig() {
        return microsoftEntraConfig;
    }

    /**
     * <p>
     * Indicates whether the directory's WorkSpace type is personal or pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceType}
     * will return {@link WorkspaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workspaceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the directory's WorkSpace type is personal or pools.
     * @see WorkspaceType
     */
    public final WorkspaceType workspaceType() {
        return WorkspaceType.fromValue(workspaceType);
    }

    /**
     * <p>
     * Indicates whether the directory's WorkSpace type is personal or pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceType}
     * will return {@link WorkspaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workspaceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the directory's WorkSpace type is personal or pools.
     * @see WorkspaceType
     */
    public final String workspaceTypeAsString() {
        return workspaceType;
    }

    /**
     * <p>
     * The active directory config of the directory.
     * </p>
     * 
     * @return The active directory config of the directory.
     */
    public final ActiveDirectoryConfig activeDirectoryConfig() {
        return activeDirectoryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableSelfService());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDirectoryName());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDirectoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftEntraConfig());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkspaceDirectoryRequest)) {
            return false;
        }
        RegisterWorkspaceDirectoryRequest other = (RegisterWorkspaceDirectoryRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(enableSelfService(), other.enableSelfService())
                && Objects.equals(tenancyAsString(), other.tenancyAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(workspaceDirectoryName(), other.workspaceDirectoryName())
                && Objects.equals(workspaceDirectoryDescription(), other.workspaceDirectoryDescription())
                && Objects.equals(userIdentityTypeAsString(), other.userIdentityTypeAsString())
                && Objects.equals(idcInstanceArn(), other.idcInstanceArn())
                && Objects.equals(microsoftEntraConfig(), other.microsoftEntraConfig())
                && Objects.equals(workspaceTypeAsString(), other.workspaceTypeAsString())
                && Objects.equals(activeDirectoryConfig(), other.activeDirectoryConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterWorkspaceDirectoryRequest").add("DirectoryId", directoryId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("EnableSelfService", enableSelfService())
                .add("Tenancy", tenancyAsString()).add("Tags", hasTags() ? tags() : null)
                .add("WorkspaceDirectoryName", workspaceDirectoryName())
                .add("WorkspaceDirectoryDescription", workspaceDirectoryDescription())
                .add("UserIdentityType", userIdentityTypeAsString()).add("IdcInstanceArn", idcInstanceArn())
                .add("MicrosoftEntraConfig", microsoftEntraConfig()).add("WorkspaceType", workspaceTypeAsString())
                .add("ActiveDirectoryConfig", activeDirectoryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "EnableSelfService":
            return Optional.ofNullable(clazz.cast(enableSelfService()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WorkspaceDirectoryName":
            return Optional.ofNullable(clazz.cast(workspaceDirectoryName()));
        case "WorkspaceDirectoryDescription":
            return Optional.ofNullable(clazz.cast(workspaceDirectoryDescription()));
        case "UserIdentityType":
            return Optional.ofNullable(clazz.cast(userIdentityTypeAsString()));
        case "IdcInstanceArn":
            return Optional.ofNullable(clazz.cast(idcInstanceArn()));
        case "MicrosoftEntraConfig":
            return Optional.ofNullable(clazz.cast(microsoftEntraConfig()));
        case "WorkspaceType":
            return Optional.ofNullable(clazz.cast(workspaceTypeAsString()));
        case "ActiveDirectoryConfig":
            return Optional.ofNullable(clazz.cast(activeDirectoryConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("EnableSelfService", ENABLE_SELF_SERVICE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WorkspaceDirectoryName", WORKSPACE_DIRECTORY_NAME_FIELD);
        map.put("WorkspaceDirectoryDescription", WORKSPACE_DIRECTORY_DESCRIPTION_FIELD);
        map.put("UserIdentityType", USER_IDENTITY_TYPE_FIELD);
        map.put("IdcInstanceArn", IDC_INSTANCE_ARN_FIELD);
        map.put("MicrosoftEntraConfig", MICROSOFT_ENTRA_CONFIG_FIELD);
        map.put("WorkspaceType", WORKSPACE_TYPE_FIELD);
        map.put("ActiveDirectoryConfig", ACTIVE_DIRECTORY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkspaceDirectoryRequest, T> g) {
        return obj -> g.apply((RegisterWorkspaceDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
        /**
         * <p>
         * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If
         * the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If
         * you have already registered the maximum number of directories that you can register with Amazon WorkSpaces,
         * you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for
         * WorkSpaces, and try again.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory. You cannot register a directory if it does not have a status of
         *        Active. If the directory does not have a status of Active, you will receive an
         *        InvalidResourceStateException error. If you have already registered the maximum number of directories
         *        that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error.
         *        Deregister directories that you are not using for WorkSpaces, and try again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         * supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions
         * are not met, you will receive an OperationNotSupportedException error.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         *        supported Availability Zones. The subnets must also be in separate Availability Zones. If these
         *        conditions are not met, you will receive an OperationNotSupportedException error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         * supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions
         * are not met, you will receive an OperationNotSupportedException error.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in
         *        supported Availability Zones. The subnets must also be in separate Availability Zones. If these
         *        conditions are not met, you will receive an OperationNotSupportedException error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Indicates whether self-service capabilities are enabled or disabled.
         * </p>
         * 
         * @param enableSelfService
         *        Indicates whether self-service capabilities are enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSelfService(Boolean enableSelfService);

        /**
         * <p>
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
         * images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled
         * for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException
         * error. For more information about BYOL images, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License
         *        (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account
         *        must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
         *        InvalidParameterValuesException error. For more information about BYOL images, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL)
         * images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled
         * for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException
         * error. For more information about BYOL images, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License
         *        (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account
         *        must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an
         *        InvalidParameterValuesException error. For more information about BYOL images, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * 
         * @param tags
         *        The tags associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * 
         * @param tags
         *        The tags associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the directory to register.
         * </p>
         * 
         * @param workspaceDirectoryName
         *        The name of the directory to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryName(String workspaceDirectoryName);

        /**
         * <p>
         * Description of the directory to register.
         * </p>
         * 
         * @param workspaceDirectoryDescription
         *        Description of the directory to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryDescription(String workspaceDirectoryDescription);

        /**
         * <p>
         * The type of identity management the user is using.
         * </p>
         * 
         * @param userIdentityType
         *        The type of identity management the user is using.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder userIdentityType(String userIdentityType);

        /**
         * <p>
         * The type of identity management the user is using.
         * </p>
         * 
         * @param userIdentityType
         *        The type of identity management the user is using.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder userIdentityType(UserIdentityType userIdentityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity center instance.
         * </p>
         * 
         * @param idcInstanceArn
         *        The Amazon Resource Name (ARN) of the identity center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcInstanceArn(String idcInstanceArn);

        /**
         * <p>
         * The details about Microsoft Entra config.
         * </p>
         * 
         * @param microsoftEntraConfig
         *        The details about Microsoft Entra config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftEntraConfig(MicrosoftEntraConfig microsoftEntraConfig);

        /**
         * <p>
         * The details about Microsoft Entra config.
         * </p>
         * This is a convenience method that creates an instance of the {@link MicrosoftEntraConfig.Builder} avoiding
         * the need to create one manually via {@link MicrosoftEntraConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftEntraConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #microsoftEntraConfig(MicrosoftEntraConfig)}.
         * 
         * @param microsoftEntraConfig
         *        a consumer that will call methods on {@link MicrosoftEntraConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftEntraConfig(MicrosoftEntraConfig)
         */
        default Builder microsoftEntraConfig(Consumer<MicrosoftEntraConfig.Builder> microsoftEntraConfig) {
            return microsoftEntraConfig(MicrosoftEntraConfig.builder().applyMutation(microsoftEntraConfig).build());
        }

        /**
         * <p>
         * Indicates whether the directory's WorkSpace type is personal or pools.
         * </p>
         * 
         * @param workspaceType
         *        Indicates whether the directory's WorkSpace type is personal or pools.
         * @see WorkspaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceType
         */
        Builder workspaceType(String workspaceType);

        /**
         * <p>
         * Indicates whether the directory's WorkSpace type is personal or pools.
         * </p>
         * 
         * @param workspaceType
         *        Indicates whether the directory's WorkSpace type is personal or pools.
         * @see WorkspaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceType
         */
        Builder workspaceType(WorkspaceType workspaceType);

        /**
         * <p>
         * The active directory config of the directory.
         * </p>
         * 
         * @param activeDirectoryConfig
         *        The active directory config of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryConfig(ActiveDirectoryConfig activeDirectoryConfig);

        /**
         * <p>
         * The active directory config of the directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveDirectoryConfig.Builder} avoiding
         * the need to create one manually via {@link ActiveDirectoryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveDirectoryConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #activeDirectoryConfig(ActiveDirectoryConfig)}.
         * 
         * @param activeDirectoryConfig
         *        a consumer that will call methods on {@link ActiveDirectoryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryConfig(ActiveDirectoryConfig)
         */
        default Builder activeDirectoryConfig(Consumer<ActiveDirectoryConfig.Builder> activeDirectoryConfig) {
            return activeDirectoryConfig(ActiveDirectoryConfig.builder().applyMutation(activeDirectoryConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableSelfService;

        private String tenancy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String workspaceDirectoryName;

        private String workspaceDirectoryDescription;

        private String userIdentityType;

        private String idcInstanceArn;

        private MicrosoftEntraConfig microsoftEntraConfig;

        private String workspaceType;

        private ActiveDirectoryConfig activeDirectoryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkspaceDirectoryRequest model) {
            super(model);
            directoryId(model.directoryId);
            subnetIds(model.subnetIds);
            enableSelfService(model.enableSelfService);
            tenancy(model.tenancy);
            tags(model.tags);
            workspaceDirectoryName(model.workspaceDirectoryName);
            workspaceDirectoryDescription(model.workspaceDirectoryDescription);
            userIdentityType(model.userIdentityType);
            idcInstanceArn(model.idcInstanceArn);
            microsoftEntraConfig(model.microsoftEntraConfig);
            workspaceType(model.workspaceType);
            activeDirectoryConfig(model.activeDirectoryConfig);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Boolean getEnableSelfService() {
            return enableSelfService;
        }

        public final void setEnableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
        }

        @Override
        public final Builder enableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceDirectoryName() {
            return workspaceDirectoryName;
        }

        public final void setWorkspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
        }

        @Override
        public final Builder workspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
            return this;
        }

        public final String getWorkspaceDirectoryDescription() {
            return workspaceDirectoryDescription;
        }

        public final void setWorkspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
        }

        @Override
        public final Builder workspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
            return this;
        }

        public final String getUserIdentityType() {
            return userIdentityType;
        }

        public final void setUserIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
        }

        @Override
        public final Builder userIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
            return this;
        }

        @Override
        public final Builder userIdentityType(UserIdentityType userIdentityType) {
            this.userIdentityType(userIdentityType == null ? null : userIdentityType.toString());
            return this;
        }

        public final String getIdcInstanceArn() {
            return idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final MicrosoftEntraConfig.Builder getMicrosoftEntraConfig() {
            return microsoftEntraConfig != null ? microsoftEntraConfig.toBuilder() : null;
        }

        public final void setMicrosoftEntraConfig(MicrosoftEntraConfig.BuilderImpl microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig != null ? microsoftEntraConfig.build() : null;
        }

        @Override
        public final Builder microsoftEntraConfig(MicrosoftEntraConfig microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig;
            return this;
        }

        public final String getWorkspaceType() {
            return workspaceType;
        }

        public final void setWorkspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
        }

        @Override
        public final Builder workspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
            return this;
        }

        @Override
        public final Builder workspaceType(WorkspaceType workspaceType) {
            this.workspaceType(workspaceType == null ? null : workspaceType.toString());
            return this;
        }

        public final ActiveDirectoryConfig.Builder getActiveDirectoryConfig() {
            return activeDirectoryConfig != null ? activeDirectoryConfig.toBuilder() : null;
        }

        public final void setActiveDirectoryConfig(ActiveDirectoryConfig.BuilderImpl activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig != null ? activeDirectoryConfig.build() : null;
        }

        @Override
        public final Builder activeDirectoryConfig(ActiveDirectoryConfig activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkspaceDirectoryRequest build() {
            return new RegisterWorkspaceDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
