/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEndpointEncryptionModeRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyEndpointEncryptionModeRequest.Builder, ModifyEndpointEncryptionModeRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ModifyEndpointEncryptionModeRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> ENDPOINT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointEncryptionMode")
            .getter(getter(ModifyEndpointEncryptionModeRequest::endpointEncryptionModeAsString))
            .setter(setter(Builder::endpointEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointEncryptionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            ENDPOINT_ENCRYPTION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String endpointEncryptionMode;

    private ModifyEndpointEncryptionModeRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.endpointEncryptionMode = builder.endpointEncryptionMode;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace Pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointEncryptionMode} will return {@link EndpointEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace
     *         Pools.
     * @see EndpointEncryptionMode
     */
    public final EndpointEncryptionMode endpointEncryptionMode() {
        return EndpointEncryptionMode.fromValue(endpointEncryptionMode);
    }

    /**
     * <p>
     * The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace Pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointEncryptionMode} will return {@link EndpointEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace
     *         Pools.
     * @see EndpointEncryptionMode
     */
    public final String endpointEncryptionModeAsString() {
        return endpointEncryptionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointEncryptionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEndpointEncryptionModeRequest)) {
            return false;
        }
        ModifyEndpointEncryptionModeRequest other = (ModifyEndpointEncryptionModeRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(endpointEncryptionModeAsString(), other.endpointEncryptionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyEndpointEncryptionModeRequest").add("DirectoryId", directoryId())
                .add("EndpointEncryptionMode", endpointEncryptionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "EndpointEncryptionMode":
            return Optional.ofNullable(clazz.cast(endpointEncryptionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("EndpointEncryptionMode", ENDPOINT_ENCRYPTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyEndpointEncryptionModeRequest, T> g) {
        return obj -> g.apply((ModifyEndpointEncryptionModeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyEndpointEncryptionModeRequest> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace Pools.
         * </p>
         * 
         * @param endpointEncryptionMode
         *        The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace
         *        Pools.
         * @see EndpointEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointEncryptionMode
         */
        Builder endpointEncryptionMode(String endpointEncryptionMode);

        /**
         * <p>
         * The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace Pools.
         * </p>
         * 
         * @param endpointEncryptionMode
         *        The encryption mode used for endpoint connections when streaming to WorkSpaces Personal or WorkSpace
         *        Pools.
         * @see EndpointEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointEncryptionMode
         */
        Builder endpointEncryptionMode(EndpointEncryptionMode endpointEncryptionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String endpointEncryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEndpointEncryptionModeRequest model) {
            super(model);
            directoryId(model.directoryId);
            endpointEncryptionMode(model.endpointEncryptionMode);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getEndpointEncryptionMode() {
            return endpointEncryptionMode;
        }

        public final void setEndpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
        }

        @Override
        public final Builder endpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
            return this;
        }

        @Override
        public final Builder endpointEncryptionMode(EndpointEncryptionMode endpointEncryptionMode) {
            this.endpointEncryptionMode(endpointEncryptionMode == null ? null : endpointEncryptionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEndpointEncryptionModeRequest build() {
            return new ModifyEndpointEncryptionModeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
