/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportClientBrandingRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ImportClientBrandingRequest.Builder, ImportClientBrandingRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ImportClientBrandingRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_WINDOWS_FIELD = SdkField
            .<DefaultImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeWindows")
            .getter(getter(ImportClientBrandingRequest::deviceTypeWindows)).setter(setter(Builder::deviceTypeWindows))
            .constructor(DefaultImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWindows").build()).build();

    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_OSX_FIELD = SdkField
            .<DefaultImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeOsx")
            .getter(getter(ImportClientBrandingRequest::deviceTypeOsx)).setter(setter(Builder::deviceTypeOsx))
            .constructor(DefaultImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeOsx").build()).build();

    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_ANDROID_FIELD = SdkField
            .<DefaultImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeAndroid")
            .getter(getter(ImportClientBrandingRequest::deviceTypeAndroid)).setter(setter(Builder::deviceTypeAndroid))
            .constructor(DefaultImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeAndroid").build()).build();

    private static final SdkField<IosImportClientBrandingAttributes> DEVICE_TYPE_IOS_FIELD = SdkField
            .<IosImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeIos")
            .getter(getter(ImportClientBrandingRequest::deviceTypeIos)).setter(setter(Builder::deviceTypeIos))
            .constructor(IosImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeIos").build()).build();

    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_LINUX_FIELD = SdkField
            .<DefaultImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeLinux")
            .getter(getter(ImportClientBrandingRequest::deviceTypeLinux)).setter(setter(Builder::deviceTypeLinux))
            .constructor(DefaultImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeLinux").build()).build();

    private static final SdkField<DefaultImportClientBrandingAttributes> DEVICE_TYPE_WEB_FIELD = SdkField
            .<DefaultImportClientBrandingAttributes> builder(MarshallingType.SDK_POJO).memberName("DeviceTypeWeb")
            .getter(getter(ImportClientBrandingRequest::deviceTypeWeb)).setter(setter(Builder::deviceTypeWeb))
            .constructor(DefaultImportClientBrandingAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWeb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            DEVICE_TYPE_WINDOWS_FIELD, DEVICE_TYPE_OSX_FIELD, DEVICE_TYPE_ANDROID_FIELD, DEVICE_TYPE_IOS_FIELD,
            DEVICE_TYPE_LINUX_FIELD, DEVICE_TYPE_WEB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceId;

    private final DefaultImportClientBrandingAttributes deviceTypeWindows;

    private final DefaultImportClientBrandingAttributes deviceTypeOsx;

    private final DefaultImportClientBrandingAttributes deviceTypeAndroid;

    private final IosImportClientBrandingAttributes deviceTypeIos;

    private final DefaultImportClientBrandingAttributes deviceTypeLinux;

    private final DefaultImportClientBrandingAttributes deviceTypeWeb;

    private ImportClientBrandingRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.deviceTypeWindows = builder.deviceTypeWindows;
        this.deviceTypeOsx = builder.deviceTypeOsx;
        this.deviceTypeAndroid = builder.deviceTypeAndroid;
        this.deviceTypeIos = builder.deviceTypeIos;
        this.deviceTypeLinux = builder.deviceTypeLinux;
        this.deviceTypeWeb = builder.deviceTypeWeb;
    }

    /**
     * <p>
     * The directory identifier of the WorkSpace for which you want to import client branding.
     * </p>
     * 
     * @return The directory identifier of the WorkSpace for which you want to import client branding.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The branding information to import for Windows devices.
     * </p>
     * 
     * @return The branding information to import for Windows devices.
     */
    public final DefaultImportClientBrandingAttributes deviceTypeWindows() {
        return deviceTypeWindows;
    }

    /**
     * <p>
     * The branding information to import for macOS devices.
     * </p>
     * 
     * @return The branding information to import for macOS devices.
     */
    public final DefaultImportClientBrandingAttributes deviceTypeOsx() {
        return deviceTypeOsx;
    }

    /**
     * <p>
     * The branding information to import for Android devices.
     * </p>
     * 
     * @return The branding information to import for Android devices.
     */
    public final DefaultImportClientBrandingAttributes deviceTypeAndroid() {
        return deviceTypeAndroid;
    }

    /**
     * <p>
     * The branding information to import for iOS devices.
     * </p>
     * 
     * @return The branding information to import for iOS devices.
     */
    public final IosImportClientBrandingAttributes deviceTypeIos() {
        return deviceTypeIos;
    }

    /**
     * <p>
     * The branding information to import for Linux devices.
     * </p>
     * 
     * @return The branding information to import for Linux devices.
     */
    public final DefaultImportClientBrandingAttributes deviceTypeLinux() {
        return deviceTypeLinux;
    }

    /**
     * <p>
     * The branding information to import for web access.
     * </p>
     * 
     * @return The branding information to import for web access.
     */
    public final DefaultImportClientBrandingAttributes deviceTypeWeb() {
        return deviceTypeWeb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWindows());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeOsx());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAndroid());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeIos());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeLinux());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWeb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportClientBrandingRequest)) {
            return false;
        }
        ImportClientBrandingRequest other = (ImportClientBrandingRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(deviceTypeWindows(), other.deviceTypeWindows())
                && Objects.equals(deviceTypeOsx(), other.deviceTypeOsx())
                && Objects.equals(deviceTypeAndroid(), other.deviceTypeAndroid())
                && Objects.equals(deviceTypeIos(), other.deviceTypeIos())
                && Objects.equals(deviceTypeLinux(), other.deviceTypeLinux())
                && Objects.equals(deviceTypeWeb(), other.deviceTypeWeb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportClientBrandingRequest").add("ResourceId", resourceId())
                .add("DeviceTypeWindows", deviceTypeWindows()).add("DeviceTypeOsx", deviceTypeOsx())
                .add("DeviceTypeAndroid", deviceTypeAndroid()).add("DeviceTypeIos", deviceTypeIos())
                .add("DeviceTypeLinux", deviceTypeLinux()).add("DeviceTypeWeb", deviceTypeWeb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "DeviceTypeWindows":
            return Optional.ofNullable(clazz.cast(deviceTypeWindows()));
        case "DeviceTypeOsx":
            return Optional.ofNullable(clazz.cast(deviceTypeOsx()));
        case "DeviceTypeAndroid":
            return Optional.ofNullable(clazz.cast(deviceTypeAndroid()));
        case "DeviceTypeIos":
            return Optional.ofNullable(clazz.cast(deviceTypeIos()));
        case "DeviceTypeLinux":
            return Optional.ofNullable(clazz.cast(deviceTypeLinux()));
        case "DeviceTypeWeb":
            return Optional.ofNullable(clazz.cast(deviceTypeWeb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("DeviceTypeWindows", DEVICE_TYPE_WINDOWS_FIELD);
        map.put("DeviceTypeOsx", DEVICE_TYPE_OSX_FIELD);
        map.put("DeviceTypeAndroid", DEVICE_TYPE_ANDROID_FIELD);
        map.put("DeviceTypeIos", DEVICE_TYPE_IOS_FIELD);
        map.put("DeviceTypeLinux", DEVICE_TYPE_LINUX_FIELD);
        map.put("DeviceTypeWeb", DEVICE_TYPE_WEB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportClientBrandingRequest, T> g) {
        return obj -> g.apply((ImportClientBrandingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportClientBrandingRequest> {
        /**
         * <p>
         * The directory identifier of the WorkSpace for which you want to import client branding.
         * </p>
         * 
         * @param resourceId
         *        The directory identifier of the WorkSpace for which you want to import client branding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The branding information to import for Windows devices.
         * </p>
         * 
         * @param deviceTypeWindows
         *        The branding information to import for Windows devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeWindows(DefaultImportClientBrandingAttributes deviceTypeWindows);

        /**
         * <p>
         * The branding information to import for Windows devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link DefaultImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeWindows(DefaultImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeWindows
         *        a consumer that will call methods on {@link DefaultImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeWindows(DefaultImportClientBrandingAttributes)
         */
        default Builder deviceTypeWindows(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeWindows) {
            return deviceTypeWindows(DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeWindows).build());
        }

        /**
         * <p>
         * The branding information to import for macOS devices.
         * </p>
         * 
         * @param deviceTypeOsx
         *        The branding information to import for macOS devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeOsx(DefaultImportClientBrandingAttributes deviceTypeOsx);

        /**
         * <p>
         * The branding information to import for macOS devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link DefaultImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeOsx(DefaultImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeOsx
         *        a consumer that will call methods on {@link DefaultImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeOsx(DefaultImportClientBrandingAttributes)
         */
        default Builder deviceTypeOsx(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeOsx) {
            return deviceTypeOsx(DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeOsx).build());
        }

        /**
         * <p>
         * The branding information to import for Android devices.
         * </p>
         * 
         * @param deviceTypeAndroid
         *        The branding information to import for Android devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeAndroid(DefaultImportClientBrandingAttributes deviceTypeAndroid);

        /**
         * <p>
         * The branding information to import for Android devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link DefaultImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeAndroid(DefaultImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeAndroid
         *        a consumer that will call methods on {@link DefaultImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeAndroid(DefaultImportClientBrandingAttributes)
         */
        default Builder deviceTypeAndroid(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeAndroid) {
            return deviceTypeAndroid(DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeAndroid).build());
        }

        /**
         * <p>
         * The branding information to import for iOS devices.
         * </p>
         * 
         * @param deviceTypeIos
         *        The branding information to import for iOS devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeIos(IosImportClientBrandingAttributes deviceTypeIos);

        /**
         * <p>
         * The branding information to import for iOS devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IosImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link IosImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IosImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeIos(IosImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeIos
         *        a consumer that will call methods on {@link IosImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeIos(IosImportClientBrandingAttributes)
         */
        default Builder deviceTypeIos(Consumer<IosImportClientBrandingAttributes.Builder> deviceTypeIos) {
            return deviceTypeIos(IosImportClientBrandingAttributes.builder().applyMutation(deviceTypeIos).build());
        }

        /**
         * <p>
         * The branding information to import for Linux devices.
         * </p>
         * 
         * @param deviceTypeLinux
         *        The branding information to import for Linux devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeLinux(DefaultImportClientBrandingAttributes deviceTypeLinux);

        /**
         * <p>
         * The branding information to import for Linux devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link DefaultImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeLinux(DefaultImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeLinux
         *        a consumer that will call methods on {@link DefaultImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeLinux(DefaultImportClientBrandingAttributes)
         */
        default Builder deviceTypeLinux(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeLinux) {
            return deviceTypeLinux(DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeLinux).build());
        }

        /**
         * <p>
         * The branding information to import for web access.
         * </p>
         * 
         * @param deviceTypeWeb
         *        The branding information to import for web access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeWeb(DefaultImportClientBrandingAttributes deviceTypeWeb);

        /**
         * <p>
         * The branding information to import for web access.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultImportClientBrandingAttributes.Builder} avoiding the need to create one manually via
         * {@link DefaultImportClientBrandingAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultImportClientBrandingAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceTypeWeb(DefaultImportClientBrandingAttributes)}.
         * 
         * @param deviceTypeWeb
         *        a consumer that will call methods on {@link DefaultImportClientBrandingAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceTypeWeb(DefaultImportClientBrandingAttributes)
         */
        default Builder deviceTypeWeb(Consumer<DefaultImportClientBrandingAttributes.Builder> deviceTypeWeb) {
            return deviceTypeWeb(DefaultImportClientBrandingAttributes.builder().applyMutation(deviceTypeWeb).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private DefaultImportClientBrandingAttributes deviceTypeWindows;

        private DefaultImportClientBrandingAttributes deviceTypeOsx;

        private DefaultImportClientBrandingAttributes deviceTypeAndroid;

        private IosImportClientBrandingAttributes deviceTypeIos;

        private DefaultImportClientBrandingAttributes deviceTypeLinux;

        private DefaultImportClientBrandingAttributes deviceTypeWeb;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportClientBrandingRequest model) {
            super(model);
            resourceId(model.resourceId);
            deviceTypeWindows(model.deviceTypeWindows);
            deviceTypeOsx(model.deviceTypeOsx);
            deviceTypeAndroid(model.deviceTypeAndroid);
            deviceTypeIos(model.deviceTypeIos);
            deviceTypeLinux(model.deviceTypeLinux);
            deviceTypeWeb(model.deviceTypeWeb);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeWindows() {
            return deviceTypeWindows != null ? deviceTypeWindows.toBuilder() : null;
        }

        public final void setDeviceTypeWindows(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows != null ? deviceTypeWindows.build() : null;
        }

        @Override
        public final Builder deviceTypeWindows(DefaultImportClientBrandingAttributes deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeOsx() {
            return deviceTypeOsx != null ? deviceTypeOsx.toBuilder() : null;
        }

        public final void setDeviceTypeOsx(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx != null ? deviceTypeOsx.build() : null;
        }

        @Override
        public final Builder deviceTypeOsx(DefaultImportClientBrandingAttributes deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeAndroid() {
            return deviceTypeAndroid != null ? deviceTypeAndroid.toBuilder() : null;
        }

        public final void setDeviceTypeAndroid(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid != null ? deviceTypeAndroid.build() : null;
        }

        @Override
        public final Builder deviceTypeAndroid(DefaultImportClientBrandingAttributes deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid;
            return this;
        }

        public final IosImportClientBrandingAttributes.Builder getDeviceTypeIos() {
            return deviceTypeIos != null ? deviceTypeIos.toBuilder() : null;
        }

        public final void setDeviceTypeIos(IosImportClientBrandingAttributes.BuilderImpl deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos != null ? deviceTypeIos.build() : null;
        }

        @Override
        public final Builder deviceTypeIos(IosImportClientBrandingAttributes deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeLinux() {
            return deviceTypeLinux != null ? deviceTypeLinux.toBuilder() : null;
        }

        public final void setDeviceTypeLinux(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux != null ? deviceTypeLinux.build() : null;
        }

        @Override
        public final Builder deviceTypeLinux(DefaultImportClientBrandingAttributes deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux;
            return this;
        }

        public final DefaultImportClientBrandingAttributes.Builder getDeviceTypeWeb() {
            return deviceTypeWeb != null ? deviceTypeWeb.toBuilder() : null;
        }

        public final void setDeviceTypeWeb(DefaultImportClientBrandingAttributes.BuilderImpl deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb != null ? deviceTypeWeb.build() : null;
        }

        @Override
        public final Builder deviceTypeWeb(DefaultImportClientBrandingAttributes deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportClientBrandingRequest build() {
            return new ImportClientBrandingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
