/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceImagePermissionsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspaceImagePermissionsResponse.Builder, DescribeWorkspaceImagePermissionsResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(DescribeWorkspaceImagePermissionsResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<List<ImagePermission>> IMAGE_PERMISSIONS_FIELD = SdkField
            .<List<ImagePermission>> builder(MarshallingType.LIST)
            .memberName("ImagePermissions")
            .getter(getter(DescribeWorkspaceImagePermissionsResponse::imagePermissions))
            .setter(setter(Builder::imagePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImagePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImagePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspaceImagePermissionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            IMAGE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String imageId;

    private final List<ImagePermission> imagePermissions;

    private final String nextToken;

    private DescribeWorkspaceImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.imagePermissions = builder.imagePermissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the image.
     * </p>
     * 
     * @return The identifier of the image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImagePermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImagePermissions() {
        return imagePermissions != null && !(imagePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the Amazon Web Services accounts that the image has been shared with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImagePermissions} method.
     * </p>
     * 
     * @return The identifiers of the Amazon Web Services accounts that the image has been shared with.
     */
    public final List<ImagePermission> imagePermissions() {
        return imagePermissions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImagePermissions() ? imagePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagePermissionsResponse)) {
            return false;
        }
        DescribeWorkspaceImagePermissionsResponse other = (DescribeWorkspaceImagePermissionsResponse) obj;
        return Objects.equals(imageId(), other.imageId()) && hasImagePermissions() == other.hasImagePermissions()
                && Objects.equals(imagePermissions(), other.imagePermissions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceImagePermissionsResponse").add("ImageId", imageId())
                .add("ImagePermissions", hasImagePermissions() ? imagePermissions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImagePermissions", IMAGE_PERMISSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceImagePermissionsResponse> {
        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The identifiers of the Amazon Web Services accounts that the image has been shared with.
         * </p>
         * 
         * @param imagePermissions
         *        The identifiers of the Amazon Web Services accounts that the image has been shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(Collection<ImagePermission> imagePermissions);

        /**
         * <p>
         * The identifiers of the Amazon Web Services accounts that the image has been shared with.
         * </p>
         * 
         * @param imagePermissions
         *        The identifiers of the Amazon Web Services accounts that the image has been shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermission... imagePermissions);

        /**
         * <p>
         * The identifiers of the Amazon Web Services accounts that the image has been shared with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.ImagePermission.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.ImagePermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.ImagePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #imagePermissions(List<ImagePermission>)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.ImagePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(java.util.Collection<ImagePermission>)
         */
        Builder imagePermissions(Consumer<ImagePermission.Builder>... imagePermissions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String imageId;

        private List<ImagePermission> imagePermissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagePermissionsResponse model) {
            super(model);
            imageId(model.imageId);
            imagePermissions(model.imagePermissions);
            nextToken(model.nextToken);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<ImagePermission.Builder> getImagePermissions() {
            List<ImagePermission.Builder> result = ImagePermissionsCopier.copyToBuilder(this.imagePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePermissions(Collection<ImagePermission.BuilderImpl> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copyFromBuilder(imagePermissions);
        }

        @Override
        public final Builder imagePermissions(Collection<ImagePermission> imagePermissions) {
            this.imagePermissions = ImagePermissionsCopier.copy(imagePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(ImagePermission... imagePermissions) {
            imagePermissions(Arrays.asList(imagePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePermissions(Consumer<ImagePermission.Builder>... imagePermissions) {
            imagePermissions(Stream.of(imagePermissions).map(c -> ImagePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspaceImagePermissionsResponse build() {
            return new DescribeWorkspaceImagePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
