/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBundleAssociationsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeBundleAssociationsRequest.Builder, DescribeBundleAssociationsRequest> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(DescribeBundleAssociationsRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedResourceTypes")
            .getter(getter(DescribeBundleAssociationsRequest::associatedResourceTypesAsStrings))
            .setter(setter(Builder::associatedResourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD,
            ASSOCIATED_RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bundleId;

    private final List<String> associatedResourceTypes;

    private DescribeBundleAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.bundleId = builder.bundleId;
        this.associatedResourceTypes = builder.associatedResourceTypes;
    }

    /**
     * <p>
     * The identifier of the bundle.
     * </p>
     * 
     * @return The identifier of the bundle.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The resource types of the associated resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResourceTypes} method.
     * </p>
     * 
     * @return The resource types of the associated resource.
     */
    public final List<BundleAssociatedResourceType> associatedResourceTypes() {
        return BundleAssociatedResourceTypeListCopier.copyStringToEnum(associatedResourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResourceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedResourceTypes() {
        return associatedResourceTypes != null && !(associatedResourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types of the associated resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResourceTypes} method.
     * </p>
     * 
     * @return The resource types of the associated resource.
     */
    public final List<String> associatedResourceTypesAsStrings() {
        return associatedResourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResourceTypes() ? associatedResourceTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleAssociationsRequest)) {
            return false;
        }
        DescribeBundleAssociationsRequest other = (DescribeBundleAssociationsRequest) obj;
        return Objects.equals(bundleId(), other.bundleId()) && hasAssociatedResourceTypes() == other.hasAssociatedResourceTypes()
                && Objects.equals(associatedResourceTypesAsStrings(), other.associatedResourceTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBundleAssociationsRequest").add("BundleId", bundleId())
                .add("AssociatedResourceTypes", hasAssociatedResourceTypes() ? associatedResourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "AssociatedResourceTypes":
            return Optional.ofNullable(clazz.cast(associatedResourceTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("AssociatedResourceTypes", ASSOCIATED_RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeBundleAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBundleAssociationsRequest> {
        /**
         * <p>
         * The identifier of the bundle.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The resource types of the associated resource.
         * </p>
         * 
         * @param associatedResourceTypes
         *        The resource types of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceTypesWithStrings(Collection<String> associatedResourceTypes);

        /**
         * <p>
         * The resource types of the associated resource.
         * </p>
         * 
         * @param associatedResourceTypes
         *        The resource types of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceTypesWithStrings(String... associatedResourceTypes);

        /**
         * <p>
         * The resource types of the associated resource.
         * </p>
         * 
         * @param associatedResourceTypes
         *        The resource types of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceTypes(Collection<BundleAssociatedResourceType> associatedResourceTypes);

        /**
         * <p>
         * The resource types of the associated resource.
         * </p>
         * 
         * @param associatedResourceTypes
         *        The resource types of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceTypes(BundleAssociatedResourceType... associatedResourceTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String bundleId;

        private List<String> associatedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleAssociationsRequest model) {
            super(model);
            bundleId(model.bundleId);
            associatedResourceTypesWithStrings(model.associatedResourceTypes);
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final Collection<String> getAssociatedResourceTypes() {
            if (associatedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResourceTypes;
        }

        public final void setAssociatedResourceTypes(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = BundleAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
        }

        @Override
        public final Builder associatedResourceTypesWithStrings(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = BundleAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypesWithStrings(String... associatedResourceTypes) {
            associatedResourceTypesWithStrings(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public final Builder associatedResourceTypes(Collection<BundleAssociatedResourceType> associatedResourceTypes) {
            this.associatedResourceTypes = BundleAssociatedResourceTypeListCopier.copyEnumToString(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypes(BundleAssociatedResourceType... associatedResourceTypes) {
            associatedResourceTypes(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBundleAssociationsRequest build() {
            return new DescribeBundleAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
