/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeAccountResponse.Builder, DescribeAccountResponse> {
    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancySupport").getter(getter(DescribeAccountResponse::dedicatedTenancySupportAsString))
            .setter(setter(Builder::dedicatedTenancySupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build())
            .build();

    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancyManagementCidrRange")
            .getter(getter(DescribeAccountResponse::dedicatedTenancyManagementCidrRange))
            .setter(setter(Builder::dedicatedTenancyManagementCidrRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DedicatedTenancyManagementCidrRange").build()).build();

    private static final SdkField<String> DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancyAccountType")
            .getter(getter(DescribeAccountResponse::dedicatedTenancyAccountTypeAsString))
            .setter(setter(Builder::dedicatedTenancyAccountType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancyAccountType")
                    .build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeAccountResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD, DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dedicatedTenancySupport;

    private final String dedicatedTenancyManagementCidrRange;

    private final String dedicatedTenancyAccountType;

    private final String message;

    private DescribeAccountResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
        this.dedicatedTenancyAccountType = builder.dedicatedTenancyAccountType;
        this.message = builder.message;
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final DedicatedTenancySupportResultEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportResultEnum.fromValue(dedicatedTenancySupport);
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final String dedicatedTenancySupportAsString() {
        return dedicatedTenancySupport;
    }

    /**
     * <p>
     * The IP address range, specified as an IPv4 CIDR block, used for the management network interface.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     * 
     * @return The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p>
     *         <p>
     *         The management network interface is connected to a secure Amazon WorkSpaces management network. It is
     *         used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon
     *         WorkSpaces to manage the WorkSpace.
     */
    public final String dedicatedTenancyManagementCidrRange() {
        return dedicatedTenancyManagementCidrRange;
    }

    /**
     * <p>
     * The type of linked account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancyAccountType} will return {@link DedicatedTenancyAccountType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #dedicatedTenancyAccountTypeAsString}.
     * </p>
     * 
     * @return The type of linked account.
     * @see DedicatedTenancyAccountType
     */
    public final DedicatedTenancyAccountType dedicatedTenancyAccountType() {
        return DedicatedTenancyAccountType.fromValue(dedicatedTenancyAccountType);
    }

    /**
     * <p>
     * The type of linked account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancyAccountType} will return {@link DedicatedTenancyAccountType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #dedicatedTenancyAccountTypeAsString}.
     * </p>
     * 
     * @return The type of linked account.
     * @see DedicatedTenancyAccountType
     */
    public final String dedicatedTenancyAccountTypeAsString() {
        return dedicatedTenancyAccountType;
    }

    /**
     * <p>
     * The text message to describe the status of BYOL.
     * </p>
     * 
     * @return The text message to describe the status of BYOL.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancyManagementCidrRange());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancyAccountTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountResponse)) {
            return false;
        }
        DescribeAccountResponse other = (DescribeAccountResponse) obj;
        return Objects.equals(dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString())
                && Objects.equals(dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange())
                && Objects.equals(dedicatedTenancyAccountTypeAsString(), other.dedicatedTenancyAccountTypeAsString())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountResponse").add("DedicatedTenancySupport", dedicatedTenancySupportAsString())
                .add("DedicatedTenancyManagementCidrRange", dedicatedTenancyManagementCidrRange())
                .add("DedicatedTenancyAccountType", dedicatedTenancyAccountTypeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DedicatedTenancySupport":
            return Optional.ofNullable(clazz.cast(dedicatedTenancySupportAsString()));
        case "DedicatedTenancyManagementCidrRange":
            return Optional.ofNullable(clazz.cast(dedicatedTenancyManagementCidrRange()));
        case "DedicatedTenancyAccountType":
            return Optional.ofNullable(clazz.cast(dedicatedTenancyAccountTypeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DedicatedTenancySupport", DEDICATED_TENANCY_SUPPORT_FIELD);
        map.put("DedicatedTenancyManagementCidrRange", DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD);
        map.put("DedicatedTenancyAccountType", DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountResponse, T> g) {
        return obj -> g.apply((DescribeAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountResponse> {
        /**
         * <p>
         * The status of BYOL (whether BYOL is enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(String dedicatedTenancySupport);

        /**
         * <p>
         * The status of BYOL (whether BYOL is enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport);

        /**
         * <p>
         * The IP address range, specified as an IPv4 CIDR block, used for the management network interface.
         * </p>
         * <p>
         * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used
         * for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon
         * WorkSpaces to manage the WorkSpace.
         * </p>
         * 
         * @param dedicatedTenancyManagementCidrRange
         *        The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p>
         *        <p>
         *        The management network interface is connected to a secure Amazon WorkSpaces management network. It is
         *        used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow
         *        Amazon WorkSpaces to manage the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange);

        /**
         * <p>
         * The type of linked account.
         * </p>
         * 
         * @param dedicatedTenancyAccountType
         *        The type of linked account.
         * @see DedicatedTenancyAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancyAccountType
         */
        Builder dedicatedTenancyAccountType(String dedicatedTenancyAccountType);

        /**
         * <p>
         * The type of linked account.
         * </p>
         * 
         * @param dedicatedTenancyAccountType
         *        The type of linked account.
         * @see DedicatedTenancyAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancyAccountType
         */
        Builder dedicatedTenancyAccountType(DedicatedTenancyAccountType dedicatedTenancyAccountType);

        /**
         * <p>
         * The text message to describe the status of BYOL.
         * </p>
         * 
         * @param message
         *        The text message to describe the status of BYOL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String dedicatedTenancySupport;

        private String dedicatedTenancyManagementCidrRange;

        private String dedicatedTenancyAccountType;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountResponse model) {
            super(model);
            dedicatedTenancySupport(model.dedicatedTenancySupport);
            dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
            dedicatedTenancyAccountType(model.dedicatedTenancyAccountType);
            message(model.message);
        }

        public final String getDedicatedTenancySupport() {
            return dedicatedTenancySupport;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return dedicatedTenancyManagementCidrRange;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        public final String getDedicatedTenancyAccountType() {
            return dedicatedTenancyAccountType;
        }

        public final void setDedicatedTenancyAccountType(String dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType = dedicatedTenancyAccountType;
        }

        @Override
        public final Builder dedicatedTenancyAccountType(String dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType = dedicatedTenancyAccountType;
            return this;
        }

        @Override
        public final Builder dedicatedTenancyAccountType(DedicatedTenancyAccountType dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType(dedicatedTenancyAccountType == null ? null : dedicatedTenancyAccountType.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DescribeAccountResponse build() {
            return new DescribeAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
