/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the default values that are used to create WorkSpaces. For more information, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory
 * Details for Your WorkSpaces</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultWorkspaceCreationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultWorkspaceCreationProperties.Builder, DefaultWorkspaceCreationProperties> {
    private static final SdkField<Boolean> ENABLE_INTERNET_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInternetAccess").getter(getter(DefaultWorkspaceCreationProperties::enableInternetAccess))
            .setter(setter(Builder::enableInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInternetAccess").build())
            .build();

    private static final SdkField<String> DEFAULT_OU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOu").getter(getter(DefaultWorkspaceCreationProperties::defaultOu))
            .setter(setter(Builder::defaultOu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOu").build()).build();

    private static final SdkField<String> CUSTOM_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomSecurityGroupId").getter(getter(DefaultWorkspaceCreationProperties::customSecurityGroupId))
            .setter(setter(Builder::customSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupId").build())
            .build();

    private static final SdkField<Boolean> USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserEnabledAsLocalAdministrator")
            .getter(getter(DefaultWorkspaceCreationProperties::userEnabledAsLocalAdministrator))
            .setter(setter(Builder::userEnabledAsLocalAdministrator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserEnabledAsLocalAdministrator")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_MAINTENANCE_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMaintenanceMode").getter(getter(DefaultWorkspaceCreationProperties::enableMaintenanceMode))
            .setter(setter(Builder::enableMaintenanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMaintenanceMode").build())
            .build();

    private static final SdkField<String> INSTANCE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceIamRoleArn").getter(getter(DefaultWorkspaceCreationProperties::instanceIamRoleArn))
            .setter(setter(Builder::instanceIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIamRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_INTERNET_ACCESS_FIELD,
            DEFAULT_OU_FIELD, CUSTOM_SECURITY_GROUP_ID_FIELD, USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD,
            ENABLE_MAINTENANCE_MODE_FIELD, INSTANCE_IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableInternetAccess;

    private final String defaultOu;

    private final String customSecurityGroupId;

    private final Boolean userEnabledAsLocalAdministrator;

    private final Boolean enableMaintenanceMode;

    private final String instanceIamRoleArn;

    private DefaultWorkspaceCreationProperties(BuilderImpl builder) {
        this.enableInternetAccess = builder.enableInternetAccess;
        this.defaultOu = builder.defaultOu;
        this.customSecurityGroupId = builder.customSecurityGroupId;
        this.userEnabledAsLocalAdministrator = builder.userEnabledAsLocalAdministrator;
        this.enableMaintenanceMode = builder.enableMaintenanceMode;
        this.instanceIamRoleArn = builder.instanceIamRoleArn;
    }

    /**
     * <p>
     * Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by
     * default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when
     * you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a
     * Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are
     * in public subnets and you manually assign them Elastic IP addresses, you should disable this setting. This
     * setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html">
     * Configure a VPC for Amazon WorkSpaces</a>.
     * </p>
     * 
     * @return Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by
     *         default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces
     *         when you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're
     *         using a Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your
     *         WorkSpaces are in public subnets and you manually assign them Elastic IP addresses, you should disable
     *         this setting. This setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you
     *         rebuild. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     */
    public final Boolean enableInternetAccess() {
        return enableInternetAccess;
    }

    /**
     * <p>
     * The organizational unit (OU) in the directory for the WorkSpace machine accounts.
     * </p>
     * 
     * @return The organizational unit (OU) in the directory for the WorkSpace machine accounts.
     */
    public final String defaultOu() {
        return defaultOu;
    }

    /**
     * <p>
     * The identifier of the default security group to apply to WorkSpaces when they are created. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
     * Security Groups for Your WorkSpaces</a>.
     * </p>
     * 
     * @return The identifier of the default security group to apply to WorkSpaces when they are created. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
     *         Security Groups for Your WorkSpaces</a>.
     */
    public final String customSecurityGroupId() {
        return customSecurityGroupId;
    }

    /**
     * <p>
     * Specifies whether WorkSpace users are local administrators on their WorkSpaces.
     * </p>
     * 
     * @return Specifies whether WorkSpace users are local administrators on their WorkSpaces.
     */
    public final Boolean userEnabledAsLocalAdministrator() {
        return userEnabledAsLocalAdministrator;
    }

    /**
     * <p>
     * Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
     * Maintenance</a>.
     * </p>
     * 
     * @return Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
     *         Maintenance</a>.
     */
    public final Boolean enableMaintenanceMode() {
        return enableMaintenanceMode;
    }

    /**
     * <p>
     * Indicates the IAM role ARN of the instance.
     * </p>
     * 
     * @return Indicates the IAM role ARN of the instance.
     */
    public final String instanceIamRoleArn() {
        return instanceIamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOu());
        hashCode = 31 * hashCode + Objects.hashCode(customSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(userEnabledAsLocalAdministrator());
        hashCode = 31 * hashCode + Objects.hashCode(enableMaintenanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultWorkspaceCreationProperties)) {
            return false;
        }
        DefaultWorkspaceCreationProperties other = (DefaultWorkspaceCreationProperties) obj;
        return Objects.equals(enableInternetAccess(), other.enableInternetAccess())
                && Objects.equals(defaultOu(), other.defaultOu())
                && Objects.equals(customSecurityGroupId(), other.customSecurityGroupId())
                && Objects.equals(userEnabledAsLocalAdministrator(), other.userEnabledAsLocalAdministrator())
                && Objects.equals(enableMaintenanceMode(), other.enableMaintenanceMode())
                && Objects.equals(instanceIamRoleArn(), other.instanceIamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultWorkspaceCreationProperties").add("EnableInternetAccess", enableInternetAccess())
                .add("DefaultOu", defaultOu()).add("CustomSecurityGroupId", customSecurityGroupId())
                .add("UserEnabledAsLocalAdministrator", userEnabledAsLocalAdministrator())
                .add("EnableMaintenanceMode", enableMaintenanceMode()).add("InstanceIamRoleArn", instanceIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableInternetAccess":
            return Optional.ofNullable(clazz.cast(enableInternetAccess()));
        case "DefaultOu":
            return Optional.ofNullable(clazz.cast(defaultOu()));
        case "CustomSecurityGroupId":
            return Optional.ofNullable(clazz.cast(customSecurityGroupId()));
        case "UserEnabledAsLocalAdministrator":
            return Optional.ofNullable(clazz.cast(userEnabledAsLocalAdministrator()));
        case "EnableMaintenanceMode":
            return Optional.ofNullable(clazz.cast(enableMaintenanceMode()));
        case "InstanceIamRoleArn":
            return Optional.ofNullable(clazz.cast(instanceIamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableInternetAccess", ENABLE_INTERNET_ACCESS_FIELD);
        map.put("DefaultOu", DEFAULT_OU_FIELD);
        map.put("CustomSecurityGroupId", CUSTOM_SECURITY_GROUP_ID_FIELD);
        map.put("UserEnabledAsLocalAdministrator", USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD);
        map.put("EnableMaintenanceMode", ENABLE_MAINTENANCE_MODE_FIELD);
        map.put("InstanceIamRoleArn", INSTANCE_IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultWorkspaceCreationProperties, T> g) {
        return obj -> g.apply((DefaultWorkspaceCreationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultWorkspaceCreationProperties> {
        /**
         * <p>
         * Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by
         * default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when
         * you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a
         * Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces
         * are in public subnets and you manually assign them Elastic IP addresses, you should disable this setting.
         * This setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC
         * for Amazon WorkSpaces</a>.
         * </p>
         * 
         * @param enableInternetAccess
         *        Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory
         *        by default. If enabled, the Elastic public IP address allows outbound internet access from your
         *        WorkSpaces when you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are
         *        located. If you're using a Network Address Translation (NAT) gateway for outbound internet access from
         *        your VPC, or if your WorkSpaces are in public subnets and you manually assign them Elastic IP
         *        addresses, you should disable this setting. This setting applies to new WorkSpaces that you launch or
         *        to existing WorkSpaces that you rebuild. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure
         *        a VPC for Amazon WorkSpaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInternetAccess(Boolean enableInternetAccess);

        /**
         * <p>
         * The organizational unit (OU) in the directory for the WorkSpace machine accounts.
         * </p>
         * 
         * @param defaultOu
         *        The organizational unit (OU) in the directory for the WorkSpace machine accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOu(String defaultOu);

        /**
         * <p>
         * The identifier of the default security group to apply to WorkSpaces when they are created. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
         * Security Groups for Your WorkSpaces</a>.
         * </p>
         * 
         * @param customSecurityGroupId
         *        The identifier of the default security group to apply to WorkSpaces when they are created. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html">
         *        Security Groups for Your WorkSpaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupId(String customSecurityGroupId);

        /**
         * <p>
         * Specifies whether WorkSpace users are local administrators on their WorkSpaces.
         * </p>
         * 
         * @param userEnabledAsLocalAdministrator
         *        Specifies whether WorkSpace users are local administrators on their WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator);

        /**
         * <p>
         * Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
         * Maintenance</a>.
         * </p>
         * 
         * @param enableMaintenanceMode
         *        Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
         *        Maintenance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMaintenanceMode(Boolean enableMaintenanceMode);

        /**
         * <p>
         * Indicates the IAM role ARN of the instance.
         * </p>
         * 
         * @param instanceIamRoleArn
         *        Indicates the IAM role ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIamRoleArn(String instanceIamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableInternetAccess;

        private String defaultOu;

        private String customSecurityGroupId;

        private Boolean userEnabledAsLocalAdministrator;

        private Boolean enableMaintenanceMode;

        private String instanceIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultWorkspaceCreationProperties model) {
            enableInternetAccess(model.enableInternetAccess);
            defaultOu(model.defaultOu);
            customSecurityGroupId(model.customSecurityGroupId);
            userEnabledAsLocalAdministrator(model.userEnabledAsLocalAdministrator);
            enableMaintenanceMode(model.enableMaintenanceMode);
            instanceIamRoleArn(model.instanceIamRoleArn);
        }

        public final Boolean getEnableInternetAccess() {
            return enableInternetAccess;
        }

        public final void setEnableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
        }

        @Override
        public final Builder enableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
            return this;
        }

        public final String getDefaultOu() {
            return defaultOu;
        }

        public final void setDefaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
        }

        @Override
        public final Builder defaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
            return this;
        }

        public final String getCustomSecurityGroupId() {
            return customSecurityGroupId;
        }

        public final void setCustomSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
        }

        @Override
        public final Builder customSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
            return this;
        }

        public final Boolean getUserEnabledAsLocalAdministrator() {
            return userEnabledAsLocalAdministrator;
        }

        public final void setUserEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
        }

        @Override
        public final Builder userEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
            return this;
        }

        public final Boolean getEnableMaintenanceMode() {
            return enableMaintenanceMode;
        }

        public final void setEnableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
        }

        @Override
        public final Builder enableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
            return this;
        }

        public final String getInstanceIamRoleArn() {
            return instanceIamRoleArn;
        }

        public final void setInstanceIamRoleArn(String instanceIamRoleArn) {
            this.instanceIamRoleArn = instanceIamRoleArn;
        }

        @Override
        public final Builder instanceIamRoleArn(String instanceIamRoleArn) {
            this.instanceIamRoleArn = instanceIamRoleArn;
            return this;
        }

        @Override
        public DefaultWorkspaceCreationProperties build() {
            return new DefaultWorkspaceCreationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
