/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about about the account link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLink implements SdkPojo, Serializable, ToCopyableBuilder<AccountLink.Builder, AccountLink> {
    private static final SdkField<String> ACCOUNT_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountLinkId").getter(getter(AccountLink::accountLinkId)).setter(setter(Builder::accountLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinkId").build()).build();

    private static final SdkField<String> ACCOUNT_LINK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountLinkStatus").getter(getter(AccountLink::accountLinkStatusAsString))
            .setter(setter(Builder::accountLinkStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinkStatus").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceAccountId").getter(getter(AccountLink::sourceAccountId)).setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()).build();

    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAccountId").getter(getter(AccountLink::targetAccountId)).setter(setter(Builder::targetAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LINK_ID_FIELD,
            ACCOUNT_LINK_STATUS_FIELD, SOURCE_ACCOUNT_ID_FIELD, TARGET_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountLinkId;

    private final String accountLinkStatus;

    private final String sourceAccountId;

    private final String targetAccountId;

    private AccountLink(BuilderImpl builder) {
        this.accountLinkId = builder.accountLinkId;
        this.accountLinkStatus = builder.accountLinkStatus;
        this.sourceAccountId = builder.sourceAccountId;
        this.targetAccountId = builder.targetAccountId;
    }

    /**
     * <p>
     * The identifier of the account link.
     * </p>
     * 
     * @return The identifier of the account link.
     */
    public final String accountLinkId() {
        return accountLinkId;
    }

    /**
     * <p>
     * The status of the account link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountLinkStatus}
     * will return {@link AccountLinkStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accountLinkStatusAsString}.
     * </p>
     * 
     * @return The status of the account link.
     * @see AccountLinkStatusEnum
     */
    public final AccountLinkStatusEnum accountLinkStatus() {
        return AccountLinkStatusEnum.fromValue(accountLinkStatus);
    }

    /**
     * <p>
     * The status of the account link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountLinkStatus}
     * will return {@link AccountLinkStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accountLinkStatusAsString}.
     * </p>
     * 
     * @return The status of the account link.
     * @see AccountLinkStatusEnum
     */
    public final String accountLinkStatusAsString() {
        return accountLinkStatus;
    }

    /**
     * <p>
     * The identifier of the source account.
     * </p>
     * 
     * @return The identifier of the source account.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * The identifier of the target account.
     * </p>
     * 
     * @return The identifier of the target account.
     */
    public final String targetAccountId() {
        return targetAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(accountLinkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLink)) {
            return false;
        }
        AccountLink other = (AccountLink) obj;
        return Objects.equals(accountLinkId(), other.accountLinkId())
                && Objects.equals(accountLinkStatusAsString(), other.accountLinkStatusAsString())
                && Objects.equals(sourceAccountId(), other.sourceAccountId())
                && Objects.equals(targetAccountId(), other.targetAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountLink").add("AccountLinkId", accountLinkId())
                .add("AccountLinkStatus", accountLinkStatusAsString()).add("SourceAccountId", sourceAccountId())
                .add("TargetAccountId", targetAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountLinkId":
            return Optional.ofNullable(clazz.cast(accountLinkId()));
        case "AccountLinkStatus":
            return Optional.ofNullable(clazz.cast(accountLinkStatusAsString()));
        case "SourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "TargetAccountId":
            return Optional.ofNullable(clazz.cast(targetAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountLinkId", ACCOUNT_LINK_ID_FIELD);
        map.put("AccountLinkStatus", ACCOUNT_LINK_STATUS_FIELD);
        map.put("SourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("TargetAccountId", TARGET_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountLink, T> g) {
        return obj -> g.apply((AccountLink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLink> {
        /**
         * <p>
         * The identifier of the account link.
         * </p>
         * 
         * @param accountLinkId
         *        The identifier of the account link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLinkId(String accountLinkId);

        /**
         * <p>
         * The status of the account link.
         * </p>
         * 
         * @param accountLinkStatus
         *        The status of the account link.
         * @see AccountLinkStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLinkStatusEnum
         */
        Builder accountLinkStatus(String accountLinkStatus);

        /**
         * <p>
         * The status of the account link.
         * </p>
         * 
         * @param accountLinkStatus
         *        The status of the account link.
         * @see AccountLinkStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLinkStatusEnum
         */
        Builder accountLinkStatus(AccountLinkStatusEnum accountLinkStatus);

        /**
         * <p>
         * The identifier of the source account.
         * </p>
         * 
         * @param sourceAccountId
         *        The identifier of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * The identifier of the target account.
         * </p>
         * 
         * @param targetAccountId
         *        The identifier of the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountId(String targetAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String accountLinkId;

        private String accountLinkStatus;

        private String sourceAccountId;

        private String targetAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLink model) {
            accountLinkId(model.accountLinkId);
            accountLinkStatus(model.accountLinkStatus);
            sourceAccountId(model.sourceAccountId);
            targetAccountId(model.targetAccountId);
        }

        public final String getAccountLinkId() {
            return accountLinkId;
        }

        public final void setAccountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
        }

        @Override
        public final Builder accountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
            return this;
        }

        public final String getAccountLinkStatus() {
            return accountLinkStatus;
        }

        public final void setAccountLinkStatus(String accountLinkStatus) {
            this.accountLinkStatus = accountLinkStatus;
        }

        @Override
        public final Builder accountLinkStatus(String accountLinkStatus) {
            this.accountLinkStatus = accountLinkStatus;
            return this;
        }

        @Override
        public final Builder accountLinkStatus(AccountLinkStatusEnum accountLinkStatus) {
            this.accountLinkStatus(accountLinkStatus == null ? null : accountLinkStatus.toString());
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getTargetAccountId() {
            return targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        @Override
        public AccountLink build() {
            return new AccountLink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
