/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the access type and endpoint for a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<AccessEndpoint.Builder, AccessEndpoint> {
    private static final SdkField<String> ACCESS_ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessEndpointType").getter(getter(AccessEndpoint::accessEndpointTypeAsString))
            .setter(setter(Builder::accessEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpointType").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(AccessEndpoint::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENDPOINT_TYPE_FIELD,
            VPC_ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessEndpointType;

    private final String vpcEndpointId;

    private AccessEndpoint(BuilderImpl builder) {
        this.accessEndpointType = builder.accessEndpointType;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    /**
     * <p>
     * Indicates the type of access endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessEndpointType} will return {@link AccessEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #accessEndpointTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of access endpoint.
     * @see AccessEndpointType
     */
    public final AccessEndpointType accessEndpointType() {
        return AccessEndpointType.fromValue(accessEndpointType);
    }

    /**
     * <p>
     * Indicates the type of access endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessEndpointType} will return {@link AccessEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #accessEndpointTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of access endpoint.
     * @see AccessEndpointType
     */
    public final String accessEndpointTypeAsString() {
        return accessEndpointType;
    }

    /**
     * <p>
     * Indicates the VPC endpoint to use for access.
     * </p>
     * 
     * @return Indicates the VPC endpoint to use for access.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpoint)) {
            return false;
        }
        AccessEndpoint other = (AccessEndpoint) obj;
        return Objects.equals(accessEndpointTypeAsString(), other.accessEndpointTypeAsString())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessEndpoint").add("AccessEndpointType", accessEndpointTypeAsString())
                .add("VpcEndpointId", vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessEndpointType":
            return Optional.ofNullable(clazz.cast(accessEndpointTypeAsString()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessEndpointType", ACCESS_ENDPOINT_TYPE_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpoint, T> g) {
        return obj -> g.apply((AccessEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessEndpoint> {
        /**
         * <p>
         * Indicates the type of access endpoint.
         * </p>
         * 
         * @param accessEndpointType
         *        Indicates the type of access endpoint.
         * @see AccessEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEndpointType
         */
        Builder accessEndpointType(String accessEndpointType);

        /**
         * <p>
         * Indicates the type of access endpoint.
         * </p>
         * 
         * @param accessEndpointType
         *        Indicates the type of access endpoint.
         * @see AccessEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEndpointType
         */
        Builder accessEndpointType(AccessEndpointType accessEndpointType);

        /**
         * <p>
         * Indicates the VPC endpoint to use for access.
         * </p>
         * 
         * @param vpcEndpointId
         *        Indicates the VPC endpoint to use for access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);
    }

    static final class BuilderImpl implements Builder {
        private String accessEndpointType;

        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpoint model) {
            accessEndpointType(model.accessEndpointType);
            vpcEndpointId(model.vpcEndpointId);
        }

        public final String getAccessEndpointType() {
            return accessEndpointType;
        }

        public final void setAccessEndpointType(String accessEndpointType) {
            this.accessEndpointType = accessEndpointType;
        }

        @Override
        public final Builder accessEndpointType(String accessEndpointType) {
            this.accessEndpointType = accessEndpointType;
            return this;
        }

        @Override
        public final Builder accessEndpointType(AccessEndpointType accessEndpointType) {
            this.accessEndpointType(accessEndpointType == null ? null : accessEndpointType.toString());
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        @Override
        public AccessEndpoint build() {
            return new AccessEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
