/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DataReplication;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandbyWorkspace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandbyWorkspace> {
    private static final SdkField<String> PRIMARY_WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryWorkspaceId").getter(StandbyWorkspace.getter(StandbyWorkspace::primaryWorkspaceId)).setter(StandbyWorkspace.setter(Builder::primaryWorkspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryWorkspaceId").build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeEncryptionKey").getter(StandbyWorkspace.getter(StandbyWorkspace::volumeEncryptionKey)).setter(StandbyWorkspace.setter(Builder::volumeEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(StandbyWorkspace.getter(StandbyWorkspace::directoryId)).setter(StandbyWorkspace.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StandbyWorkspace.getter(StandbyWorkspace::tags)).setter(StandbyWorkspace.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataReplication").getter(StandbyWorkspace.getter(StandbyWorkspace::dataReplicationAsString)).setter(StandbyWorkspace.setter(Builder::dataReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_WORKSPACE_ID_FIELD, VOLUME_ENCRYPTION_KEY_FIELD, DIRECTORY_ID_FIELD, TAGS_FIELD, DATA_REPLICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PrimaryWorkspaceId", PRIMARY_WORKSPACE_ID_FIELD);
            this.put("VolumeEncryptionKey", VOLUME_ENCRYPTION_KEY_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("DataReplication", DATA_REPLICATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String primaryWorkspaceId;
    private final String volumeEncryptionKey;
    private final String directoryId;
    private final List<Tag> tags;
    private final String dataReplication;

    private StandbyWorkspace(BuilderImpl builder) {
        this.primaryWorkspaceId = builder.primaryWorkspaceId;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.directoryId = builder.directoryId;
        this.tags = builder.tags;
        this.dataReplication = builder.dataReplication;
    }

    public final String primaryWorkspaceId() {
        return this.primaryWorkspaceId;
    }

    public final String volumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final DataReplication dataReplication() {
        return DataReplication.fromValue(this.dataReplication);
    }

    public final String dataReplicationAsString() {
        return this.dataReplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandbyWorkspace)) {
            return false;
        }
        StandbyWorkspace other = (StandbyWorkspace)obj;
        return Objects.equals(this.primaryWorkspaceId(), other.primaryWorkspaceId()) && Objects.equals(this.volumeEncryptionKey(), other.volumeEncryptionKey()) && Objects.equals(this.directoryId(), other.directoryId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dataReplicationAsString(), other.dataReplicationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StandbyWorkspace").add("PrimaryWorkspaceId", (Object)this.primaryWorkspaceId()).add("VolumeEncryptionKey", (Object)this.volumeEncryptionKey()).add("DirectoryId", (Object)this.directoryId()).add("Tags", this.hasTags() ? this.tags() : null).add("DataReplication", (Object)this.dataReplicationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryWorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.primaryWorkspaceId()));
            }
            case "VolumeEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKey()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DataReplication": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StandbyWorkspace, T> g) {
        return obj -> g.apply((StandbyWorkspace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryWorkspaceId;
        private String volumeEncryptionKey;
        private String directoryId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String dataReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(StandbyWorkspace model) {
            this.primaryWorkspaceId(model.primaryWorkspaceId);
            this.volumeEncryptionKey(model.volumeEncryptionKey);
            this.directoryId(model.directoryId);
            this.tags(model.tags);
            this.dataReplication(model.dataReplication);
        }

        public final String getPrimaryWorkspaceId() {
            return this.primaryWorkspaceId;
        }

        public final void setPrimaryWorkspaceId(String primaryWorkspaceId) {
            this.primaryWorkspaceId = primaryWorkspaceId;
        }

        @Override
        public final Builder primaryWorkspaceId(String primaryWorkspaceId) {
            this.primaryWorkspaceId = primaryWorkspaceId;
            return this;
        }

        public final String getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataReplication() {
            return this.dataReplication;
        }

        public final void setDataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
        }

        @Override
        public final Builder dataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
            return this;
        }

        @Override
        public final Builder dataReplication(DataReplication dataReplication) {
            this.dataReplication(dataReplication == null ? null : dataReplication.toString());
            return this;
        }

        public StandbyWorkspace build() {
            return new StandbyWorkspace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandbyWorkspace> {
        public Builder primaryWorkspaceId(String var1);

        public Builder volumeEncryptionKey(String var1);

        public Builder directoryId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dataReplication(String var1);

        public Builder dataReplication(DataReplication var1);
    }
}

