/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Compute;
import software.amazon.awssdk.services.workspaces.model.ComputeListCopier;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemName;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemNameListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeApplicationsRequest> {
    private static final SdkField<List<String>> APPLICATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationIds").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::applicationIds)).setter(DescribeApplicationsRequest.setter(Builder::applicationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMPUTE_TYPE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComputeTypeNames").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::computeTypeNamesAsStrings)).setter(DescribeApplicationsRequest.setter(Builder::computeTypeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTypeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::licenseTypeAsString)).setter(DescribeApplicationsRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<List<String>> OPERATING_SYSTEM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingSystemNames").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::operatingSystemNamesAsStrings)).setter(DescribeApplicationsRequest.setter(Builder::operatingSystemNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::owner)).setter(DescribeApplicationsRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::maxResults)).setter(DescribeApplicationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeApplicationsRequest.getter(DescribeApplicationsRequest::nextToken)).setter(DescribeApplicationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDS_FIELD, COMPUTE_TYPE_NAMES_FIELD, LICENSE_TYPE_FIELD, OPERATING_SYSTEM_NAMES_FIELD, OWNER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationIds", APPLICATION_IDS_FIELD);
            this.put("ComputeTypeNames", COMPUTE_TYPE_NAMES_FIELD);
            this.put("LicenseType", LICENSE_TYPE_FIELD);
            this.put("OperatingSystemNames", OPERATING_SYSTEM_NAMES_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> applicationIds;
    private final List<String> computeTypeNames;
    private final String licenseType;
    private final List<String> operatingSystemNames;
    private final String owner;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIds = builder.applicationIds;
        this.computeTypeNames = builder.computeTypeNames;
        this.licenseType = builder.licenseType;
        this.operatingSystemNames = builder.operatingSystemNames;
        this.owner = builder.owner;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationIds() {
        return this.applicationIds != null && !(this.applicationIds instanceof SdkAutoConstructList);
    }

    public final List<String> applicationIds() {
        return this.applicationIds;
    }

    public final List<Compute> computeTypeNames() {
        return ComputeListCopier.copyStringToEnum(this.computeTypeNames);
    }

    public final boolean hasComputeTypeNames() {
        return this.computeTypeNames != null && !(this.computeTypeNames instanceof SdkAutoConstructList);
    }

    public final List<String> computeTypeNamesAsStrings() {
        return this.computeTypeNames;
    }

    public final WorkSpaceApplicationLicenseType licenseType() {
        return WorkSpaceApplicationLicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final List<OperatingSystemName> operatingSystemNames() {
        return OperatingSystemNameListCopier.copyStringToEnum(this.operatingSystemNames);
    }

    public final boolean hasOperatingSystemNames() {
        return this.operatingSystemNames != null && !(this.operatingSystemNames instanceof SdkAutoConstructList);
    }

    public final List<String> operatingSystemNamesAsStrings() {
        return this.operatingSystemNames;
    }

    public final String owner() {
        return this.owner;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationIds() ? this.applicationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeTypeNames() ? this.computeTypeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingSystemNames() ? this.operatingSystemNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest)((Object)obj);
        return this.hasApplicationIds() == other.hasApplicationIds() && Objects.equals(this.applicationIds(), other.applicationIds()) && this.hasComputeTypeNames() == other.hasComputeTypeNames() && Objects.equals(this.computeTypeNamesAsStrings(), other.computeTypeNamesAsStrings()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && this.hasOperatingSystemNames() == other.hasOperatingSystemNames() && Objects.equals(this.operatingSystemNamesAsStrings(), other.operatingSystemNamesAsStrings()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationsRequest").add("ApplicationIds", this.hasApplicationIds() ? this.applicationIds() : null).add("ComputeTypeNames", this.hasComputeTypeNames() ? this.computeTypeNamesAsStrings() : null).add("LicenseType", (Object)this.licenseTypeAsString()).add("OperatingSystemNames", this.hasOperatingSystemNames() ? this.operatingSystemNamesAsStrings() : null).add("Owner", (Object)this.owner()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationIds": {
                return Optional.ofNullable(clazz.cast(this.applicationIds()));
            }
            case "ComputeTypeNames": {
                return Optional.ofNullable(clazz.cast(this.computeTypeNamesAsStrings()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "OperatingSystemNames": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemNamesAsStrings()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsRequest, T> g) {
        return obj -> g.apply((DescribeApplicationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> applicationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> computeTypeNames = DefaultSdkAutoConstructList.getInstance();
        private String licenseType;
        private List<String> operatingSystemNames = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsRequest model) {
            super(model);
            this.applicationIds(model.applicationIds);
            this.computeTypeNamesWithStrings(model.computeTypeNames);
            this.licenseType(model.licenseType);
            this.operatingSystemNamesWithStrings(model.operatingSystemNames);
            this.owner(model.owner);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getApplicationIds() {
            if (this.applicationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationIds;
        }

        public final void setApplicationIds(Collection<String> applicationIds) {
            this.applicationIds = WorkSpaceApplicationIdListCopier.copy(applicationIds);
        }

        @Override
        public final Builder applicationIds(Collection<String> applicationIds) {
            this.applicationIds = WorkSpaceApplicationIdListCopier.copy(applicationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIds(String ... applicationIds) {
            this.applicationIds(Arrays.asList(applicationIds));
            return this;
        }

        public final Collection<String> getComputeTypeNames() {
            if (this.computeTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.computeTypeNames;
        }

        public final void setComputeTypeNames(Collection<String> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copy(computeTypeNames);
        }

        @Override
        public final Builder computeTypeNamesWithStrings(Collection<String> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copy(computeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypeNamesWithStrings(String ... computeTypeNames) {
            this.computeTypeNamesWithStrings(Arrays.asList(computeTypeNames));
            return this;
        }

        @Override
        public final Builder computeTypeNames(Collection<Compute> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copyEnumToString(computeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypeNames(Compute ... computeTypeNames) {
            this.computeTypeNames(Arrays.asList(computeTypeNames));
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(WorkSpaceApplicationLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final Collection<String> getOperatingSystemNames() {
            if (this.operatingSystemNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingSystemNames;
        }

        public final void setOperatingSystemNames(Collection<String> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copy(operatingSystemNames);
        }

        @Override
        public final Builder operatingSystemNamesWithStrings(Collection<String> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copy(operatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystemNamesWithStrings(String ... operatingSystemNames) {
            this.operatingSystemNamesWithStrings(Arrays.asList(operatingSystemNames));
            return this;
        }

        @Override
        public final Builder operatingSystemNames(Collection<OperatingSystemName> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copyEnumToString(operatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystemNames(OperatingSystemName ... operatingSystemNames) {
            this.operatingSystemNames(Arrays.asList(operatingSystemNames));
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationsRequest build() {
            return new DescribeApplicationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationsRequest> {
        public Builder applicationIds(Collection<String> var1);

        public Builder applicationIds(String ... var1);

        public Builder computeTypeNamesWithStrings(Collection<String> var1);

        public Builder computeTypeNamesWithStrings(String ... var1);

        public Builder computeTypeNames(Collection<Compute> var1);

        public Builder computeTypeNames(Compute ... var1);

        public Builder licenseType(String var1);

        public Builder licenseType(WorkSpaceApplicationLicenseType var1);

        public Builder operatingSystemNamesWithStrings(Collection<String> var1);

        public Builder operatingSystemNamesWithStrings(String ... var1);

        public Builder operatingSystemNames(Collection<OperatingSystemName> var1);

        public Builder operatingSystemNames(OperatingSystemName ... var1);

        public Builder owner(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

