/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Compute;
import software.amazon.awssdk.services.workspaces.model.GlobalAcceleratorForWorkSpace;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemName;
import software.amazon.awssdk.services.workspaces.model.Protocol;
import software.amazon.awssdk.services.workspaces.model.ProtocolListCopier;
import software.amazon.awssdk.services.workspaces.model.RunningMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceProperties> {
    private static final SdkField<String> RUNNING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunningMode").getter(WorkspaceProperties.getter(WorkspaceProperties::runningModeAsString)).setter(WorkspaceProperties.setter(Builder::runningMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningMode").build()}).build();
    private static final SdkField<Integer> RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningModeAutoStopTimeoutInMinutes").getter(WorkspaceProperties.getter(WorkspaceProperties::runningModeAutoStopTimeoutInMinutes)).setter(WorkspaceProperties.setter(Builder::runningModeAutoStopTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningModeAutoStopTimeoutInMinutes").build()}).build();
    private static final SdkField<Integer> ROOT_VOLUME_SIZE_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RootVolumeSizeGib").getter(WorkspaceProperties.getter(WorkspaceProperties::rootVolumeSizeGib)).setter(WorkspaceProperties.setter(Builder::rootVolumeSizeGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSizeGib").build()}).build();
    private static final SdkField<Integer> USER_VOLUME_SIZE_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserVolumeSizeGib").getter(WorkspaceProperties.getter(WorkspaceProperties::userVolumeSizeGib)).setter(WorkspaceProperties.setter(Builder::userVolumeSizeGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeSizeGib").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeTypeName").getter(WorkspaceProperties.getter(WorkspaceProperties::computeTypeNameAsString)).setter(WorkspaceProperties.setter(Builder::computeTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTypeName").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(WorkspaceProperties.getter(WorkspaceProperties::protocolsAsStrings)).setter(WorkspaceProperties.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemName").getter(WorkspaceProperties.getter(WorkspaceProperties::operatingSystemNameAsString)).setter(WorkspaceProperties.setter(Builder::operatingSystemName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build()}).build();
    private static final SdkField<GlobalAcceleratorForWorkSpace> GLOBAL_ACCELERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalAccelerator").getter(WorkspaceProperties.getter(WorkspaceProperties::globalAccelerator)).setter(WorkspaceProperties.setter(Builder::globalAccelerator)).constructor(GlobalAcceleratorForWorkSpace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalAccelerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNNING_MODE_FIELD, RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD, ROOT_VOLUME_SIZE_GIB_FIELD, USER_VOLUME_SIZE_GIB_FIELD, COMPUTE_TYPE_NAME_FIELD, PROTOCOLS_FIELD, OPERATING_SYSTEM_NAME_FIELD, GLOBAL_ACCELERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String runningMode;
    private final Integer runningModeAutoStopTimeoutInMinutes;
    private final Integer rootVolumeSizeGib;
    private final Integer userVolumeSizeGib;
    private final String computeTypeName;
    private final List<String> protocols;
    private final String operatingSystemName;
    private final GlobalAcceleratorForWorkSpace globalAccelerator;

    private WorkspaceProperties(BuilderImpl builder) {
        this.runningMode = builder.runningMode;
        this.runningModeAutoStopTimeoutInMinutes = builder.runningModeAutoStopTimeoutInMinutes;
        this.rootVolumeSizeGib = builder.rootVolumeSizeGib;
        this.userVolumeSizeGib = builder.userVolumeSizeGib;
        this.computeTypeName = builder.computeTypeName;
        this.protocols = builder.protocols;
        this.operatingSystemName = builder.operatingSystemName;
        this.globalAccelerator = builder.globalAccelerator;
    }

    public final RunningMode runningMode() {
        return RunningMode.fromValue(this.runningMode);
    }

    public final String runningModeAsString() {
        return this.runningMode;
    }

    public final Integer runningModeAutoStopTimeoutInMinutes() {
        return this.runningModeAutoStopTimeoutInMinutes;
    }

    public final Integer rootVolumeSizeGib() {
        return this.rootVolumeSizeGib;
    }

    public final Integer userVolumeSizeGib() {
        return this.userVolumeSizeGib;
    }

    public final Compute computeTypeName() {
        return Compute.fromValue(this.computeTypeName);
    }

    public final String computeTypeNameAsString() {
        return this.computeTypeName;
    }

    public final List<Protocol> protocols() {
        return ProtocolListCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final OperatingSystemName operatingSystemName() {
        return OperatingSystemName.fromValue(this.operatingSystemName);
    }

    public final String operatingSystemNameAsString() {
        return this.operatingSystemName;
    }

    public final GlobalAcceleratorForWorkSpace globalAccelerator() {
        return this.globalAccelerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningModeAutoStopTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVolumeSizeGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalAccelerator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceProperties)) {
            return false;
        }
        WorkspaceProperties other = (WorkspaceProperties)obj;
        return Objects.equals(this.runningModeAsString(), other.runningModeAsString()) && Objects.equals(this.runningModeAutoStopTimeoutInMinutes(), other.runningModeAutoStopTimeoutInMinutes()) && Objects.equals(this.rootVolumeSizeGib(), other.rootVolumeSizeGib()) && Objects.equals(this.userVolumeSizeGib(), other.userVolumeSizeGib()) && Objects.equals(this.computeTypeNameAsString(), other.computeTypeNameAsString()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.operatingSystemNameAsString(), other.operatingSystemNameAsString()) && Objects.equals(this.globalAccelerator(), other.globalAccelerator());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceProperties").add("RunningMode", (Object)this.runningModeAsString()).add("RunningModeAutoStopTimeoutInMinutes", (Object)this.runningModeAutoStopTimeoutInMinutes()).add("RootVolumeSizeGib", (Object)this.rootVolumeSizeGib()).add("UserVolumeSizeGib", (Object)this.userVolumeSizeGib()).add("ComputeTypeName", (Object)this.computeTypeNameAsString()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("OperatingSystemName", (Object)this.operatingSystemNameAsString()).add("GlobalAccelerator", (Object)this.globalAccelerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunningMode": {
                return Optional.ofNullable(clazz.cast(this.runningModeAsString()));
            }
            case "RunningModeAutoStopTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.runningModeAutoStopTimeoutInMinutes()));
            }
            case "RootVolumeSizeGib": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeSizeGib()));
            }
            case "UserVolumeSizeGib": {
                return Optional.ofNullable(clazz.cast(this.userVolumeSizeGib()));
            }
            case "ComputeTypeName": {
                return Optional.ofNullable(clazz.cast(this.computeTypeNameAsString()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "OperatingSystemName": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemNameAsString()));
            }
            case "GlobalAccelerator": {
                return Optional.ofNullable(clazz.cast(this.globalAccelerator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RunningMode", RUNNING_MODE_FIELD);
        map.put("RunningModeAutoStopTimeoutInMinutes", RUNNING_MODE_AUTO_STOP_TIMEOUT_IN_MINUTES_FIELD);
        map.put("RootVolumeSizeGib", ROOT_VOLUME_SIZE_GIB_FIELD);
        map.put("UserVolumeSizeGib", USER_VOLUME_SIZE_GIB_FIELD);
        map.put("ComputeTypeName", COMPUTE_TYPE_NAME_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        map.put("OperatingSystemName", OPERATING_SYSTEM_NAME_FIELD);
        map.put("GlobalAccelerator", GLOBAL_ACCELERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceProperties, T> g) {
        return obj -> g.apply((WorkspaceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runningMode;
        private Integer runningModeAutoStopTimeoutInMinutes;
        private Integer rootVolumeSizeGib;
        private Integer userVolumeSizeGib;
        private String computeTypeName;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String operatingSystemName;
        private GlobalAcceleratorForWorkSpace globalAccelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceProperties model) {
            this.runningMode(model.runningMode);
            this.runningModeAutoStopTimeoutInMinutes(model.runningModeAutoStopTimeoutInMinutes);
            this.rootVolumeSizeGib(model.rootVolumeSizeGib);
            this.userVolumeSizeGib(model.userVolumeSizeGib);
            this.computeTypeName(model.computeTypeName);
            this.protocolsWithStrings(model.protocols);
            this.operatingSystemName(model.operatingSystemName);
            this.globalAccelerator(model.globalAccelerator);
        }

        public final String getRunningMode() {
            return this.runningMode;
        }

        public final void setRunningMode(String runningMode) {
            this.runningMode = runningMode;
        }

        @Override
        public final Builder runningMode(String runningMode) {
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public final Builder runningMode(RunningMode runningMode) {
            this.runningMode(runningMode == null ? null : runningMode.toString());
            return this;
        }

        public final Integer getRunningModeAutoStopTimeoutInMinutes() {
            return this.runningModeAutoStopTimeoutInMinutes;
        }

        public final void setRunningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
        }

        @Override
        public final Builder runningModeAutoStopTimeoutInMinutes(Integer runningModeAutoStopTimeoutInMinutes) {
            this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
            return this;
        }

        public final Integer getRootVolumeSizeGib() {
            return this.rootVolumeSizeGib;
        }

        public final void setRootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
        }

        @Override
        public final Builder rootVolumeSizeGib(Integer rootVolumeSizeGib) {
            this.rootVolumeSizeGib = rootVolumeSizeGib;
            return this;
        }

        public final Integer getUserVolumeSizeGib() {
            return this.userVolumeSizeGib;
        }

        public final void setUserVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
        }

        @Override
        public final Builder userVolumeSizeGib(Integer userVolumeSizeGib) {
            this.userVolumeSizeGib = userVolumeSizeGib;
            return this;
        }

        public final String getComputeTypeName() {
            return this.computeTypeName;
        }

        public final void setComputeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
        }

        @Override
        public final Builder computeTypeName(String computeTypeName) {
            this.computeTypeName = computeTypeName;
            return this;
        }

        @Override
        public final Builder computeTypeName(Compute computeTypeName) {
            this.computeTypeName(computeTypeName == null ? null : computeTypeName.toString());
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        @Override
        public final Builder operatingSystemName(OperatingSystemName operatingSystemName) {
            this.operatingSystemName(operatingSystemName == null ? null : operatingSystemName.toString());
            return this;
        }

        public final GlobalAcceleratorForWorkSpace.Builder getGlobalAccelerator() {
            return this.globalAccelerator != null ? this.globalAccelerator.toBuilder() : null;
        }

        public final void setGlobalAccelerator(GlobalAcceleratorForWorkSpace.BuilderImpl globalAccelerator) {
            this.globalAccelerator = globalAccelerator != null ? globalAccelerator.build() : null;
        }

        @Override
        public final Builder globalAccelerator(GlobalAcceleratorForWorkSpace globalAccelerator) {
            this.globalAccelerator = globalAccelerator;
            return this;
        }

        public WorkspaceProperties build() {
            return new WorkspaceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceProperties> {
        public Builder runningMode(String var1);

        public Builder runningMode(RunningMode var1);

        public Builder runningModeAutoStopTimeoutInMinutes(Integer var1);

        public Builder rootVolumeSizeGib(Integer var1);

        public Builder userVolumeSizeGib(Integer var1);

        public Builder computeTypeName(String var1);

        public Builder computeTypeName(Compute var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemName(OperatingSystemName var1);

        public Builder globalAccelerator(GlobalAcceleratorForWorkSpace var1);

        default public Builder globalAccelerator(Consumer<GlobalAcceleratorForWorkSpace.Builder> globalAccelerator) {
            return this.globalAccelerator((GlobalAcceleratorForWorkSpace)((GlobalAcceleratorForWorkSpace.Builder)GlobalAcceleratorForWorkSpace.builder().applyMutation(globalAccelerator)).build());
        }
    }
}

