/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesConnectionStatusRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspacesConnectionStatusRequest> {
    private static final SdkField<List<String>> WORKSPACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceIds").getter(DescribeWorkspacesConnectionStatusRequest.getter(DescribeWorkspacesConnectionStatusRequest::workspaceIds)).setter(DescribeWorkspacesConnectionStatusRequest.setter(Builder::workspaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesConnectionStatusRequest.getter(DescribeWorkspacesConnectionStatusRequest::nextToken)).setter(DescribeWorkspacesConnectionStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspacesConnectionStatusRequest.memberNameToFieldInitializer();
    private final List<String> workspaceIds;
    private final String nextToken;

    private DescribeWorkspacesConnectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceIds = builder.workspaceIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkspaceIds() {
        return this.workspaceIds != null && !(this.workspaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceIds() {
        return this.workspaceIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceIds() ? this.workspaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesConnectionStatusRequest)) {
            return false;
        }
        DescribeWorkspacesConnectionStatusRequest other = (DescribeWorkspacesConnectionStatusRequest)((Object)obj);
        return this.hasWorkspaceIds() == other.hasWorkspaceIds() && Objects.equals(this.workspaceIds(), other.workspaceIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesConnectionStatusRequest").add("WorkspaceIds", this.hasWorkspaceIds() ? this.workspaceIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceIds": {
                return Optional.ofNullable(clazz.cast(this.workspaceIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceIds", WORKSPACE_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesConnectionStatusRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesConnectionStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> workspaceIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesConnectionStatusRequest model) {
            super(model);
            this.workspaceIds(model.workspaceIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getWorkspaceIds() {
            if (this.workspaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceIds;
        }

        public final void setWorkspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
        }

        @Override
        public final Builder workspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceIds(String ... workspaceIds) {
            this.workspaceIds(Arrays.asList(workspaceIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesConnectionStatusRequest build() {
            return new DescribeWorkspacesConnectionStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesConnectionStatusRequest> {
        public Builder workspaceIds(Collection<String> var1);

        public Builder workspaceIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

