/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation;
import software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociationListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationAssociationsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeApplicationAssociationsResponse> {
    private static final SdkField<List<ApplicationResourceAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(DescribeApplicationAssociationsResponse.getter(DescribeApplicationAssociationsResponse::associations)).setter(DescribeApplicationAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationResourceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeApplicationAssociationsResponse.getter(DescribeApplicationAssociationsResponse::nextToken)).setter(DescribeApplicationAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeApplicationAssociationsResponse.memberNameToFieldInitializer();
    private final List<ApplicationResourceAssociation> associations;
    private final String nextToken;

    private DescribeApplicationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<ApplicationResourceAssociation> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationAssociationsResponse)) {
            return false;
        }
        DescribeApplicationAssociationsResponse other = (DescribeApplicationAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Associations", ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<ApplicationResourceAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationResourceAssociation.Builder> getAssociations() {
            List<ApplicationResourceAssociation.Builder> result = ApplicationResourceAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<ApplicationResourceAssociation.BuilderImpl> associations) {
            this.associations = ApplicationResourceAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<ApplicationResourceAssociation> associations) {
            this.associations = ApplicationResourceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(ApplicationResourceAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<ApplicationResourceAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (ApplicationResourceAssociation)((ApplicationResourceAssociation.Builder)ApplicationResourceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeApplicationAssociationsResponse build() {
            return new DescribeApplicationAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationAssociationsResponse> {
        public Builder associations(Collection<ApplicationResourceAssociation> var1);

        public Builder associations(ApplicationResourceAssociation ... var1);

        public Builder associations(Consumer<ApplicationResourceAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

