/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspaceImageErrorDetailCode {
    OUTDATED_POWERSHELL_VERSION("OutdatedPowershellVersion"),
    OFFICE_INSTALLED("OfficeInstalled"),
    P_CO_IP_AGENT_INSTALLED("PCoIPAgentInstalled"),
    WINDOWS_UPDATES_ENABLED("WindowsUpdatesEnabled"),
    AUTO_MOUNT_DISABLED("AutoMountDisabled"),
    WORKSPACES_BYOL_ACCOUNT_NOT_FOUND("WorkspacesBYOLAccountNotFound"),
    WORKSPACES_BYOL_ACCOUNT_DISABLED("WorkspacesBYOLAccountDisabled"),
    DHCP_DISABLED("DHCPDisabled"),
    DISK_FREE_SPACE("DiskFreeSpace"),
    ADDITIONAL_DRIVES_ATTACHED("AdditionalDrivesAttached"),
    OS_NOT_SUPPORTED("OSNotSupported"),
    DOMAIN_JOINED("DomainJoined"),
    AZURE_DOMAIN_JOINED("AzureDomainJoined"),
    FIREWALL_ENABLED("FirewallEnabled"),
    VM_WARE_TOOLS_INSTALLED("VMWareToolsInstalled"),
    DISK_SIZE_EXCEEDED("DiskSizeExceeded"),
    INCOMPATIBLE_PARTITIONING("IncompatiblePartitioning"),
    PENDING_REBOOT("PendingReboot"),
    AUTO_LOGON_ENABLED("AutoLogonEnabled"),
    REAL_TIME_UNIVERSAL_DISABLED("RealTimeUniversalDisabled"),
    MULTIPLE_BOOT_PARTITION("MultipleBootPartition"),
    REQUIRES64_BIT_OS("Requires64BitOS"),
    ZERO_REARM_COUNT("ZeroRearmCount"),
    IN_PLACE_UPGRADE("InPlaceUpgrade"),
    ANTI_VIRUS_INSTALLED("AntiVirusInstalled"),
    UEFI_NOT_SUPPORTED("UEFINotSupported"),
    UNKNOWN_ERROR("UnknownError"),
    APP_X_PACKAGES_INSTALLED("AppXPackagesInstalled"),
    RESERVED_STORAGE_IN_USE("ReservedStorageInUse"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceImageErrorDetailCode> VALUE_MAP;
    private final String value;

    private WorkspaceImageErrorDetailCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceImageErrorDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceImageErrorDetailCode> knownValues() {
        EnumSet<WorkspaceImageErrorDetailCode> knownValues = EnumSet.allOf(WorkspaceImageErrorDetailCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspaceImageErrorDetailCode.class, WorkspaceImageErrorDetailCode::toString);
    }
}

