/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceImageResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<CreateWorkspaceImageResponse.Builder, CreateWorkspaceImageResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(CreateWorkspaceImageResponse::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateWorkspaceImageResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkspaceImageResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<OperatingSystem> OPERATING_SYSTEM_FIELD = SdkField
            .<OperatingSystem> builder(MarshallingType.SDK_POJO).memberName("OperatingSystem")
            .getter(getter(CreateWorkspaceImageResponse::operatingSystem)).setter(setter(Builder::operatingSystem))
            .constructor(OperatingSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateWorkspaceImageResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> REQUIRED_TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequiredTenancy").getter(getter(CreateWorkspaceImageResponse::requiredTenancyAsString))
            .setter(setter(Builder::requiredTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredTenancy").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(CreateWorkspaceImageResponse::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(CreateWorkspaceImageResponse::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, OPERATING_SYSTEM_FIELD, STATE_FIELD, REQUIRED_TENANCY_FIELD,
                    CREATED_FIELD, OWNER_ACCOUNT_ID_FIELD));

    private final String imageId;

    private final String name;

    private final String description;

    private final OperatingSystem operatingSystem;

    private final String state;

    private final String requiredTenancy;

    private final Instant created;

    private final String ownerAccountId;

    private CreateWorkspaceImageResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.description = builder.description;
        this.operatingSystem = builder.operatingSystem;
        this.state = builder.state;
        this.requiredTenancy = builder.requiredTenancy;
        this.created = builder.created;
        this.ownerAccountId = builder.ownerAccountId;
    }

    /**
     * <p>
     * The identifier of the new WorkSpace image.
     * </p>
     * 
     * @return The identifier of the new WorkSpace image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the image.
     * </p>
     * 
     * @return The name of the image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the image.
     * </p>
     * 
     * @return The description of the image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The operating system that the image is running.
     * </p>
     * 
     * @return The operating system that the image is running.
     */
    public final OperatingSystem operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * The availability status of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The availability status of the image.
     * @see WorkspaceImageState
     */
    public final WorkspaceImageState state() {
        return WorkspaceImageState.fromValue(state);
    }

    /**
     * <p>
     * The availability status of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The availability status of the image.
     * @see WorkspaceImageState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this
     * value is set to DEDICATED. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own Windows
     * Desktop Images.</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requiredTenancy}
     * will return {@link WorkspaceImageRequiredTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #requiredTenancyAsString}.
     * </p>
     * 
     * @return Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is
     *         enabled, this value is set to DEDICATED. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own
     *         Windows Desktop Images.</a>.
     * @see WorkspaceImageRequiredTenancy
     */
    public final WorkspaceImageRequiredTenancy requiredTenancy() {
        return WorkspaceImageRequiredTenancy.fromValue(requiredTenancy);
    }

    /**
     * <p>
     * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this
     * value is set to DEDICATED. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own Windows
     * Desktop Images.</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requiredTenancy}
     * will return {@link WorkspaceImageRequiredTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #requiredTenancyAsString}.
     * </p>
     * 
     * @return Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is
     *         enabled, this value is set to DEDICATED. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own
     *         Windows Desktop Images.</a>.
     * @see WorkspaceImageRequiredTenancy
     */
    public final String requiredTenancyAsString() {
        return requiredTenancy;
    }

    /**
     * <p>
     * The date when the image was created.
     * </p>
     * 
     * @return The date when the image was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that owns the image.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that owns the image.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requiredTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceImageResponse)) {
            return false;
        }
        CreateWorkspaceImageResponse other = (CreateWorkspaceImageResponse) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(operatingSystem(), other.operatingSystem())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(requiredTenancyAsString(), other.requiredTenancyAsString())
                && Objects.equals(created(), other.created()) && Objects.equals(ownerAccountId(), other.ownerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceImageResponse").add("ImageId", imageId()).add("Name", name())
                .add("Description", description()).add("OperatingSystem", operatingSystem()).add("State", stateAsString())
                .add("RequiredTenancy", requiredTenancyAsString()).add("Created", created())
                .add("OwnerAccountId", ownerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "RequiredTenancy":
            return Optional.ofNullable(clazz.cast(requiredTenancyAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceImageResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspaceImageResponse> {
        /**
         * <p>
         * The identifier of the new WorkSpace image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the new WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the image.
         * </p>
         * 
         * @param name
         *        The name of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the image.
         * </p>
         * 
         * @param description
         *        The description of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The operating system that the image is running.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system that the image is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * The operating system that the image is running.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatingSystem.Builder} avoiding the
         * need to create one manually via {@link OperatingSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatingSystem.Builder#build()} is called immediately and its
         * result is passed to {@link #operatingSystem(OperatingSystem)}.
         * 
         * @param operatingSystem
         *        a consumer that will call methods on {@link OperatingSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingSystem(OperatingSystem)
         */
        default Builder operatingSystem(Consumer<OperatingSystem.Builder> operatingSystem) {
            return operatingSystem(OperatingSystem.builder().applyMutation(operatingSystem).build());
        }

        /**
         * <p>
         * The availability status of the image.
         * </p>
         * 
         * @param state
         *        The availability status of the image.
         * @see WorkspaceImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The availability status of the image.
         * </p>
         * 
         * @param state
         *        The availability status of the image.
         * @see WorkspaceImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageState
         */
        Builder state(WorkspaceImageState state);

        /**
         * <p>
         * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled,
         * this value is set to DEDICATED. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own
         * Windows Desktop Images.</a>.
         * </p>
         * 
         * @param requiredTenancy
         *        Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is
         *        enabled, this value is set to DEDICATED. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your
         *        Own Windows Desktop Images.</a>.
         * @see WorkspaceImageRequiredTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageRequiredTenancy
         */
        Builder requiredTenancy(String requiredTenancy);

        /**
         * <p>
         * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled,
         * this value is set to DEDICATED. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own
         * Windows Desktop Images.</a>.
         * </p>
         * 
         * @param requiredTenancy
         *        Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is
         *        enabled, this value is set to DEDICATED. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your
         *        Own Windows Desktop Images.</a>.
         * @see WorkspaceImageRequiredTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceImageRequiredTenancy
         */
        Builder requiredTenancy(WorkspaceImageRequiredTenancy requiredTenancy);

        /**
         * <p>
         * The date when the image was created.
         * </p>
         * 
         * @param created
         *        The date when the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The identifier of the Amazon Web Services account that owns the image.
         * </p>
         * 
         * @param ownerAccountId
         *        The identifier of the Amazon Web Services account that owns the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String imageId;

        private String name;

        private String description;

        private OperatingSystem operatingSystem;

        private String state;

        private String requiredTenancy;

        private Instant created;

        private String ownerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceImageResponse model) {
            super(model);
            imageId(model.imageId);
            name(model.name);
            description(model.description);
            operatingSystem(model.operatingSystem);
            state(model.state);
            requiredTenancy(model.requiredTenancy);
            created(model.created);
            ownerAccountId(model.ownerAccountId);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final OperatingSystem.Builder getOperatingSystem() {
            return operatingSystem != null ? operatingSystem.toBuilder() : null;
        }

        public final void setOperatingSystem(OperatingSystem.BuilderImpl operatingSystem) {
            this.operatingSystem = operatingSystem != null ? operatingSystem.build() : null;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRequiredTenancy() {
            return requiredTenancy;
        }

        public final void setRequiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
        }

        @Override
        public final Builder requiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
            return this;
        }

        @Override
        public final Builder requiredTenancy(WorkspaceImageRequiredTenancy requiredTenancy) {
            this.requiredTenancy(requiredTenancy == null ? null : requiredTenancy.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        @Override
        public CreateWorkspaceImageResponse build() {
            return new CreateWorkspaceImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
