/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a modification to the configuration of Bring Your Own License (BYOL) for the specified account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountModification implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountModification.Builder, AccountModification> {
    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationState").getter(getter(AccountModification::modificationStateAsString))
            .setter(setter(Builder::modificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState").build()).build();

    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancySupport").getter(getter(AccountModification::dedicatedTenancySupportAsString))
            .setter(setter(Builder::dedicatedTenancySupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build())
            .build();

    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancyManagementCidrRange")
            .getter(getter(AccountModification::dedicatedTenancyManagementCidrRange))
            .setter(setter(Builder::dedicatedTenancyManagementCidrRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DedicatedTenancyManagementCidrRange").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AccountModification::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(AccountModification::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(AccountModification::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODIFICATION_STATE_FIELD,
            DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD, START_TIME_FIELD, ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modificationState;

    private final String dedicatedTenancySupport;

    private final String dedicatedTenancyManagementCidrRange;

    private final Instant startTime;

    private final String errorCode;

    private final String errorMessage;

    private AccountModification(BuilderImpl builder) {
        this.modificationState = builder.modificationState;
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
        this.startTime = builder.startTime;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The state of the modification to the configuration of BYOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link DedicatedTenancyModificationStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The state of the modification to the configuration of BYOL.
     * @see DedicatedTenancyModificationStateEnum
     */
    public final DedicatedTenancyModificationStateEnum modificationState() {
        return DedicatedTenancyModificationStateEnum.fromValue(modificationState);
    }

    /**
     * <p>
     * The state of the modification to the configuration of BYOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link DedicatedTenancyModificationStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The state of the modification to the configuration of BYOL.
     * @see DedicatedTenancyModificationStateEnum
     */
    public final String modificationStateAsString() {
        return modificationState;
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is being enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is being enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final DedicatedTenancySupportResultEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportResultEnum.fromValue(dedicatedTenancySupport);
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is being enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is being enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final String dedicatedTenancySupportAsString() {
        return dedicatedTenancySupport;
    }

    /**
     * <p>
     * The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the account.
     * </p>
     * 
     * @return The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the
     *         account.
     */
    public final String dedicatedTenancyManagementCidrRange() {
        return dedicatedTenancyManagementCidrRange;
    }

    /**
     * <p>
     * The timestamp when the modification of the BYOL configuration was started.
     * </p>
     * 
     * @return The timestamp when the modification of the BYOL configuration was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The error code that is returned if the configuration of BYOL cannot be modified.
     * </p>
     * 
     * @return The error code that is returned if the configuration of BYOL cannot be modified.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The text of the error message that is returned if the configuration of BYOL cannot be modified.
     * </p>
     * 
     * @return The text of the error message that is returned if the configuration of BYOL cannot be modified.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancyManagementCidrRange());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountModification)) {
            return false;
        }
        AccountModification other = (AccountModification) obj;
        return Objects.equals(modificationStateAsString(), other.modificationStateAsString())
                && Objects.equals(dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString())
                && Objects.equals(dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountModification").add("ModificationState", modificationStateAsString())
                .add("DedicatedTenancySupport", dedicatedTenancySupportAsString())
                .add("DedicatedTenancyManagementCidrRange", dedicatedTenancyManagementCidrRange()).add("StartTime", startTime())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModificationState":
            return Optional.ofNullable(clazz.cast(modificationStateAsString()));
        case "DedicatedTenancySupport":
            return Optional.ofNullable(clazz.cast(dedicatedTenancySupportAsString()));
        case "DedicatedTenancyManagementCidrRange":
            return Optional.ofNullable(clazz.cast(dedicatedTenancyManagementCidrRange()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountModification, T> g) {
        return obj -> g.apply((AccountModification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountModification> {
        /**
         * <p>
         * The state of the modification to the configuration of BYOL.
         * </p>
         * 
         * @param modificationState
         *        The state of the modification to the configuration of BYOL.
         * @see DedicatedTenancyModificationStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancyModificationStateEnum
         */
        Builder modificationState(String modificationState);

        /**
         * <p>
         * The state of the modification to the configuration of BYOL.
         * </p>
         * 
         * @param modificationState
         *        The state of the modification to the configuration of BYOL.
         * @see DedicatedTenancyModificationStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancyModificationStateEnum
         */
        Builder modificationState(DedicatedTenancyModificationStateEnum modificationState);

        /**
         * <p>
         * The status of BYOL (whether BYOL is being enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is being enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(String dedicatedTenancySupport);

        /**
         * <p>
         * The status of BYOL (whether BYOL is being enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is being enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport);

        /**
         * <p>
         * The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the
         * account.
         * </p>
         * 
         * @param dedicatedTenancyManagementCidrRange
         *        The IP address range, specified as an IPv4 CIDR block, for the management network interface used for
         *        the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange);

        /**
         * <p>
         * The timestamp when the modification of the BYOL configuration was started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the modification of the BYOL configuration was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The error code that is returned if the configuration of BYOL cannot be modified.
         * </p>
         * 
         * @param errorCode
         *        The error code that is returned if the configuration of BYOL cannot be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The text of the error message that is returned if the configuration of BYOL cannot be modified.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message that is returned if the configuration of BYOL cannot be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String modificationState;

        private String dedicatedTenancySupport;

        private String dedicatedTenancyManagementCidrRange;

        private Instant startTime;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountModification model) {
            modificationState(model.modificationState);
            dedicatedTenancySupport(model.dedicatedTenancySupport);
            dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
            startTime(model.startTime);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getModificationState() {
            return modificationState;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(DedicatedTenancyModificationStateEnum modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final String getDedicatedTenancySupport() {
            return dedicatedTenancySupport;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return dedicatedTenancyManagementCidrRange;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public AccountModification build() {
            return new AccountModification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
