/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.WorkSpacesServiceClientConfiguration;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionResponse;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.transform.AssociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AssociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AuthorizeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CopyWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateStandbyWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateUpdatedWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeregisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountModificationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectClientAddInsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceBundlesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAvailableManagementCidrRangesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.MigrateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyCertificateBasedAuthPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySamlPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySelfservicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceAccessPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceCreationPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspacePropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceStateRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebootWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebuildWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RegisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RestoreWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RevokeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectionAliasPermissionRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateRulesOfIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceImagePermissionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWorkSpacesClient
implements WorkSpacesClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkSpacesClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final WorkSpacesServiceClientConfiguration serviceClientConfiguration;

    protected DefaultWorkSpacesClient(WorkSpacesServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateConnectionAliasResponse associateConnectionAlias(AssociateConnectionAliasRequest associateConnectionAliasRequest) throws ResourceAssociatedException, AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateConnectionAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, associateConnectionAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateConnectionAlias");
            AssociateConnectionAliasResponse associateConnectionAliasResponse = (AssociateConnectionAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateConnectionAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateConnectionAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateConnectionAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateConnectionAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$associateConnectionAlias$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, associateIpGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateIpGroups");
            AssociateIpGroupsResponse associateIpGroupsResponse = (AssociateIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateIpGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateIpGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$associateIpGroups$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AuthorizeIpRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, authorizeIpRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeIpRules");
            AuthorizeIpRulesResponse authorizeIpRulesResponse = (AuthorizeIpRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeIpRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeIpRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AuthorizeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return authorizeIpRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$authorizeIpRules$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, copyWorkspaceImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyWorkspaceImage");
            CopyWorkspaceImageResponse copyWorkspaceImageResponse = (CopyWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyWorkspaceImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copyWorkspaceImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$copyWorkspaceImage$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectClientAddInResponse createConnectClientAddIn(CreateConnectClientAddInRequest createConnectClientAddInRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceCreationFailedException, ResourceAlreadyExistsException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectClientAddInResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createConnectClientAddInRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnectClientAddIn");
            CreateConnectClientAddInResponse createConnectClientAddInResponse = (CreateConnectClientAddInResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnectClientAddIn").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConnectClientAddInRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectClientAddInRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectClientAddInResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createConnectClientAddIn$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionAliasResponse createConnectionAlias(CreateConnectionAliasRequest createConnectionAliasRequest) throws ResourceAlreadyExistsException, AccessDeniedException, InvalidParameterValuesException, ResourceLimitExceededException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createConnectionAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnectionAlias");
            CreateConnectionAliasResponse createConnectionAliasResponse = (CreateConnectionAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnectionAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConnectionAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectionAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectionAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createConnectionAlias$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest) throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createIpGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIpGroup");
            CreateIpGroupResponse createIpGroupResponse = (CreateIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIpGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createIpGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStandbyWorkspacesResponse createStandbyWorkspaces(CreateStandbyWorkspacesRequest createStandbyWorkspacesRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStandbyWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createStandbyWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStandbyWorkspaces");
            CreateStandbyWorkspacesResponse createStandbyWorkspacesResponse = (CreateStandbyWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStandbyWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStandbyWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStandbyWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStandbyWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createStandbyWorkspaces$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException, InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createTags$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImage(CreateUpdatedWorkspaceImageRequest createUpdatedWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUpdatedWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createUpdatedWorkspaceImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUpdatedWorkspaceImage");
            CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImageResponse = (CreateUpdatedWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUpdatedWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUpdatedWorkspaceImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUpdatedWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUpdatedWorkspaceImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createUpdatedWorkspaceImage$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkspaceBundleResponse createWorkspaceBundle(CreateWorkspaceBundleRequest createWorkspaceBundleRequest) throws ResourceUnavailableException, ResourceAlreadyExistsException, ResourceLimitExceededException, InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspaceBundleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createWorkspaceBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkspaceBundle");
            CreateWorkspaceBundleResponse createWorkspaceBundleResponse = (CreateWorkspaceBundleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkspaceBundle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkspaceBundleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkspaceBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkspaceBundleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createWorkspaceBundle$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkspaceImageResponse createWorkspaceImage(CreateWorkspaceImageRequest createWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createWorkspaceImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkspaceImage");
            CreateWorkspaceImageResponse createWorkspaceImageResponse = (CreateWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkspaceImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkspaceImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createWorkspaceImage$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, createWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkspaces");
            CreateWorkspacesResponse createWorkspacesResponse = (CreateWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$createWorkspaces$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClientBrandingResponse deleteClientBranding(DeleteClientBrandingRequest deleteClientBrandingRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClientBrandingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteClientBrandingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClientBranding");
            DeleteClientBrandingResponse deleteClientBrandingResponse = (DeleteClientBrandingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClientBranding").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClientBrandingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClientBrandingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClientBrandingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteClientBranding$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectClientAddInResponse deleteConnectClientAddIn(DeleteConnectClientAddInRequest deleteConnectClientAddInRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectClientAddInResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectClientAddInRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnectClientAddIn");
            DeleteConnectClientAddInResponse deleteConnectClientAddInResponse = (DeleteConnectClientAddInResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnectClientAddIn").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectClientAddInRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectClientAddInRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectClientAddInResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteConnectClientAddIn$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionAliasResponse deleteConnectionAlias(DeleteConnectionAliasRequest deleteConnectionAliasRequest) throws ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectionAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnectionAlias");
            DeleteConnectionAliasResponse deleteConnectionAliasResponse = (DeleteConnectionAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnectionAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectionAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteConnectionAlias$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteIpGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIpGroup");
            DeleteIpGroupResponse deleteIpGroupResponse = (DeleteIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIpGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteIpGroup$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteTags$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkspaceBundleResponse deleteWorkspaceBundle(DeleteWorkspaceBundleRequest deleteWorkspaceBundleRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkspaceBundleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkspaceBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkspaceBundle");
            DeleteWorkspaceBundleResponse deleteWorkspaceBundleResponse = (DeleteWorkspaceBundleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkspaceBundle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkspaceBundleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkspaceBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkspaceBundleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteWorkspaceBundle$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest) throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkspaceImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkspaceImage");
            DeleteWorkspaceImageResponse deleteWorkspaceImageResponse = (DeleteWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkspaceImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkspaceImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deleteWorkspaceImage$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWorkspaceDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, deregisterWorkspaceDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterWorkspaceDirectory");
            DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectoryResponse = (DeregisterWorkspaceDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWorkspaceDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterWorkspaceDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterWorkspaceDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterWorkspaceDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$deregisterWorkspaceDirectory$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccount");
            DescribeAccountResponse describeAccountResponse = (DescribeAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeAccount$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountModificationsResponse describeAccountModifications(DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountModificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeAccountModificationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountModifications");
            DescribeAccountModificationsResponse describeAccountModificationsResponse = (DescribeAccountModificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountModifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountModificationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountModificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountModificationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeAccountModifications$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClientBrandingResponse describeClientBranding(DescribeClientBrandingRequest describeClientBrandingRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientBrandingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeClientBrandingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClientBranding");
            DescribeClientBrandingResponse describeClientBrandingResponse = (DescribeClientBrandingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientBranding").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClientBrandingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClientBrandingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClientBrandingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeClientBranding$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClientPropertiesResponse describeClientProperties(DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeClientPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClientProperties");
            DescribeClientPropertiesResponse describeClientPropertiesResponse = (DescribeClientPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClientPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClientPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeClientProperties$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectClientAddInsResponse describeConnectClientAddIns(DescribeConnectClientAddInsRequest describeConnectClientAddInsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectClientAddInsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeConnectClientAddInsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectClientAddIns");
            DescribeConnectClientAddInsResponse describeConnectClientAddInsResponse = (DescribeConnectClientAddInsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectClientAddIns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectClientAddInsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectClientAddInsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectClientAddInsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeConnectClientAddIns$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissions(DescribeConnectionAliasPermissionsRequest describeConnectionAliasPermissionsRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionAliasPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeConnectionAliasPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectionAliasPermissions");
            DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissionsResponse = (DescribeConnectionAliasPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectionAliasPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionAliasPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionAliasPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionAliasPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeConnectionAliasPermissions$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionAliasesResponse describeConnectionAliases(DescribeConnectionAliasesRequest describeConnectionAliasesRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeConnectionAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectionAliases");
            DescribeConnectionAliasesResponse describeConnectionAliasesResponse = (DescribeConnectionAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectionAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeConnectionAliases$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest) throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeIpGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIpGroups");
            DescribeIpGroupsResponse describeIpGroupsResponse = (DescribeIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIpGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIpGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeIpGroups$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeTags$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceBundlesResponse describeWorkspaceBundles(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceBundlesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspaceBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaceBundles");
            DescribeWorkspaceBundlesResponse describeWorkspaceBundlesResponse = (DescribeWorkspaceBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceBundles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceBundlesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspaceBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspaceBundlesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaceBundles$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceDirectoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspaceDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaceDirectories");
            DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectoriesResponse = (DescribeWorkspaceDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceDirectories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceDirectoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspaceDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspaceDirectoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaceDirectories$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissions(DescribeWorkspaceImagePermissionsRequest describeWorkspaceImagePermissionsRequest) throws ResourceNotFoundException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceImagePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspaceImagePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaceImagePermissions");
            DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissionsResponse = (DescribeWorkspaceImagePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceImagePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceImagePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspaceImagePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspaceImagePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaceImagePermissions$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceImagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspaceImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaceImages");
            DescribeWorkspaceImagesResponse describeWorkspaceImagesResponse = (DescribeWorkspaceImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceImages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspaceImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspaceImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaceImages$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspaceSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaceSnapshots");
            DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshotsResponse = (DescribeWorkspaceSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspaceSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspaceSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaceSnapshots$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspaces");
            DescribeWorkspacesResponse describeWorkspacesResponse = (DescribeWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspaces$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesConnectionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, describeWorkspacesConnectionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkspacesConnectionStatus");
            DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatusResponse = (DescribeWorkspacesConnectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspacesConnectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesConnectionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkspacesConnectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkspacesConnectionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$describeWorkspacesConnectionStatus$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateConnectionAliasResponse disassociateConnectionAlias(DisassociateConnectionAliasRequest disassociateConnectionAliasRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConnectionAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, disassociateConnectionAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConnectionAlias");
            DisassociateConnectionAliasResponse disassociateConnectionAliasResponse = (DisassociateConnectionAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConnectionAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateConnectionAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateConnectionAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateConnectionAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$disassociateConnectionAlias$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, disassociateIpGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateIpGroups");
            DisassociateIpGroupsResponse disassociateIpGroupsResponse = (DisassociateIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateIpGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateIpGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$disassociateIpGroups$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportClientBrandingResponse importClientBranding(ImportClientBrandingRequest importClientBrandingRequest) throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportClientBrandingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, importClientBrandingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportClientBranding");
            ImportClientBrandingResponse importClientBrandingResponse = (ImportClientBrandingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportClientBranding").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importClientBrandingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportClientBrandingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importClientBrandingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$importClientBranding$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, importWorkspaceImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportWorkspaceImage");
            ImportWorkspaceImageResponse importWorkspaceImageResponse = (ImportWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importWorkspaceImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importWorkspaceImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$importWorkspaceImage$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest) throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableManagementCidrRangesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, listAvailableManagementCidrRangesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAvailableManagementCidrRanges");
            ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRangesResponse = (ListAvailableManagementCidrRangesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableManagementCidrRanges").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableManagementCidrRangesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAvailableManagementCidrRangesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAvailableManagementCidrRangesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$listAvailableManagementCidrRanges$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MigrateWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, migrateWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MigrateWorkspace");
            MigrateWorkspaceResponse migrateWorkspaceResponse = (MigrateWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MigrateWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)migrateWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MigrateWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return migrateWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$migrateWorkspace$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest) throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException, ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyAccount");
            ModifyAccountResponse modifyAccountResponse = (ModifyAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyAccount$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthProperties(ModifyCertificateBasedAuthPropertiesRequest modifyCertificateBasedAuthPropertiesRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyCertificateBasedAuthPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyCertificateBasedAuthPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCertificateBasedAuthProperties");
            ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthPropertiesResponse = (ModifyCertificateBasedAuthPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCertificateBasedAuthProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCertificateBasedAuthPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyCertificateBasedAuthPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyCertificateBasedAuthPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyCertificateBasedAuthProperties$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyClientPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyClientPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClientProperties");
            ModifyClientPropertiesResponse modifyClientPropertiesResponse = (ModifyClientPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClientProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClientPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyClientPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyClientProperties$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifySamlPropertiesResponse modifySamlProperties(ModifySamlPropertiesRequest modifySamlPropertiesRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifySamlPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifySamlPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySamlProperties");
            ModifySamlPropertiesResponse modifySamlPropertiesResponse = (ModifySamlPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySamlProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifySamlPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifySamlPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifySamlPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifySamlProperties$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifySelfservicePermissionsResponse modifySelfservicePermissions(ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifySelfservicePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifySelfservicePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySelfservicePermissions");
            ModifySelfservicePermissionsResponse modifySelfservicePermissionsResponse = (ModifySelfservicePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySelfservicePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifySelfservicePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifySelfservicePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifySelfservicePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifySelfservicePermissions$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceAccessPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyWorkspaceAccessPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyWorkspaceAccessProperties");
            ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessPropertiesResponse = (ModifyWorkspaceAccessPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceAccessProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceAccessPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyWorkspaceAccessPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyWorkspaceAccessPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyWorkspaceAccessProperties$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceCreationPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyWorkspaceCreationPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyWorkspaceCreationProperties");
            ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationPropertiesResponse = (ModifyWorkspaceCreationPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceCreationProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceCreationPropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyWorkspaceCreationPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyWorkspaceCreationPropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyWorkspaceCreationProperties$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException, InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException, ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspacePropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyWorkspacePropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyWorkspaceProperties");
            ModifyWorkspacePropertiesResponse modifyWorkspacePropertiesResponse = (ModifyWorkspacePropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspacePropertiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyWorkspacePropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyWorkspacePropertiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyWorkspaceProperties$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest) throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, modifyWorkspaceStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyWorkspaceState");
            ModifyWorkspaceStateResponse modifyWorkspaceStateResponse = (ModifyWorkspaceStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyWorkspaceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyWorkspaceStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$modifyWorkspaceState$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, rebootWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootWorkspaces");
            RebootWorkspacesResponse rebootWorkspacesResponse = (RebootWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$rebootWorkspaces$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebuildWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, rebuildWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebuildWorkspaces");
            RebuildWorkspacesResponse rebuildWorkspacesResponse = (RebuildWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebuildWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebuildWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebuildWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebuildWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$rebuildWorkspaces$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException, WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWorkspaceDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, registerWorkspaceDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterWorkspaceDirectory");
            RegisterWorkspaceDirectoryResponse registerWorkspaceDirectoryResponse = (RegisterWorkspaceDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWorkspaceDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerWorkspaceDirectoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterWorkspaceDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerWorkspaceDirectoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$registerWorkspaceDirectory$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, restoreWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreWorkspace");
            RestoreWorkspaceResponse restoreWorkspaceResponse = (RestoreWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$restoreWorkspace$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeIpRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, revokeIpRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeIpRules");
            RevokeIpRulesResponse revokeIpRulesResponse = (RevokeIpRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeIpRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeIpRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeIpRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$revokeIpRules$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, startWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartWorkspaces");
            StartWorkspacesResponse startWorkspacesResponse = (StartWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$startWorkspaces$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, stopWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopWorkspaces");
            StopWorkspacesResponse stopWorkspacesResponse = (StopWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$stopWorkspaces$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, terminateWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateWorkspaces");
            TerminateWorkspacesResponse terminateWorkspacesResponse = (TerminateWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$terminateWorkspaces$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectClientAddInResponse updateConnectClientAddIn(UpdateConnectClientAddInRequest updateConnectClientAddInRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectClientAddInResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, updateConnectClientAddInRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectClientAddIn");
            UpdateConnectClientAddInResponse updateConnectClientAddInResponse = (UpdateConnectClientAddInResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectClientAddIn").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConnectClientAddInRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectClientAddInRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectClientAddInResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$updateConnectClientAddIn$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectionAliasPermissionResponse updateConnectionAliasPermission(UpdateConnectionAliasPermissionRequest updateConnectionAliasPermissionRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException, ResourceAssociatedException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectionAliasPermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, updateConnectionAliasPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnectionAliasPermission");
            UpdateConnectionAliasPermissionResponse updateConnectionAliasPermissionResponse = (UpdateConnectionAliasPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnectionAliasPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConnectionAliasPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectionAliasPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectionAliasPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$updateConnectionAliasPermission$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRulesOfIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, updateRulesOfIpGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRulesOfIpGroup");
            UpdateRulesOfIpGroupResponse updateRulesOfIpGroupResponse = (UpdateRulesOfIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRulesOfIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRulesOfIpGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRulesOfIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRulesOfIpGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$updateRulesOfIpGroup$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkspaceBundleResponse updateWorkspaceBundle(UpdateWorkspaceBundleRequest updateWorkspaceBundleRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, ResourceUnavailableException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkspaceBundleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, updateWorkspaceBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkspaceBundle");
            UpdateWorkspaceBundleResponse updateWorkspaceBundleResponse = (UpdateWorkspaceBundleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkspaceBundle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkspaceBundleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkspaceBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkspaceBundleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$updateWorkspaceBundle$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermission(UpdateWorkspaceImagePermissionRequest updateWorkspaceImagePermissionRequest) throws ResourceNotFoundException, ResourceUnavailableException, AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkspaceImagePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWorkSpacesClient.resolveMetricPublishers(this.clientConfiguration, updateWorkspaceImagePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkspaceImagePermission");
            UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermissionResponse = (UpdateWorkspaceImagePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkspaceImagePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkspaceImagePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkspaceImagePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkspaceImagePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkSpacesClient.lambda$updateWorkspaceImagePermission$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "workspaces";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkSpacesException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").exceptionBuilderSupplier(OperationNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").exceptionBuilderSupplier(ResourceAssociatedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").exceptionBuilderSupplier(InvalidParameterValuesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressException").exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").exceptionBuilderSupplier(ResourceCreationFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException").exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException").exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException").exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final WorkSpacesServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWorkspaceImagePermission$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkspaceBundle$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRulesOfIpGroup$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectionAliasPermission$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnectClientAddIn$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateWorkspaces$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopWorkspaces$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startWorkspaces$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeIpRules$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreWorkspace$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerWorkspaceDirectory$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebuildWorkspaces$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootWorkspaces$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyWorkspaceState$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyWorkspaceProperties$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyWorkspaceCreationProperties$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyWorkspaceAccessProperties$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifySelfservicePermissions$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifySamlProperties$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyClientProperties$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyCertificateBasedAuthProperties$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyAccount$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$migrateWorkspace$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAvailableManagementCidrRanges$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importWorkspaceImage$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importClientBranding$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateIpGroups$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConnectionAlias$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspacesConnectionStatus$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaces$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaceSnapshots$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaceImages$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaceImagePermissions$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaceDirectories$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkspaceBundles$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIpGroups$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectionAliases$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectionAliasPermissions$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectClientAddIns$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClientProperties$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClientBranding$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountModifications$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccount$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterWorkspaceDirectory$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkspaceImage$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkspaceBundle$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIpGroup$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnectionAlias$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnectClientAddIn$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClientBranding$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkspaces$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkspaceImage$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkspaceBundle$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUpdatedWorkspaceImage$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStandbyWorkspaces$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIpGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnectionAlias$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnectClientAddIn$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyWorkspaceImage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$authorizeIpRules$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateIpGroups$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateConnectionAlias$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

