/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeAccountResponse.Builder, DescribeAccountResponse> {
    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancySupport").getter(getter(DescribeAccountResponse::dedicatedTenancySupportAsString))
            .setter(setter(Builder::dedicatedTenancySupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build())
            .build();

    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DedicatedTenancyManagementCidrRange")
            .getter(getter(DescribeAccountResponse::dedicatedTenancyManagementCidrRange))
            .setter(setter(Builder::dedicatedTenancyManagementCidrRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DedicatedTenancyManagementCidrRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD));

    private final String dedicatedTenancySupport;

    private final String dedicatedTenancyManagementCidrRange;

    private DescribeAccountResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final DedicatedTenancySupportResultEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportResultEnum.fromValue(dedicatedTenancySupport);
    }

    /**
     * <p>
     * The status of BYOL (whether BYOL is enabled or disabled).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedTenancySupport} will return {@link DedicatedTenancySupportResultEnum#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dedicatedTenancySupportAsString}.
     * </p>
     * 
     * @return The status of BYOL (whether BYOL is enabled or disabled).
     * @see DedicatedTenancySupportResultEnum
     */
    public final String dedicatedTenancySupportAsString() {
        return dedicatedTenancySupport;
    }

    /**
     * <p>
     * The IP address range, specified as an IPv4 CIDR block, used for the management network interface.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     * 
     * @return The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p>
     *         <p>
     *         The management network interface is connected to a secure Amazon WorkSpaces management network. It is
     *         used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon
     *         WorkSpaces to manage the WorkSpace.
     */
    public final String dedicatedTenancyManagementCidrRange() {
        return dedicatedTenancyManagementCidrRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedTenancyManagementCidrRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountResponse)) {
            return false;
        }
        DescribeAccountResponse other = (DescribeAccountResponse) obj;
        return Objects.equals(dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString())
                && Objects.equals(dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountResponse").add("DedicatedTenancySupport", dedicatedTenancySupportAsString())
                .add("DedicatedTenancyManagementCidrRange", dedicatedTenancyManagementCidrRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DedicatedTenancySupport":
            return Optional.ofNullable(clazz.cast(dedicatedTenancySupportAsString()));
        case "DedicatedTenancyManagementCidrRange":
            return Optional.ofNullable(clazz.cast(dedicatedTenancyManagementCidrRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountResponse, T> g) {
        return obj -> g.apply((DescribeAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountResponse> {
        /**
         * <p>
         * The status of BYOL (whether BYOL is enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(String dedicatedTenancySupport);

        /**
         * <p>
         * The status of BYOL (whether BYOL is enabled or disabled).
         * </p>
         * 
         * @param dedicatedTenancySupport
         *        The status of BYOL (whether BYOL is enabled or disabled).
         * @see DedicatedTenancySupportResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DedicatedTenancySupportResultEnum
         */
        Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport);

        /**
         * <p>
         * The IP address range, specified as an IPv4 CIDR block, used for the management network interface.
         * </p>
         * <p>
         * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used
         * for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon
         * WorkSpaces to manage the WorkSpace.
         * </p>
         * 
         * @param dedicatedTenancyManagementCidrRange
         *        The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p>
         *        <p>
         *        The management network interface is connected to a secure Amazon WorkSpaces management network. It is
         *        used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow
         *        Amazon WorkSpaces to manage the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String dedicatedTenancySupport;

        private String dedicatedTenancyManagementCidrRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountResponse model) {
            super(model);
            dedicatedTenancySupport(model.dedicatedTenancySupport);
            dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
        }

        public final String getDedicatedTenancySupport() {
            return dedicatedTenancySupport;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return dedicatedTenancyManagementCidrRange;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        @Override
        public DescribeAccountResponse build() {
            return new DescribeAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
