/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.SubnetIdsCopier;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.Tenancy;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterWorkspaceDirectoryRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::directoryId)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::subnetIds)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_WORK_DOCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableWorkDocs").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::enableWorkDocs)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::enableWorkDocs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWorkDocs").build()}).build();
    private static final SdkField<Boolean> ENABLE_SELF_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableSelfService").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::enableSelfService)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::enableSelfService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSelfService").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::tenancyAsString)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::tags)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SUBNET_IDS_FIELD, ENABLE_WORK_DOCS_FIELD, ENABLE_SELF_SERVICE_FIELD, TENANCY_FIELD, TAGS_FIELD));
    private final String directoryId;
    private final List<String> subnetIds;
    private final Boolean enableWorkDocs;
    private final Boolean enableSelfService;
    private final String tenancy;
    private final List<Tag> tags;

    private RegisterWorkspaceDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.subnetIds = builder.subnetIds;
        this.enableWorkDocs = builder.enableWorkDocs;
        this.enableSelfService = builder.enableSelfService;
        this.tenancy = builder.tenancy;
        this.tags = builder.tags;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Boolean enableWorkDocs() {
        return this.enableWorkDocs;
    }

    public final Boolean enableSelfService() {
        return this.enableSelfService;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableWorkDocs());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSelfService());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkspaceDirectoryRequest)) {
            return false;
        }
        RegisterWorkspaceDirectoryRequest other = (RegisterWorkspaceDirectoryRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.enableWorkDocs(), other.enableWorkDocs()) && Objects.equals(this.enableSelfService(), other.enableSelfService()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterWorkspaceDirectoryRequest").add("DirectoryId", (Object)this.directoryId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("EnableWorkDocs", (Object)this.enableWorkDocs()).add("EnableSelfService", (Object)this.enableSelfService()).add("Tenancy", (Object)this.tenancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "EnableWorkDocs": {
                return Optional.ofNullable(clazz.cast(this.enableWorkDocs()));
            }
            case "EnableSelfService": {
                return Optional.ofNullable(clazz.cast(this.enableSelfService()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkspaceDirectoryRequest, T> g) {
        return obj -> g.apply((RegisterWorkspaceDirectoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableWorkDocs;
        private Boolean enableSelfService;
        private String tenancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkspaceDirectoryRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.subnetIds(model.subnetIds);
            this.enableWorkDocs(model.enableWorkDocs);
            this.enableSelfService(model.enableSelfService);
            this.tenancy(model.tenancy);
            this.tags(model.tags);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Boolean getEnableWorkDocs() {
            return this.enableWorkDocs;
        }

        @Override
        public final Builder enableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
            return this;
        }

        public final void setEnableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
        }

        public final Boolean getEnableSelfService() {
            return this.enableSelfService;
        }

        @Override
        public final Builder enableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
            return this;
        }

        public final void setEnableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkspaceDirectoryRequest build() {
            return new RegisterWorkspaceDirectoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
        public Builder directoryId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder enableWorkDocs(Boolean var1);

        public Builder enableSelfService(Boolean var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

