/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrateWorkspaceResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, MigrateWorkspaceResponse> {
    private static final SdkField<String> SOURCE_WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceWorkspaceId").getter(MigrateWorkspaceResponse.getter(MigrateWorkspaceResponse::sourceWorkspaceId)).setter(MigrateWorkspaceResponse.setter(Builder::sourceWorkspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceWorkspaceId").build()}).build();
    private static final SdkField<String> TARGET_WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetWorkspaceId").getter(MigrateWorkspaceResponse.getter(MigrateWorkspaceResponse::targetWorkspaceId)).setter(MigrateWorkspaceResponse.setter(Builder::targetWorkspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetWorkspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_WORKSPACE_ID_FIELD, TARGET_WORKSPACE_ID_FIELD));
    private final String sourceWorkspaceId;
    private final String targetWorkspaceId;

    private MigrateWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.sourceWorkspaceId = builder.sourceWorkspaceId;
        this.targetWorkspaceId = builder.targetWorkspaceId;
    }

    public final String sourceWorkspaceId() {
        return this.sourceWorkspaceId;
    }

    public final String targetWorkspaceId() {
        return this.targetWorkspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetWorkspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrateWorkspaceResponse)) {
            return false;
        }
        MigrateWorkspaceResponse other = (MigrateWorkspaceResponse)((Object)obj);
        return Objects.equals(this.sourceWorkspaceId(), other.sourceWorkspaceId()) && Objects.equals(this.targetWorkspaceId(), other.targetWorkspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"MigrateWorkspaceResponse").add("SourceWorkspaceId", (Object)this.sourceWorkspaceId()).add("TargetWorkspaceId", (Object)this.targetWorkspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceWorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.sourceWorkspaceId()));
            }
            case "TargetWorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.targetWorkspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrateWorkspaceResponse, T> g) {
        return obj -> g.apply((MigrateWorkspaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String sourceWorkspaceId;
        private String targetWorkspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrateWorkspaceResponse model) {
            super(model);
            this.sourceWorkspaceId(model.sourceWorkspaceId);
            this.targetWorkspaceId(model.targetWorkspaceId);
        }

        public final String getSourceWorkspaceId() {
            return this.sourceWorkspaceId;
        }

        @Override
        public final Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            return this;
        }

        public final void setSourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
        }

        public final String getTargetWorkspaceId() {
            return this.targetWorkspaceId;
        }

        @Override
        public final Builder targetWorkspaceId(String targetWorkspaceId) {
            this.targetWorkspaceId = targetWorkspaceId;
            return this;
        }

        public final void setTargetWorkspaceId(String targetWorkspaceId) {
            this.targetWorkspaceId = targetWorkspaceId;
        }

        @Override
        public MigrateWorkspaceResponse build() {
            return new MigrateWorkspaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MigrateWorkspaceResponse> {
        public Builder sourceWorkspaceId(String var1);

        public Builder targetWorkspaceId(String var1);
    }
}

