/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionAliasPermissionRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<UpdateConnectionAliasPermissionRequest.Builder, UpdateConnectionAliasPermissionRequest> {
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(UpdateConnectionAliasPermissionRequest::aliasId))
            .setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<ConnectionAliasPermission> CONNECTION_ALIAS_PERMISSION_FIELD = SdkField
            .<ConnectionAliasPermission> builder(MarshallingType.SDK_POJO).memberName("ConnectionAliasPermission")
            .getter(getter(UpdateConnectionAliasPermissionRequest::connectionAliasPermission))
            .setter(setter(Builder::connectionAliasPermission)).constructor(ConnectionAliasPermission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAliasPermission").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ID_FIELD,
            CONNECTION_ALIAS_PERMISSION_FIELD));

    private final String aliasId;

    private final ConnectionAliasPermission connectionAliasPermission;

    private UpdateConnectionAliasPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.aliasId = builder.aliasId;
        this.connectionAliasPermission = builder.connectionAliasPermission;
    }

    /**
     * <p>
     * The identifier of the connection alias that you want to update permissions for.
     * </p>
     * 
     * @return The identifier of the connection alias that you want to update permissions for.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * Indicates whether to share or unshare the connection alias with the specified AWS account.
     * </p>
     * 
     * @return Indicates whether to share or unshare the connection alias with the specified AWS account.
     */
    public final ConnectionAliasPermission connectionAliasPermission() {
        return connectionAliasPermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAliasPermission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionAliasPermissionRequest)) {
            return false;
        }
        UpdateConnectionAliasPermissionRequest other = (UpdateConnectionAliasPermissionRequest) obj;
        return Objects.equals(aliasId(), other.aliasId())
                && Objects.equals(connectionAliasPermission(), other.connectionAliasPermission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionAliasPermissionRequest").add("AliasId", aliasId())
                .add("ConnectionAliasPermission", connectionAliasPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "ConnectionAliasPermission":
            return Optional.ofNullable(clazz.cast(connectionAliasPermission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionAliasPermissionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionAliasPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectionAliasPermissionRequest> {
        /**
         * <p>
         * The identifier of the connection alias that you want to update permissions for.
         * </p>
         * 
         * @param aliasId
         *        The identifier of the connection alias that you want to update permissions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * Indicates whether to share or unshare the connection alias with the specified AWS account.
         * </p>
         * 
         * @param connectionAliasPermission
         *        Indicates whether to share or unshare the connection alias with the specified AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAliasPermission(ConnectionAliasPermission connectionAliasPermission);

        /**
         * <p>
         * Indicates whether to share or unshare the connection alias with the specified AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionAliasPermission.Builder} avoiding the
         * need to create one manually via {@link ConnectionAliasPermission#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionAliasPermission.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionAliasPermission(ConnectionAliasPermission)}.
         * 
         * @param connectionAliasPermission
         *        a consumer that will call methods on {@link ConnectionAliasPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionAliasPermission(ConnectionAliasPermission)
         */
        default Builder connectionAliasPermission(Consumer<ConnectionAliasPermission.Builder> connectionAliasPermission) {
            return connectionAliasPermission(ConnectionAliasPermission.builder().applyMutation(connectionAliasPermission).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String aliasId;

        private ConnectionAliasPermission connectionAliasPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionAliasPermissionRequest model) {
            super(model);
            aliasId(model.aliasId);
            connectionAliasPermission(model.connectionAliasPermission);
        }

        public final String getAliasId() {
            return aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final ConnectionAliasPermission.Builder getConnectionAliasPermission() {
            return connectionAliasPermission != null ? connectionAliasPermission.toBuilder() : null;
        }

        @Override
        public final Builder connectionAliasPermission(ConnectionAliasPermission connectionAliasPermission) {
            this.connectionAliasPermission = connectionAliasPermission;
            return this;
        }

        public final void setConnectionAliasPermission(ConnectionAliasPermission.BuilderImpl connectionAliasPermission) {
            this.connectionAliasPermission = connectionAliasPermission != null ? connectionAliasPermission.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionAliasPermissionRequest build() {
            return new UpdateConnectionAliasPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
