/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceImagesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspaceImagesRequest.Builder, DescribeWorkspaceImagesRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImageIds")
            .getter(getter(DescribeWorkspaceImagesRequest::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageType").getter(getter(DescribeWorkspaceImagesRequest::imageTypeAsString))
            .setter(setter(Builder::imageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspaceImagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeWorkspaceImagesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD,
            IMAGE_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> imageIds;

    private final String imageType;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeWorkspaceImagesRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.imageType = builder.imageType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the ImageIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImageIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier of the image.
     */
    public final List<String> imageIds() {
        return imageIds;
    }

    /**
     * <p>
     * The type (owned or shared) of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type (owned or shared) of the image.
     * @see ImageType
     */
    public final ImageType imageType() {
        return ImageType.fromValue(imageType);
    }

    /**
     * <p>
     * The type (owned or shared) of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type (owned or shared) of the image.
     * @see ImageType
     */
    public final String imageTypeAsString() {
        return imageType;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return.
     * </p>
     * 
     * @return The maximum number of items to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagesRequest)) {
            return false;
        }
        DescribeWorkspaceImagesRequest other = (DescribeWorkspaceImagesRequest) obj;
        return hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && Objects.equals(imageTypeAsString(), other.imageTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceImagesRequest").add("ImageIds", hasImageIds() ? imageIds() : null)
                .add("ImageType", imageTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "ImageType":
            return Optional.ofNullable(clazz.cast(imageTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkspaceImagesRequest> {
        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageIds
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<String> imageIds);

        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageIds
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(String... imageIds);

        /**
         * <p>
         * The type (owned or shared) of the image.
         * </p>
         * 
         * @param imageType
         *        The type (owned or shared) of the image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder imageType(String imageType);

        /**
         * <p>
         * The type (owned or shared) of the image.
         * </p>
         * 
         * @param imageType
         *        The type (owned or shared) of the image.
         * @see ImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageType
         */
        Builder imageType(ImageType imageType);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();

        private String imageType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagesRequest model) {
            super(model);
            imageIds(model.imageIds);
            imageType(model.imageType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            if (imageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return imageIds;
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = WorkspaceImageIdListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = WorkspaceImageIdListCopier.copy(imageIds);
        }

        public final String getImageType() {
            return imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageType imageType) {
            this.imageType(imageType == null ? null : imageType.toString());
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceImagesRequest build() {
            return new DescribeWorkspaceImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
