/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountModificationsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeAccountModificationsResponse.Builder, DescribeAccountModificationsResponse> {
    private static final SdkField<List<AccountModification>> ACCOUNT_MODIFICATIONS_FIELD = SdkField
            .<List<AccountModification>> builder(MarshallingType.LIST)
            .memberName("AccountModifications")
            .getter(getter(DescribeAccountModificationsResponse::accountModifications))
            .setter(setter(Builder::accountModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountModification> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountModification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAccountModificationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_MODIFICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccountModification> accountModifications;

    private final String nextToken;

    private DescribeAccountModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.accountModifications = builder.accountModifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccountModifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAccountModifications() {
        return accountModifications != null && !(accountModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of modifications to the configuration of BYOL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountModifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of modifications to the configuration of BYOL.
     */
    public final List<AccountModification> accountModifications() {
        return accountModifications;
    }

    /**
     * <p>
     * The token to use to retrieve the next set of results, or null if no more results are available.
     * </p>
     * 
     * @return The token to use to retrieve the next set of results, or null if no more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountModifications() ? accountModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountModificationsResponse)) {
            return false;
        }
        DescribeAccountModificationsResponse other = (DescribeAccountModificationsResponse) obj;
        return hasAccountModifications() == other.hasAccountModifications()
                && Objects.equals(accountModifications(), other.accountModifications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountModificationsResponse")
                .add("AccountModifications", hasAccountModifications() ? accountModifications() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountModifications":
            return Optional.ofNullable(clazz.cast(accountModifications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountModificationsResponse, T> g) {
        return obj -> g.apply((DescribeAccountModificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountModificationsResponse> {
        /**
         * <p>
         * The list of modifications to the configuration of BYOL.
         * </p>
         * 
         * @param accountModifications
         *        The list of modifications to the configuration of BYOL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountModifications(Collection<AccountModification> accountModifications);

        /**
         * <p>
         * The list of modifications to the configuration of BYOL.
         * </p>
         * 
         * @param accountModifications
         *        The list of modifications to the configuration of BYOL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountModifications(AccountModification... accountModifications);

        /**
         * <p>
         * The list of modifications to the configuration of BYOL.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountModification>.Builder} avoiding the
         * need to create one manually via {@link List<AccountModification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountModification>.Builder#build()} is called immediately
         * and its result is passed to {@link #accountModifications(List<AccountModification>)}.
         * 
         * @param accountModifications
         *        a consumer that will call methods on {@link List<AccountModification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountModifications(List<AccountModification>)
         */
        Builder accountModifications(Consumer<AccountModification.Builder>... accountModifications);

        /**
         * <p>
         * The token to use to retrieve the next set of results, or null if no more results are available.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next set of results, or null if no more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<AccountModification> accountModifications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountModificationsResponse model) {
            super(model);
            accountModifications(model.accountModifications);
            nextToken(model.nextToken);
        }

        public final Collection<AccountModification.Builder> getAccountModifications() {
            if (accountModifications instanceof SdkAutoConstructList) {
                return null;
            }
            return accountModifications != null ? accountModifications.stream().map(AccountModification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountModifications(Collection<AccountModification> accountModifications) {
            this.accountModifications = AccountModificationListCopier.copy(accountModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountModifications(AccountModification... accountModifications) {
            accountModifications(Arrays.asList(accountModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountModifications(Consumer<AccountModification.Builder>... accountModifications) {
            accountModifications(Stream.of(accountModifications).map(c -> AccountModification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountModifications(Collection<AccountModification.BuilderImpl> accountModifications) {
            this.accountModifications = AccountModificationListCopier.copyFromBuilder(accountModifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccountModificationsResponse build() {
            return new DescribeAccountModificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
