/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup;
import software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpGroupsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeIpGroupsResponse> {
    private static final SdkField<List<WorkspacesIpGroup>> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeIpGroupsResponse.getter(DescribeIpGroupsResponse::result)).setter(DescribeIpGroupsResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspacesIpGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeIpGroupsResponse.getter(DescribeIpGroupsResponse::nextToken)).setter(DescribeIpGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkspacesIpGroup> result;
    private final String nextToken;

    private DescribeIpGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResult() {
        return this.result != null && !(this.result instanceof SdkAutoConstructList);
    }

    public List<WorkspacesIpGroup> result() {
        return this.result;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpGroupsResponse)) {
            return false;
        }
        DescribeIpGroupsResponse other = (DescribeIpGroupsResponse)((Object)obj);
        return Objects.equals(this.result(), other.result()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIpGroupsResponse").add("Result", this.result()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpGroupsResponse, T> g) {
        return obj -> g.apply((DescribeIpGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspacesIpGroup> result = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpGroupsResponse model) {
            super(model);
            this.result(model.result);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorkspacesIpGroup.Builder> getResult() {
            return this.result != null ? (Collection)this.result.stream().map(WorkspacesIpGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder result(Collection<WorkspacesIpGroup> result) {
            this.result = WorkspacesIpGroupsListCopier.copy(result);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder result(WorkspacesIpGroup ... result) {
            this.result(Arrays.asList(result));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder result(Consumer<WorkspacesIpGroup.Builder> ... result) {
            this.result(Stream.of(result).map(c -> (WorkspacesIpGroup)((WorkspacesIpGroup.Builder)WorkspacesIpGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResult(Collection<WorkspacesIpGroup.BuilderImpl> result) {
            this.result = WorkspacesIpGroupsListCopier.copyFromBuilder(result);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIpGroupsResponse build() {
            return new DescribeIpGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpGroupsResponse> {
        public Builder result(Collection<WorkspacesIpGroup> var1);

        public Builder result(WorkspacesIpGroup ... var1);

        public Builder result(Consumer<WorkspacesIpGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

