/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable;
import software.amazon.awssdk.services.workspaces.transform.AssociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AuthorizeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CopyWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeregisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountModificationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceBundlesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAvailableManagementCidrRangesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.MigrateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySelfservicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceAccessPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceCreationPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspacePropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceStateRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebootWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebuildWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RegisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RestoreWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RevokeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateRulesOfIpGroupRequestMarshaller;

@SdkInternalApi
final class DefaultWorkSpacesClient
implements WorkSpacesClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "workspaces";
    }

    @Override
    public AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateIpGroupsRequest).withMarshaller((Marshaller)new AssociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AuthorizeIpRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AuthorizeIpRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeIpRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeIpRulesRequest).withMarshaller((Marshaller)new AuthorizeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CopyWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyWorkspaceImageRequest).withMarshaller((Marshaller)new CopyWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest) throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceCreationFailedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpGroupRequest).withMarshaller((Marshaller)new CreateIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException, InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkspacesRequest).withMarshaller((Marshaller)new CreateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpGroupRequest).withMarshaller((Marshaller)new DeleteIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest) throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkspaceImageRequest).withMarshaller((Marshaller)new DeleteWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWorkspaceDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeregisterWorkspaceDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWorkspaceDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterWorkspaceDirectoryRequest).withMarshaller((Marshaller)new DeregisterWorkspaceDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest).withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAccountModificationsResponse describeAccountModifications(DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountModificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAccountModificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountModifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountModificationsRequest).withMarshaller((Marshaller)new DescribeAccountModificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeClientPropertiesResponse describeClientProperties(DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeClientPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClientProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClientPropertiesRequest).withMarshaller((Marshaller)new DescribeClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest) throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIpGroupsRequest).withMarshaller((Marshaller)new DescribeIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspaceBundlesResponse describeWorkspaceBundles(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceBundlesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspaceBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceBundles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceBundlesRequest).withMarshaller((Marshaller)new DescribeWorkspaceBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceBundlesIterable(this, this.applyPaginatorUserAgent(describeWorkspaceBundlesRequest));
    }

    @Override
    public DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceDirectoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspaceDirectoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceDirectories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceDirectoriesRequest).withMarshaller((Marshaller)new DescribeWorkspaceDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceDirectoriesIterable(this, this.applyPaginatorUserAgent(describeWorkspaceDirectoriesRequest));
    }

    @Override
    public DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest) throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceImagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspaceImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceImages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceImagesRequest).withMarshaller((Marshaller)new DescribeWorkspaceImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspaceSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaceSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceSnapshotsRequest).withMarshaller((Marshaller)new DescribeWorkspaceSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesRequest).withMarshaller((Marshaller)new DescribeWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWorkspacesIterable describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest) throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspacesIterable(this, this.applyPaginatorUserAgent(describeWorkspacesRequest));
    }

    @Override
    public DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesConnectionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWorkspacesConnectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkspacesConnectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesConnectionStatusRequest).withMarshaller((Marshaller)new DescribeWorkspacesConnectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest) throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateIpGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateIpGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateIpGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateIpGroupsRequest).withMarshaller((Marshaller)new DisassociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest) throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportWorkspaceImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ImportWorkspaceImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportWorkspaceImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importWorkspaceImageRequest).withMarshaller((Marshaller)new ImportWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest) throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableManagementCidrRangesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAvailableManagementCidrRangesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableManagementCidrRanges").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableManagementCidrRangesRequest).withMarshaller((Marshaller)new ListAvailableManagementCidrRangesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MigrateWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (MigrateWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MigrateWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)migrateWorkspaceRequest).withMarshaller((Marshaller)new MigrateWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest) throws InvalidParameterValuesException, AccessDeniedException, InvalidResourceStateException, ResourceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyAccountRequest).withMarshaller((Marshaller)new ModifyAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyClientPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyClientPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClientProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClientPropertiesRequest).withMarshaller((Marshaller)new ModifyClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifySelfservicePermissionsResponse modifySelfservicePermissions(ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifySelfservicePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifySelfservicePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySelfservicePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifySelfservicePermissionsRequest).withMarshaller((Marshaller)new ModifySelfservicePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceAccessPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyWorkspaceAccessPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceAccessProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceAccessPropertiesRequest).withMarshaller((Marshaller)new ModifyWorkspaceAccessPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceCreationPropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyWorkspaceCreationPropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceCreationProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceCreationPropertiesRequest).withMarshaller((Marshaller)new ModifyWorkspaceCreationPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException, InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException, ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspacePropertiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyWorkspacePropertiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceProperties").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspacePropertiesRequest).withMarshaller((Marshaller)new ModifyWorkspacePropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest) throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyWorkspaceStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyWorkspaceState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceStateRequest).withMarshaller((Marshaller)new ModifyWorkspaceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RebootWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootWorkspacesRequest).withMarshaller((Marshaller)new RebootWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebuildWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RebuildWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebuildWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebuildWorkspacesRequest).withMarshaller((Marshaller)new RebuildWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException, WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWorkspaceDirectoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterWorkspaceDirectoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWorkspaceDirectory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerWorkspaceDirectoryRequest).withMarshaller((Marshaller)new RegisterWorkspaceDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest) throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RestoreWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreWorkspaceRequest).withMarshaller((Marshaller)new RestoreWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeIpRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RevokeIpRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeIpRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeIpRulesRequest).withMarshaller((Marshaller)new RevokeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startWorkspacesRequest).withMarshaller((Marshaller)new StartWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopWorkspacesRequest).withMarshaller((Marshaller)new StopWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest) throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TerminateWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateWorkspacesRequest).withMarshaller((Marshaller)new TerminateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest) throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRulesOfIpGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRulesOfIpGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRulesOfIpGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRulesOfIpGroupRequest).withMarshaller((Marshaller)new UpdateRulesOfIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkSpacesException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException").exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException").exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException").exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").exceptionBuilderSupplier(OperationNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").exceptionBuilderSupplier(ResourceAssociatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").exceptionBuilderSupplier(InvalidParameterValuesException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressException").exceptionBuilderSupplier(OperationInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").exceptionBuilderSupplier(ResourceCreationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends WorkSpacesRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WorkSpacesRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

