/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateWorkspacesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<TerminateWorkspacesResponse.Builder, TerminateWorkspacesResponse> {
    private static final SdkField<List<FailedWorkspaceChangeRequest>> FAILED_REQUESTS_FIELD = SdkField
            .<List<FailedWorkspaceChangeRequest>> builder(MarshallingType.LIST)
            .getter(getter(TerminateWorkspacesResponse::failedRequests))
            .setter(setter(Builder::failedRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedWorkspaceChangeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedWorkspaceChangeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_REQUESTS_FIELD));

    private final List<FailedWorkspaceChangeRequest> failedRequests;

    private TerminateWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedRequests = builder.failedRequests;
    }

    /**
     * Returns true if the FailedRequests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedRequests() {
        return failedRequests != null && !(failedRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the WorkSpaces that could not be terminated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the WorkSpaces that could not be terminated.
     */
    public List<FailedWorkspaceChangeRequest> failedRequests() {
        return failedRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateWorkspacesResponse)) {
            return false;
        }
        TerminateWorkspacesResponse other = (TerminateWorkspacesResponse) obj;
        return Objects.equals(failedRequests(), other.failedRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminateWorkspacesResponse").add("FailedRequests", failedRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedRequests":
            return Optional.ofNullable(clazz.cast(failedRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateWorkspacesResponse, T> g) {
        return obj -> g.apply((TerminateWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, TerminateWorkspacesResponse> {
        /**
         * <p>
         * Information about the WorkSpaces that could not be terminated.
         * </p>
         * 
         * @param failedRequests
         *        Information about the WorkSpaces that could not be terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(Collection<FailedWorkspaceChangeRequest> failedRequests);

        /**
         * <p>
         * Information about the WorkSpaces that could not be terminated.
         * </p>
         * 
         * @param failedRequests
         *        Information about the WorkSpaces that could not be terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(FailedWorkspaceChangeRequest... failedRequests);

        /**
         * <p>
         * Information about the WorkSpaces that could not be terminated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedWorkspaceChangeRequest>.Builder}
         * avoiding the need to create one manually via {@link List<FailedWorkspaceChangeRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedWorkspaceChangeRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedRequests(List<FailedWorkspaceChangeRequest>)}.
         * 
         * @param failedRequests
         *        a consumer that will call methods on {@link List<FailedWorkspaceChangeRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedRequests(List<FailedWorkspaceChangeRequest>)
         */
        Builder failedRequests(Consumer<FailedWorkspaceChangeRequest.Builder>... failedRequests);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<FailedWorkspaceChangeRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateWorkspacesResponse model) {
            super(model);
            failedRequests(model.failedRequests);
        }

        public final Collection<FailedWorkspaceChangeRequest.Builder> getFailedRequests() {
            return failedRequests != null ? failedRequests.stream().map(FailedWorkspaceChangeRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedRequests(Collection<FailedWorkspaceChangeRequest> failedRequests) {
            this.failedRequests = FailedTerminateWorkspaceRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedWorkspaceChangeRequest... failedRequests) {
            failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedWorkspaceChangeRequest.Builder>... failedRequests) {
            failedRequests(Stream.of(failedRequests).map(c -> FailedWorkspaceChangeRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedRequests(Collection<FailedWorkspaceChangeRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedTerminateWorkspaceRequestsCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public TerminateWorkspacesResponse build() {
            return new TerminateWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
