/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the self-service permissions for a directory. For more information, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
 * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfservicePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfservicePermissions.Builder, SelfservicePermissions> {
    private static final SdkField<String> RESTART_WORKSPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SelfservicePermissions::restartWorkspaceAsString)).setter(setter(Builder::restartWorkspace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestartWorkspace").build()).build();

    private static final SdkField<String> INCREASE_VOLUME_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SelfservicePermissions::increaseVolumeSizeAsString)).setter(setter(Builder::increaseVolumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncreaseVolumeSize").build())
            .build();

    private static final SdkField<String> CHANGE_COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SelfservicePermissions::changeComputeTypeAsString)).setter(setter(Builder::changeComputeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeComputeType").build()).build();

    private static final SdkField<String> SWITCH_RUNNING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SelfservicePermissions::switchRunningModeAsString)).setter(setter(Builder::switchRunningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SwitchRunningMode").build()).build();

    private static final SdkField<String> REBUILD_WORKSPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SelfservicePermissions::rebuildWorkspaceAsString)).setter(setter(Builder::rebuildWorkspace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTART_WORKSPACE_FIELD,
            INCREASE_VOLUME_SIZE_FIELD, CHANGE_COMPUTE_TYPE_FIELD, SWITCH_RUNNING_MODE_FIELD, REBUILD_WORKSPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String restartWorkspace;

    private final String increaseVolumeSize;

    private final String changeComputeType;

    private final String switchRunningMode;

    private final String rebuildWorkspace;

    private SelfservicePermissions(BuilderImpl builder) {
        this.restartWorkspace = builder.restartWorkspace;
        this.increaseVolumeSize = builder.increaseVolumeSize;
        this.changeComputeType = builder.changeComputeType;
        this.switchRunningMode = builder.switchRunningMode;
        this.rebuildWorkspace = builder.rebuildWorkspace;
    }

    /**
     * <p>
     * Specifies whether users can restart their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #restartWorkspace}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #restartWorkspaceAsString}.
     * </p>
     * 
     * @return Specifies whether users can restart their WorkSpace.
     * @see ReconnectEnum
     */
    public ReconnectEnum restartWorkspace() {
        return ReconnectEnum.fromValue(restartWorkspace);
    }

    /**
     * <p>
     * Specifies whether users can restart their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #restartWorkspace}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #restartWorkspaceAsString}.
     * </p>
     * 
     * @return Specifies whether users can restart their WorkSpace.
     * @see ReconnectEnum
     */
    public String restartWorkspaceAsString() {
        return restartWorkspace;
    }

    /**
     * <p>
     * Specifies whether users can increase the volume size of the drives on their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #increaseVolumeSize} will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #increaseVolumeSizeAsString}.
     * </p>
     * 
     * @return Specifies whether users can increase the volume size of the drives on their WorkSpace.
     * @see ReconnectEnum
     */
    public ReconnectEnum increaseVolumeSize() {
        return ReconnectEnum.fromValue(increaseVolumeSize);
    }

    /**
     * <p>
     * Specifies whether users can increase the volume size of the drives on their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #increaseVolumeSize} will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #increaseVolumeSizeAsString}.
     * </p>
     * 
     * @return Specifies whether users can increase the volume size of the drives on their WorkSpace.
     * @see ReconnectEnum
     */
    public String increaseVolumeSizeAsString() {
        return increaseVolumeSize;
    }

    /**
     * <p>
     * Specifies whether users can change the compute type (bundle) for their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeComputeType}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeComputeTypeAsString}.
     * </p>
     * 
     * @return Specifies whether users can change the compute type (bundle) for their WorkSpace.
     * @see ReconnectEnum
     */
    public ReconnectEnum changeComputeType() {
        return ReconnectEnum.fromValue(changeComputeType);
    }

    /**
     * <p>
     * Specifies whether users can change the compute type (bundle) for their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeComputeType}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeComputeTypeAsString}.
     * </p>
     * 
     * @return Specifies whether users can change the compute type (bundle) for their WorkSpace.
     * @see ReconnectEnum
     */
    public String changeComputeTypeAsString() {
        return changeComputeType;
    }

    /**
     * <p>
     * Specifies whether users can switch the running mode of their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #switchRunningMode}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #switchRunningModeAsString}.
     * </p>
     * 
     * @return Specifies whether users can switch the running mode of their WorkSpace.
     * @see ReconnectEnum
     */
    public ReconnectEnum switchRunningMode() {
        return ReconnectEnum.fromValue(switchRunningMode);
    }

    /**
     * <p>
     * Specifies whether users can switch the running mode of their WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #switchRunningMode}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #switchRunningModeAsString}.
     * </p>
     * 
     * @return Specifies whether users can switch the running mode of their WorkSpace.
     * @see ReconnectEnum
     */
    public String switchRunningModeAsString() {
        return switchRunningMode;
    }

    /**
     * <p>
     * Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rebuildWorkspace}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rebuildWorkspaceAsString}.
     * </p>
     * 
     * @return Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
     * @see ReconnectEnum
     */
    public ReconnectEnum rebuildWorkspace() {
        return ReconnectEnum.fromValue(rebuildWorkspace);
    }

    /**
     * <p>
     * Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rebuildWorkspace}
     * will return {@link ReconnectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rebuildWorkspaceAsString}.
     * </p>
     * 
     * @return Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
     * @see ReconnectEnum
     */
    public String rebuildWorkspaceAsString() {
        return rebuildWorkspace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restartWorkspaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(increaseVolumeSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(changeComputeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(switchRunningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rebuildWorkspaceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfservicePermissions)) {
            return false;
        }
        SelfservicePermissions other = (SelfservicePermissions) obj;
        return Objects.equals(restartWorkspaceAsString(), other.restartWorkspaceAsString())
                && Objects.equals(increaseVolumeSizeAsString(), other.increaseVolumeSizeAsString())
                && Objects.equals(changeComputeTypeAsString(), other.changeComputeTypeAsString())
                && Objects.equals(switchRunningModeAsString(), other.switchRunningModeAsString())
                && Objects.equals(rebuildWorkspaceAsString(), other.rebuildWorkspaceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SelfservicePermissions").add("RestartWorkspace", restartWorkspaceAsString())
                .add("IncreaseVolumeSize", increaseVolumeSizeAsString()).add("ChangeComputeType", changeComputeTypeAsString())
                .add("SwitchRunningMode", switchRunningModeAsString()).add("RebuildWorkspace", rebuildWorkspaceAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestartWorkspace":
            return Optional.ofNullable(clazz.cast(restartWorkspaceAsString()));
        case "IncreaseVolumeSize":
            return Optional.ofNullable(clazz.cast(increaseVolumeSizeAsString()));
        case "ChangeComputeType":
            return Optional.ofNullable(clazz.cast(changeComputeTypeAsString()));
        case "SwitchRunningMode":
            return Optional.ofNullable(clazz.cast(switchRunningModeAsString()));
        case "RebuildWorkspace":
            return Optional.ofNullable(clazz.cast(rebuildWorkspaceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfservicePermissions, T> g) {
        return obj -> g.apply((SelfservicePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfservicePermissions> {
        /**
         * <p>
         * Specifies whether users can restart their WorkSpace.
         * </p>
         * 
         * @param restartWorkspace
         *        Specifies whether users can restart their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder restartWorkspace(String restartWorkspace);

        /**
         * <p>
         * Specifies whether users can restart their WorkSpace.
         * </p>
         * 
         * @param restartWorkspace
         *        Specifies whether users can restart their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder restartWorkspace(ReconnectEnum restartWorkspace);

        /**
         * <p>
         * Specifies whether users can increase the volume size of the drives on their WorkSpace.
         * </p>
         * 
         * @param increaseVolumeSize
         *        Specifies whether users can increase the volume size of the drives on their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder increaseVolumeSize(String increaseVolumeSize);

        /**
         * <p>
         * Specifies whether users can increase the volume size of the drives on their WorkSpace.
         * </p>
         * 
         * @param increaseVolumeSize
         *        Specifies whether users can increase the volume size of the drives on their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder increaseVolumeSize(ReconnectEnum increaseVolumeSize);

        /**
         * <p>
         * Specifies whether users can change the compute type (bundle) for their WorkSpace.
         * </p>
         * 
         * @param changeComputeType
         *        Specifies whether users can change the compute type (bundle) for their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder changeComputeType(String changeComputeType);

        /**
         * <p>
         * Specifies whether users can change the compute type (bundle) for their WorkSpace.
         * </p>
         * 
         * @param changeComputeType
         *        Specifies whether users can change the compute type (bundle) for their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder changeComputeType(ReconnectEnum changeComputeType);

        /**
         * <p>
         * Specifies whether users can switch the running mode of their WorkSpace.
         * </p>
         * 
         * @param switchRunningMode
         *        Specifies whether users can switch the running mode of their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder switchRunningMode(String switchRunningMode);

        /**
         * <p>
         * Specifies whether users can switch the running mode of their WorkSpace.
         * </p>
         * 
         * @param switchRunningMode
         *        Specifies whether users can switch the running mode of their WorkSpace.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder switchRunningMode(ReconnectEnum switchRunningMode);

        /**
         * <p>
         * Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
         * </p>
         * 
         * @param rebuildWorkspace
         *        Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder rebuildWorkspace(String rebuildWorkspace);

        /**
         * <p>
         * Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
         * </p>
         * 
         * @param rebuildWorkspace
         *        Specifies whether users can rebuild the operating system of a WorkSpace to its original state.
         * @see ReconnectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconnectEnum
         */
        Builder rebuildWorkspace(ReconnectEnum rebuildWorkspace);
    }

    static final class BuilderImpl implements Builder {
        private String restartWorkspace;

        private String increaseVolumeSize;

        private String changeComputeType;

        private String switchRunningMode;

        private String rebuildWorkspace;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfservicePermissions model) {
            restartWorkspace(model.restartWorkspace);
            increaseVolumeSize(model.increaseVolumeSize);
            changeComputeType(model.changeComputeType);
            switchRunningMode(model.switchRunningMode);
            rebuildWorkspace(model.rebuildWorkspace);
        }

        public final String getRestartWorkspace() {
            return restartWorkspace;
        }

        @Override
        public final Builder restartWorkspace(String restartWorkspace) {
            this.restartWorkspace = restartWorkspace;
            return this;
        }

        @Override
        public final Builder restartWorkspace(ReconnectEnum restartWorkspace) {
            this.restartWorkspace(restartWorkspace == null ? null : restartWorkspace.toString());
            return this;
        }

        public final void setRestartWorkspace(String restartWorkspace) {
            this.restartWorkspace = restartWorkspace;
        }

        public final String getIncreaseVolumeSize() {
            return increaseVolumeSize;
        }

        @Override
        public final Builder increaseVolumeSize(String increaseVolumeSize) {
            this.increaseVolumeSize = increaseVolumeSize;
            return this;
        }

        @Override
        public final Builder increaseVolumeSize(ReconnectEnum increaseVolumeSize) {
            this.increaseVolumeSize(increaseVolumeSize == null ? null : increaseVolumeSize.toString());
            return this;
        }

        public final void setIncreaseVolumeSize(String increaseVolumeSize) {
            this.increaseVolumeSize = increaseVolumeSize;
        }

        public final String getChangeComputeType() {
            return changeComputeType;
        }

        @Override
        public final Builder changeComputeType(String changeComputeType) {
            this.changeComputeType = changeComputeType;
            return this;
        }

        @Override
        public final Builder changeComputeType(ReconnectEnum changeComputeType) {
            this.changeComputeType(changeComputeType == null ? null : changeComputeType.toString());
            return this;
        }

        public final void setChangeComputeType(String changeComputeType) {
            this.changeComputeType = changeComputeType;
        }

        public final String getSwitchRunningMode() {
            return switchRunningMode;
        }

        @Override
        public final Builder switchRunningMode(String switchRunningMode) {
            this.switchRunningMode = switchRunningMode;
            return this;
        }

        @Override
        public final Builder switchRunningMode(ReconnectEnum switchRunningMode) {
            this.switchRunningMode(switchRunningMode == null ? null : switchRunningMode.toString());
            return this;
        }

        public final void setSwitchRunningMode(String switchRunningMode) {
            this.switchRunningMode = switchRunningMode;
        }

        public final String getRebuildWorkspace() {
            return rebuildWorkspace;
        }

        @Override
        public final Builder rebuildWorkspace(String rebuildWorkspace) {
            this.rebuildWorkspace = rebuildWorkspace;
            return this;
        }

        @Override
        public final Builder rebuildWorkspace(ReconnectEnum rebuildWorkspace) {
            this.rebuildWorkspace(rebuildWorkspace == null ? null : rebuildWorkspace.toString());
            return this;
        }

        public final void setRebuildWorkspace(String rebuildWorkspace) {
            this.rebuildWorkspace = rebuildWorkspace;
        }

        @Override
        public SelfservicePermissions build() {
            return new SelfservicePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
