/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyWorkspacePropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyWorkspacePropertiesRequest.Builder, ModifyWorkspacePropertiesRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyWorkspacePropertiesRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField
            .<WorkspaceProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyWorkspacePropertiesRequest::workspaceProperties)).setter(setter(Builder::workspaceProperties))
            .constructor(WorkspaceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            WORKSPACE_PROPERTIES_FIELD));

    private final String workspaceId;

    private final WorkspaceProperties workspaceProperties;

    private ModifyWorkspacePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.workspaceProperties = builder.workspaceProperties;
    }

    /**
     * <p>
     * The identifier of the WorkSpace.
     * </p>
     * 
     * @return The identifier of the WorkSpace.
     */
    public String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The properties of the WorkSpace.
     * </p>
     * 
     * @return The properties of the WorkSpace.
     */
    public WorkspaceProperties workspaceProperties() {
        return workspaceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspacePropertiesRequest)) {
            return false;
        }
        ModifyWorkspacePropertiesRequest other = (ModifyWorkspacePropertiesRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(workspaceProperties(), other.workspaceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyWorkspacePropertiesRequest").add("WorkspaceId", workspaceId())
                .add("WorkspaceProperties", workspaceProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "WorkspaceProperties":
            return Optional.ofNullable(clazz.cast(workspaceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspacePropertiesRequest, T> g) {
        return obj -> g.apply((ModifyWorkspacePropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyWorkspacePropertiesRequest> {
        /**
         * <p>
         * The identifier of the WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The properties of the WorkSpace.
         * </p>
         * 
         * @param workspaceProperties
         *        The properties of the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceProperties(WorkspaceProperties workspaceProperties);

        /**
         * <p>
         * The properties of the WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceProperties.Builder} avoiding the need
         * to create one manually via {@link WorkspaceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #workspaceProperties(WorkspaceProperties)}.
         * 
         * @param workspaceProperties
         *        a consumer that will call methods on {@link WorkspaceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceProperties(WorkspaceProperties)
         */
        default Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return workspaceProperties(WorkspaceProperties.builder().applyMutation(workspaceProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private WorkspaceProperties workspaceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspacePropertiesRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            workspaceProperties(model.workspaceProperties);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return workspaceProperties != null ? workspaceProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspacePropertiesRequest build() {
            return new ModifyWorkspacePropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
