/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpGroupRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateIpGroupRequest.Builder, CreateIpGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_DESC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIpGroupRequest::groupDesc)).setter(setter(Builder::groupDesc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDesc").build()).build();

    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField
            .<List<IpRuleItem>> builder(MarshallingType.LIST)
            .getter(getter(CreateIpGroupRequest::userRules))
            .setter(setter(Builder::userRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRuleItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRuleItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateIpGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_DESC_FIELD, USER_RULES_FIELD, TAGS_FIELD));

    private final String groupName;

    private final String groupDesc;

    private final List<IpRuleItem> userRules;

    private final List<Tag> tags;

    private CreateIpGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.groupDesc = builder.groupDesc;
        this.userRules = builder.userRules;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The description of the group.
     * </p>
     * 
     * @return The description of the group.
     */
    public String groupDesc() {
        return groupDesc;
    }

    /**
     * Returns true if the UserRules property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserRules() {
        return userRules != null && !(userRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules to add to the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rules to add to the group.
     */
    public List<IpRuleItem> userRules() {
        return userRules;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupDesc());
        hashCode = 31 * hashCode + Objects.hashCode(userRules());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpGroupRequest)) {
            return false;
        }
        CreateIpGroupRequest other = (CreateIpGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupDesc(), other.groupDesc())
                && Objects.equals(userRules(), other.userRules()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateIpGroupRequest").add("GroupName", groupName()).add("GroupDesc", groupDesc())
                .add("UserRules", userRules()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupDesc":
            return Optional.ofNullable(clazz.cast(groupDesc()));
        case "UserRules":
            return Optional.ofNullable(clazz.cast(userRules()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpGroupRequest, T> g) {
        return obj -> g.apply((CreateIpGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpGroupRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The description of the group.
         * </p>
         * 
         * @param groupDesc
         *        The description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDesc(String groupDesc);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * 
         * @param userRules
         *        The rules to add to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(Collection<IpRuleItem> userRules);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * 
         * @param userRules
         *        The rules to add to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(IpRuleItem... userRules);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpRuleItem>.Builder} avoiding the need to
         * create one manually via {@link List<IpRuleItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpRuleItem>.Builder#build()} is called immediately and its
         * result is passed to {@link #userRules(List<IpRuleItem>)}.
         * 
         * @param userRules
         *        a consumer that will call methods on {@link List<IpRuleItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userRules(List<IpRuleItem>)
         */
        Builder userRules(Consumer<IpRuleItem.Builder>... userRules);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String groupName;

        private String groupDesc;

        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpGroupRequest model) {
            super(model);
            groupName(model.groupName);
            groupDesc(model.groupDesc);
            userRules(model.userRules);
            tags(model.tags);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupDesc() {
            return groupDesc;
        }

        @Override
        public final Builder groupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
            return this;
        }

        public final void setGroupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
        }

        public final Collection<IpRuleItem.Builder> getUserRules() {
            return userRules != null ? userRules.stream().map(IpRuleItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem... userRules) {
            userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder>... userRules) {
            userRules(Stream.of(userRules).map(c -> IpRuleItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpGroupRequest build() {
            return new CreateIpGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
