/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRulesOfIpGroupRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<UpdateRulesOfIpGroupRequest.Builder, UpdateRulesOfIpGroupRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRulesOfIpGroupRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField
            .<List<IpRuleItem>> builder(MarshallingType.LIST)
            .getter(getter(UpdateRulesOfIpGroupRequest::userRules))
            .setter(setter(Builder::userRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRuleItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRuleItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            USER_RULES_FIELD));

    private final String groupId;

    private final List<IpRuleItem> userRules;

    private UpdateRulesOfIpGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.userRules = builder.userRules;
    }

    /**
     * <p>
     * The identifier of the group.
     * </p>
     * 
     * @return The identifier of the group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * Returns true if the UserRules property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserRules() {
        return userRules != null && !(userRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more rules.
     */
    public List<IpRuleItem> userRules() {
        return userRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(userRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRulesOfIpGroupRequest)) {
            return false;
        }
        UpdateRulesOfIpGroupRequest other = (UpdateRulesOfIpGroupRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(userRules(), other.userRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRulesOfIpGroupRequest").add("GroupId", groupId()).add("UserRules", userRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "UserRules":
            return Optional.ofNullable(clazz.cast(userRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRulesOfIpGroupRequest, T> g) {
        return obj -> g.apply((UpdateRulesOfIpGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRulesOfIpGroupRequest> {
        /**
         * <p>
         * The identifier of the group.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * One or more rules.
         * </p>
         * 
         * @param userRules
         *        One or more rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(Collection<IpRuleItem> userRules);

        /**
         * <p>
         * One or more rules.
         * </p>
         * 
         * @param userRules
         *        One or more rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(IpRuleItem... userRules);

        /**
         * <p>
         * One or more rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpRuleItem>.Builder} avoiding the need to
         * create one manually via {@link List<IpRuleItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpRuleItem>.Builder#build()} is called immediately and its
         * result is passed to {@link #userRules(List<IpRuleItem>)}.
         * 
         * @param userRules
         *        a consumer that will call methods on {@link List<IpRuleItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userRules(List<IpRuleItem>)
         */
        Builder userRules(Consumer<IpRuleItem.Builder>... userRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String groupId;

        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRulesOfIpGroupRequest model) {
            super(model);
            groupId(model.groupId);
            userRules(model.userRules);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpRuleItem.Builder> getUserRules() {
            return userRules != null ? userRules.stream().map(IpRuleItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem... userRules) {
            userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder>... userRules) {
            userRules(Stream.of(userRules).map(c -> IpRuleItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRulesOfIpGroupRequest build() {
            return new UpdateRulesOfIpGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
