/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<StopWorkspacesRequest.Builder, StopWorkspacesRequest> {
    private static final SdkField<List<StopRequest>> STOP_WORKSPACE_REQUESTS_FIELD = SdkField
            .<List<StopRequest>> builder(MarshallingType.LIST)
            .getter(getter(StopWorkspacesRequest::stopWorkspaceRequests))
            .setter(setter(Builder::stopWorkspaceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopWorkspaceRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StopRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(StopRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STOP_WORKSPACE_REQUESTS_FIELD));

    private final List<StopRequest> stopWorkspaceRequests;

    private StopWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.stopWorkspaceRequests = builder.stopWorkspaceRequests;
    }

    /**
     * Returns true if the StopWorkspaceRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStopWorkspaceRequests() {
        return stopWorkspaceRequests != null && !(stopWorkspaceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStopWorkspaceRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
     */
    public List<StopRequest> stopWorkspaceRequests() {
        return stopWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stopWorkspaceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopWorkspacesRequest)) {
            return false;
        }
        StopWorkspacesRequest other = (StopWorkspacesRequest) obj;
        return Objects.equals(stopWorkspaceRequests(), other.stopWorkspaceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopWorkspacesRequest").add("StopWorkspaceRequests", stopWorkspaceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StopWorkspaceRequests":
            return Optional.ofNullable(clazz.cast(stopWorkspaceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopWorkspacesRequest, T> g) {
        return obj -> g.apply((StopWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopWorkspacesRequest> {
        /**
         * <p>
         * The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param stopWorkspaceRequests
         *        The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopWorkspaceRequests(Collection<StopRequest> stopWorkspaceRequests);

        /**
         * <p>
         * The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
         * </p>
         * 
         * @param stopWorkspaceRequests
         *        The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopWorkspaceRequests(StopRequest... stopWorkspaceRequests);

        /**
         * <p>
         * The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StopRequest>.Builder} avoiding the need to
         * create one manually via {@link List<StopRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StopRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link #stopWorkspaceRequests(List<StopRequest>)}.
         * 
         * @param stopWorkspaceRequests
         *        a consumer that will call methods on {@link List<StopRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopWorkspaceRequests(List<StopRequest>)
         */
        Builder stopWorkspaceRequests(Consumer<StopRequest.Builder>... stopWorkspaceRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<StopRequest> stopWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopWorkspacesRequest model) {
            super(model);
            stopWorkspaceRequests(model.stopWorkspaceRequests);
        }

        public final Collection<StopRequest.Builder> getStopWorkspaceRequests() {
            return stopWorkspaceRequests != null ? stopWorkspaceRequests.stream().map(StopRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stopWorkspaceRequests(Collection<StopRequest> stopWorkspaceRequests) {
            this.stopWorkspaceRequests = StopWorkspaceRequestsCopier.copy(stopWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopWorkspaceRequests(StopRequest... stopWorkspaceRequests) {
            stopWorkspaceRequests(Arrays.asList(stopWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopWorkspaceRequests(Consumer<StopRequest.Builder>... stopWorkspaceRequests) {
            stopWorkspaceRequests(Stream.of(stopWorkspaceRequests).map(c -> StopRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStopWorkspaceRequests(Collection<StopRequest.BuilderImpl> stopWorkspaceRequests) {
            this.stopWorkspaceRequests = StopWorkspaceRequestsCopier.copyFromBuilder(stopWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopWorkspacesRequest build() {
            return new StopWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
