/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebuildWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<RebuildWorkspacesRequest.Builder, RebuildWorkspacesRequest> {
    private static final SdkField<List<RebuildRequest>> REBUILD_WORKSPACE_REQUESTS_FIELD = SdkField
            .<List<RebuildRequest>> builder(MarshallingType.LIST)
            .getter(getter(RebuildWorkspacesRequest::rebuildWorkspaceRequests))
            .setter(setter(Builder::rebuildWorkspaceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspaceRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RebuildRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RebuildRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REBUILD_WORKSPACE_REQUESTS_FIELD));

    private final List<RebuildRequest> rebuildWorkspaceRequests;

    private RebuildWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.rebuildWorkspaceRequests = builder.rebuildWorkspaceRequests;
    }

    /**
     * Returns true if the RebuildWorkspaceRequests property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRebuildWorkspaceRequests() {
        return rebuildWorkspaceRequests != null && !(rebuildWorkspaceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The WorkSpace to rebuild. You can specify a single WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRebuildWorkspaceRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The WorkSpace to rebuild. You can specify a single WorkSpace.
     */
    public List<RebuildRequest> rebuildWorkspaceRequests() {
        return rebuildWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rebuildWorkspaceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebuildWorkspacesRequest)) {
            return false;
        }
        RebuildWorkspacesRequest other = (RebuildWorkspacesRequest) obj;
        return Objects.equals(rebuildWorkspaceRequests(), other.rebuildWorkspaceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RebuildWorkspacesRequest").add("RebuildWorkspaceRequests", rebuildWorkspaceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RebuildWorkspaceRequests":
            return Optional.ofNullable(clazz.cast(rebuildWorkspaceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebuildWorkspacesRequest, T> g) {
        return obj -> g.apply((RebuildWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, RebuildWorkspacesRequest> {
        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * 
         * @param rebuildWorkspaceRequests
         *        The WorkSpace to rebuild. You can specify a single WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests);

        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * 
         * @param rebuildWorkspaceRequests
         *        The WorkSpace to rebuild. You can specify a single WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebuildWorkspaceRequests(RebuildRequest... rebuildWorkspaceRequests);

        /**
         * <p>
         * The WorkSpace to rebuild. You can specify a single WorkSpace.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RebuildRequest>.Builder} avoiding the need
         * to create one manually via {@link List<RebuildRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RebuildRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #rebuildWorkspaceRequests(List<RebuildRequest>)}.
         * 
         * @param rebuildWorkspaceRequests
         *        a consumer that will call methods on {@link List<RebuildRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rebuildWorkspaceRequests(List<RebuildRequest>)
         */
        Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder>... rebuildWorkspaceRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<RebuildRequest> rebuildWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebuildWorkspacesRequest model) {
            super(model);
            rebuildWorkspaceRequests(model.rebuildWorkspaceRequests);
        }

        public final Collection<RebuildRequest.Builder> getRebuildWorkspaceRequests() {
            return rebuildWorkspaceRequests != null ? rebuildWorkspaceRequests.stream().map(RebuildRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copy(rebuildWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(RebuildRequest... rebuildWorkspaceRequests) {
            rebuildWorkspaceRequests(Arrays.asList(rebuildWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder>... rebuildWorkspaceRequests) {
            rebuildWorkspaceRequests(Stream.of(rebuildWorkspaceRequests)
                    .map(c -> RebuildRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRebuildWorkspaceRequests(Collection<RebuildRequest.BuilderImpl> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copyFromBuilder(rebuildWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebuildWorkspacesRequest build() {
            return new RebuildWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
