/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.BookingOptions;
import software.amazon.awssdk.services.workmail.model.EntityState;
import software.amazon.awssdk.services.workmail.model.ResourceType;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, DescribeResourceResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DescribeResourceResponse.getter(DescribeResourceResponse::resourceId)).setter(DescribeResourceResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(DescribeResourceResponse.getter(DescribeResourceResponse::email)).setter(DescribeResourceResponse.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeResourceResponse.getter(DescribeResourceResponse::name)).setter(DescribeResourceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeResourceResponse.getter(DescribeResourceResponse::typeAsString)).setter(DescribeResourceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<BookingOptions> BOOKING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BookingOptions").getter(DescribeResourceResponse.getter(DescribeResourceResponse::bookingOptions)).setter(DescribeResourceResponse.setter(Builder::bookingOptions)).constructor(BookingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BookingOptions").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeResourceResponse.getter(DescribeResourceResponse::stateAsString)).setter(DescribeResourceResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnabledDate").getter(DescribeResourceResponse.getter(DescribeResourceResponse::enabledDate)).setter(DescribeResourceResponse.setter(Builder::enabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()}).build();
    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisabledDate").getter(DescribeResourceResponse.getter(DescribeResourceResponse::disabledDate)).setter(DescribeResourceResponse.setter(Builder::disabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeResourceResponse.getter(DescribeResourceResponse::description)).setter(DescribeResourceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(DescribeResourceResponse.getter(DescribeResourceResponse::hiddenFromGlobalAddressList)).setter(DescribeResourceResponse.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, EMAIL_FIELD, NAME_FIELD, TYPE_FIELD, BOOKING_OPTIONS_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD, DESCRIPTION_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));
    private final String resourceId;
    private final String email;
    private final String name;
    private final String type;
    private final BookingOptions bookingOptions;
    private final String state;
    private final Instant enabledDate;
    private final Instant disabledDate;
    private final String description;
    private final Boolean hiddenFromGlobalAddressList;

    private DescribeResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.email = builder.email;
        this.name = builder.name;
        this.type = builder.type;
        this.bookingOptions = builder.bookingOptions;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
        this.description = builder.description;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String email() {
        return this.email;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceType type() {
        return ResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final BookingOptions bookingOptions() {
        return this.bookingOptions;
    }

    public final EntityState state() {
        return EntityState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant enabledDate() {
        return this.enabledDate;
    }

    public final Instant disabledDate() {
        return this.disabledDate;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bookingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceResponse)) {
            return false;
        }
        DescribeResourceResponse other = (DescribeResourceResponse)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.bookingOptions(), other.bookingOptions()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.enabledDate(), other.enabledDate()) && Objects.equals(this.disabledDate(), other.disabledDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceResponse").add("ResourceId", (Object)this.resourceId()).add("Email", (Object)this.email()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("BookingOptions", (Object)this.bookingOptions()).add("State", (Object)this.stateAsString()).add("EnabledDate", (Object)this.enabledDate()).add("DisabledDate", (Object)this.disabledDate()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "BookingOptions": {
                return Optional.ofNullable(clazz.cast(this.bookingOptions()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "EnabledDate": {
                return Optional.ofNullable(clazz.cast(this.enabledDate()));
            }
            case "DisabledDate": {
                return Optional.ofNullable(clazz.cast(this.disabledDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceResponse, T> g) {
        return obj -> g.apply((DescribeResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String resourceId;
        private String email;
        private String name;
        private String type;
        private BookingOptions bookingOptions;
        private String state;
        private Instant enabledDate;
        private Instant disabledDate;
        private String description;
        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceResponse model) {
            super(model);
            this.resourceId(model.resourceId);
            this.email(model.email);
            this.name(model.name);
            this.type(model.type);
            this.bookingOptions(model.bookingOptions);
            this.state(model.state);
            this.enabledDate(model.enabledDate);
            this.disabledDate(model.disabledDate);
            this.description(model.description);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final BookingOptions.Builder getBookingOptions() {
            return this.bookingOptions != null ? this.bookingOptions.toBuilder() : null;
        }

        public final void setBookingOptions(BookingOptions.BuilderImpl bookingOptions) {
            this.bookingOptions = bookingOptions != null ? bookingOptions.build() : null;
        }

        @Override
        public final Builder bookingOptions(BookingOptions bookingOptions) {
            this.bookingOptions = bookingOptions;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getEnabledDate() {
            return this.enabledDate;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final Instant getDisabledDate() {
            return this.disabledDate;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public DescribeResourceResponse build() {
            return new DescribeResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceResponse> {
        public Builder resourceId(String var1);

        public Builder email(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder bookingOptions(BookingOptions var1);

        default public Builder bookingOptions(Consumer<BookingOptions.Builder> bookingOptions) {
            return this.bookingOptions((BookingOptions)((BookingOptions.Builder)BookingOptions.builder().applyMutation(bookingOptions)).build());
        }

        public Builder state(String var1);

        public Builder state(EntityState var1);

        public Builder enabledDate(Instant var1);

        public Builder disabledDate(Instant var1);

        public Builder description(String var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);
    }
}

